/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml;

import com.caucho.util.CharBuffer;
import com.caucho.util.CharCursor;
import com.caucho.util.CharScanner;
import com.caucho.util.IntMap;
import com.caucho.util.StringCharCursor;
import com.caucho.xml.Policy;
import com.caucho.xml.QName;
import com.caucho.xml.XmlParseException;
import com.caucho.xml.XmlParser;
import java.io.IOException;
import java.util.Locale;
import org.w3c.dom.Element;

class HtmlPolicy
extends Policy {
    static final int DOCUMENT = 1;
    static final int COMMENT = 2;
    static final int TEXT = 3;
    static final int JSP = 4;
    static final int WHITESPACE = 5;
    static final int HTML = 6;
    static final int HEAD = 7;
    static final int TITLE = 8;
    static final int ISINDEX = 9;
    static final int BASE = 10;
    static final int SCRIPT = 11;
    static final int STYLE = 12;
    static final int META = 13;
    static final int LINK = 14;
    static final int OBJECT = 15;
    static final int BODY = 16;
    static final int BASEFONT = 17;
    static final int BR = 18;
    static final int AREA = 19;
    static final int IMG = 20;
    static final int PARAM = 21;
    static final int HR = 22;
    static final int INPUT = 23;
    static final int P = 24;
    static final int DT = 25;
    static final int DD = 26;
    static final int LI = 27;
    static final int OPTION = 28;
    static final int TABLE = 29;
    static final int CAPTION = 30;
    static final int THEAD = 31;
    static final int TFOOT = 32;
    static final int COL = 33;
    static final int COLGROUP = 34;
    static final int TBODY = 35;
    static final int TR = 36;
    static final int TD = 37;
    static final int TH = 38;
    static final int FRAME = 39;
    static final int FRAMESET = 40;
    static final int BLOCK = 41;
    static final int INLINE = 42;
    static IntMap names;
    static IntMap cbNames;
    static QName htmlName;
    static QName headName;
    static QName bodyName;
    boolean toLower = true;
    boolean isJsp = false;
    boolean autoHtml = false;
    boolean hasBody = false;
    boolean autoHead = false;
    CharBuffer cb = new CharBuffer();
    private static CharScanner charsetScanner;

    HtmlPolicy() {
    }

    public void init() {
        this.toLower = true;
        this.isJsp = false;
        this.autoHtml = false;
        this.hasBody = false;
        this.autoHead = false;
    }

    public void setToLower(boolean toLower) {
        this.toLower = toLower;
    }

    public void setJsp(boolean isJsp) {
        this.isJsp = isJsp;
    }

    QName getName(CharBuffer tag) {
        if (!this.toLower) {
            return super.getName(tag);
        }
        this.cb.clear();
        this.cb.append(tag);
        this.cb.toLowerCase();
        int name = cbNames.get(this.cb);
        if (name >= 0) {
            return super.getName(this.cb);
        }
        return super.getName(tag);
    }

    QName getAttributeName(CharBuffer eltName, CharBuffer source) {
        if (!this.toLower) {
            return super.getName(source);
        }
        this.cb.clear();
        this.cb.append(eltName);
        this.cb.toLowerCase();
        int name = cbNames.get(this.cb);
        if (name < 0) {
            return super.getName(source);
        }
        source.toLowerCase();
        return super.getName(source);
    }

    int openAction(XmlParser parser, QName node, QName next) throws XmlParseException {
        String nodeName = node == null ? "#document" : node.getName();
        String nextName = next.getName();
        int nextCode = names.get(nextName);
        switch (names.get(nodeName)) {
            case 1: {
                switch (nextCode) {
                    case 6: {
                        return 2;
                    }
                    case 2: {
                        return 2;
                    }
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        this.opt = htmlName;
                        return 4;
                    }
                    case 5: {
                        return 1;
                    }
                    case 4: {
                        return 2;
                    }
                }
                if (this.autoHtml) {
                    return 2;
                }
                this.autoHtml = true;
                this.opt = htmlName;
                return 4;
            }
            case 6: {
                switch (nextCode) {
                    case 6: {
                        return 0;
                    }
                    case 2: 
                    case 7: 
                    case 40: {
                        return 2;
                    }
                    case 16: {
                        this.hasBody = true;
                        return 2;
                    }
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        this.opt = headName;
                        this.autoHead = true;
                        return 4;
                    }
                    case 5: {
                        return 2;
                    }
                    case 4: {
                        return 2;
                    }
                }
                if (this.hasBody) {
                    return 2;
                }
                this.hasBody = true;
                this.opt = bodyName;
                return 4;
            }
            case 7: {
                switch (nextCode) {
                    case 13: {
                        return 3;
                    }
                    case 9: 
                    case 10: 
                    case 14: {
                        return 3;
                    }
                    case 11: 
                    case 12: {
                        return 5;
                    }
                    case 8: 
                    case 15: {
                        return 2;
                    }
                    case 5: {
                        return 2;
                    }
                    case 3: 
                    case 4: {
                        if (this.autoHead) {
                            return 6;
                        }
                        return 2;
                    }
                }
                return 6;
            }
            case 27: {
                switch (nextCode) {
                    case 27: {
                        return 6;
                    }
                    case 9: 
                    case 10: 
                    case 13: 
                    case 14: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 33: 
                    case 39: {
                        return 3;
                    }
                    case 11: 
                    case 12: {
                        return 5;
                    }
                }
                return 2;
            }
            case 28: {
                switch (nextCode) {
                    case 3: 
                    case 5: {
                        return 2;
                    }
                }
                return 6;
            }
            case 26: {
                switch (nextCode) {
                    case 25: 
                    case 26: {
                        return 6;
                    }
                    case 9: 
                    case 10: 
                    case 13: 
                    case 14: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 33: 
                    case 39: {
                        return 3;
                    }
                    case 11: 
                    case 12: {
                        return 5;
                    }
                }
                return 2;
            }
            case 31: 
            case 32: 
            case 34: {
                switch (nextCode) {
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: {
                        return 6;
                    }
                    case 9: 
                    case 10: 
                    case 13: 
                    case 14: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 39: {
                        return 3;
                    }
                    case 11: 
                    case 12: {
                        return 5;
                    }
                }
                return 2;
            }
            case 36: {
                switch (nextCode) {
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: {
                        return 6;
                    }
                    case 9: 
                    case 10: 
                    case 13: 
                    case 14: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 39: {
                        return 3;
                    }
                    case 37: 
                    case 38: {
                        return 2;
                    }
                    case 11: 
                    case 12: {
                        return 5;
                    }
                }
                return 2;
            }
            case 37: 
            case 38: {
                switch (nextCode) {
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: {
                        return 6;
                    }
                    case 9: 
                    case 10: 
                    case 13: 
                    case 14: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 39: {
                        return 3;
                    }
                    case 11: 
                    case 12: {
                        return 5;
                    }
                }
                return 2;
            }
            case 24: 
            case 25: {
                switch (nextCode) {
                    case 24: 
                    case 25: 
                    case 27: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 41: {
                        return 6;
                    }
                    case 9: 
                    case 10: 
                    case 13: 
                    case 14: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 33: 
                    case 39: {
                        return 3;
                    }
                    case 11: 
                    case 12: {
                        return 5;
                    }
                }
                return 2;
            }
            case 29: {
                switch (nextCode) {
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: {
                        return 2;
                    }
                    case 11: 
                    case 12: {
                        return 5;
                    }
                }
                return 2;
            }
        }
        switch (nextCode) {
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 33: 
            case 39: {
                return 3;
            }
            case 11: 
            case 12: {
                return 5;
            }
        }
        return 2;
    }

    private void checkMetaEncoding(Element elt) {
        block4: {
            String http = elt.getAttribute("http-equiv");
            String content = elt.getAttribute("content");
            if (http.equals("") || content.equals("") || !http.equalsIgnoreCase("content-type")) {
                return;
            }
            StringCharCursor cursor = new StringCharCursor(content);
            charsetScanner.scan(cursor);
            charsetScanner.skip(cursor);
            CharBuffer buf = CharBuffer.allocate();
            while (true) {
                if (((CharCursor)cursor).current() == '\uffff') break block4;
                buf.clear();
                charsetScanner.scan(cursor, buf);
                if (!buf.toString().equalsIgnoreCase("charset")) continue;
                charsetScanner.skip(cursor);
                buf.clear();
                charsetScanner.scan(cursor, buf);
                if (buf.length() > 0) break;
            }
            try {
                this.is.setEncoding(buf.close());
            }
            catch (IOException e) {
                // empty catch block
            }
            return;
        }
    }

    int elementCloseAction(XmlParser parser, QName node, String tagEnd) throws XmlParseException {
        String nodeName = node.getName();
        if (nodeName.equals(tagEnd)) {
            return 6;
        }
        if (nodeName == "#document" && tagEnd.equals("")) {
            return 6;
        }
        switch (names.get(tagEnd)) {
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 33: 
            case 39: {
                String errorTagEnd = tagEnd.equals("") ? L.l("end of file") : "`<" + tagEnd + ">'";
                throw parser.error(L.l("{0} expects to be empty", (Object)errorTagEnd));
            }
        }
        switch (names.get(nodeName)) {
            case 16: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                return 7;
            }
            case 6: 
            case 7: {
                return 7;
            }
        }
        if (this.forgiving) {
            return 7;
        }
        String errorTagEnd = tagEnd.equals("") ? L.l("end of file") : "`</" + tagEnd + ">'";
        if (nodeName.equals("#document")) {
            throw parser.error(L.l("expected {0} at {1}", (Object)L.l("end of document"), (Object)errorTagEnd));
        }
        String expect = "`</" + nodeName + ">'";
        throw parser.error(L.l("expected {0} at {1} (open at {2})", (Object)expect, (Object)errorTagEnd, (Object)("" + parser.getNodeLine())));
    }

    private static void addName(String name, int code) {
        names.put(name, code);
        cbNames.put(new CharBuffer(name), code);
        String upper = name.toUpperCase(Locale.ENGLISH);
        names.put(upper, code);
        cbNames.put(new CharBuffer(upper), code);
    }

    static {
        htmlName = new QName(null, "html", null);
        headName = new QName(null, "head", null);
        bodyName = new QName(null, "body", null);
        charsetScanner = new CharScanner(" \t=;");
        names = new IntMap();
        cbNames = new IntMap();
        HtmlPolicy.addName("#document", 1);
        HtmlPolicy.addName("#comment", 2);
        HtmlPolicy.addName("#text", 3);
        HtmlPolicy.addName("#jsp", 4);
        HtmlPolicy.addName("#whitespace", 5);
        HtmlPolicy.addName("html", 6);
        HtmlPolicy.addName("head", 7);
        HtmlPolicy.addName("title", 8);
        HtmlPolicy.addName("isindex", 9);
        HtmlPolicy.addName("base", 10);
        HtmlPolicy.addName("script", 11);
        HtmlPolicy.addName("style", 12);
        HtmlPolicy.addName("meta", 13);
        HtmlPolicy.addName("link", 14);
        HtmlPolicy.addName("object", 15);
        HtmlPolicy.addName("body", 16);
        HtmlPolicy.addName("basefont", 17);
        HtmlPolicy.addName("br", 18);
        HtmlPolicy.addName("area", 19);
        HtmlPolicy.addName("link", 14);
        HtmlPolicy.addName("img", 20);
        HtmlPolicy.addName("param", 21);
        HtmlPolicy.addName("hr", 22);
        HtmlPolicy.addName("input", 23);
        HtmlPolicy.addName("frame", 39);
        HtmlPolicy.addName("p", 24);
        HtmlPolicy.addName("dt", 25);
        HtmlPolicy.addName("dd", 26);
        HtmlPolicy.addName("li", 27);
        HtmlPolicy.addName("option", 28);
        HtmlPolicy.addName("table", 29);
        HtmlPolicy.addName("caption", 30);
        HtmlPolicy.addName("thead", 31);
        HtmlPolicy.addName("tfoot", 32);
        HtmlPolicy.addName("col", 33);
        HtmlPolicy.addName("colgroup", 34);
        HtmlPolicy.addName("tbody", 35);
        HtmlPolicy.addName("tr", 36);
        HtmlPolicy.addName("th", 38);
        HtmlPolicy.addName("td", 37);
        HtmlPolicy.addName("h1", 41);
        HtmlPolicy.addName("h2", 41);
        HtmlPolicy.addName("h3", 41);
        HtmlPolicy.addName("h4", 41);
        HtmlPolicy.addName("h5", 41);
        HtmlPolicy.addName("h6", 41);
        HtmlPolicy.addName("ul", 41);
        HtmlPolicy.addName("ol", 41);
        HtmlPolicy.addName("dir", 41);
        HtmlPolicy.addName("menu", 41);
        HtmlPolicy.addName("pre", 41);
        HtmlPolicy.addName("dl", 41);
        HtmlPolicy.addName("div", 41);
        HtmlPolicy.addName("center", 41);
        HtmlPolicy.addName("noscript", 41);
        HtmlPolicy.addName("noframes", 41);
        HtmlPolicy.addName("blockquote", 41);
        HtmlPolicy.addName("form", 41);
        HtmlPolicy.addName("fieldset", 41);
        HtmlPolicy.addName("address", 41);
        HtmlPolicy.addName("tt", 42);
        HtmlPolicy.addName("i", 42);
        HtmlPolicy.addName("b", 42);
        HtmlPolicy.addName("u", 42);
        HtmlPolicy.addName("s", 42);
        HtmlPolicy.addName("strike", 42);
        HtmlPolicy.addName("big", 42);
        HtmlPolicy.addName("small", 42);
        HtmlPolicy.addName("em", 42);
        HtmlPolicy.addName("strong", 42);
        HtmlPolicy.addName("dfn", 42);
        HtmlPolicy.addName("code", 42);
        HtmlPolicy.addName("samp", 42);
        HtmlPolicy.addName("kbd", 42);
        HtmlPolicy.addName("var", 42);
        HtmlPolicy.addName("cite", 42);
        HtmlPolicy.addName("abbr", 42);
        HtmlPolicy.addName("acronym", 42);
        HtmlPolicy.addName("font", 42);
        HtmlPolicy.addName("iframe", 42);
        HtmlPolicy.addName("applet", 42);
        HtmlPolicy.addName("ins", 42);
        HtmlPolicy.addName("del", 42);
        HtmlPolicy.addName("a", 42);
        HtmlPolicy.addName("map", 42);
        HtmlPolicy.addName("q", 42);
        HtmlPolicy.addName("sub", 42);
        HtmlPolicy.addName("sup", 42);
        HtmlPolicy.addName("span", 42);
        HtmlPolicy.addName("bdo", 42);
        HtmlPolicy.addName("select", 42);
        HtmlPolicy.addName("textarea", 42);
        HtmlPolicy.addName("label", 42);
        HtmlPolicy.addName("optgroup", 42);
        HtmlPolicy.addName("button", 42);
        HtmlPolicy.addName("legend", 42);
        HtmlPolicy.addName("frameset", 40);
    }
}

