/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml.stream;

import com.caucho.util.L10N;
import com.caucho.xml.stream.NamespaceWriterContext;
import com.caucho.xml.stream.XMLStreamWriterImpl;
import com.caucho.xml.stream.XMLStreamWriterRepairingWrapper;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class StaxUtil {
    public static final L10N L = new L10N(StaxUtil.class);

    public static QName resolveStringToQName(String string, XMLStreamReader in) throws XMLStreamException {
        return StaxUtil.resolveStringToQName(string, in.getNamespaceContext());
    }

    public static QName resolveStringToQName(String string, NamespaceContext context) throws XMLStreamException {
        int colon = string.indexOf(58);
        if (colon < 0) {
            return new QName(string);
        }
        if (colon + 1 >= string.length()) {
            throw new XMLStreamException(L.l("Invalid qualified name: {0}", (Object)string));
        }
        String prefix = string.substring(0, colon);
        String localName = string.substring(colon + 1);
        String namespace = context.getNamespaceURI(prefix);
        if ("".equals(namespace)) {
            throw new XMLStreamException(L.l("No namespace for qualifed name: {0}", (Object)string));
        }
        return new QName(namespace, localName, prefix);
    }

    public static void repairNamespace(XMLStreamWriter out, String namespace) throws XMLStreamException {
        try {
            Object repairing = out.getProperty("javax.xml.stream.isRepairingNamespaces");
            if (Boolean.TRUE.equals(repairing)) {
                return;
            }
        }
        catch (IllegalArgumentException e) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        StaxUtil.getNamespacePrefix(out, namespace);
    }

    public static String getNamespacePrefix(XMLStreamWriter out, String namespace) throws XMLStreamException {
        boolean found;
        NamespaceContext context = out.getNamespaceContext();
        String prefix = context.getPrefix(namespace);
        if (prefix != null) {
            return prefix;
        }
        if (context instanceof NamespaceWriterContext) {
            NamespaceWriterContext writerContext = (NamespaceWriterContext)context;
            boolean repair = writerContext.getRepair();
            writerContext.setRepair(true);
            prefix = writerContext.declare(namespace);
            writerContext.setRepair(repair);
            return prefix;
        }
        int i = 0;
        String unique = "ns" + i;
        block0: do {
            found = false;
            Iterator<String> iterator = context.getPrefixes(namespace);
            while (iterator.hasNext()) {
                prefix = iterator.next().toString();
                if (!prefix.equals(unique)) continue;
                unique = "ns" + ++i;
                found = true;
                continue block0;
            }
        } while (found);
        out.writeNamespace(unique, namespace);
        return unique;
    }

    public static void repairNamespace(XMLStreamWriter out, String prefix, String namespace) throws XMLStreamException {
        try {
            Object repairing = out.getProperty("javax.xml.stream.isRepairingNamespaces");
            if (Boolean.TRUE.equals(repairing)) {
                return;
            }
        }
        catch (IllegalArgumentException e) {
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        NamespaceContext context = out.getNamespaceContext();
        String oldPrefix = context.getPrefix(namespace);
        if (!prefix.equals(oldPrefix)) {
            out.writeNamespace(prefix, namespace);
        }
    }

    public static XMLStreamWriter toRepairingXMLStreamWriter(XMLStreamWriter out) {
        try {
            Object repairing = out.getProperty("javax.xml.stream.isRepairingNamespaces");
            if (Boolean.TRUE.equals(repairing)) {
                return out;
            }
        }
        catch (IllegalArgumentException e) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (out instanceof XMLStreamWriterImpl) {
            ((XMLStreamWriterImpl)out).setRepair(true);
            return out;
        }
        return new XMLStreamWriterRepairingWrapper(out);
    }

    public static void copyReaderToWriter(XMLStreamReader in, XMLStreamWriter out) throws XMLStreamException {
        int depth = 0;
        do {
            switch (in.getEventType()) {
                case 10: {
                    break;
                }
                case 12: {
                    out.writeCData(in.getText());
                    break;
                }
                case 4: {
                    out.writeCharacters(in.getText());
                    break;
                }
                case 5: {
                    out.writeComment(in.getText());
                    break;
                }
                case 11: {
                    out.writeDTD(in.getText());
                    break;
                }
                case 8: {
                    out.writeEndDocument();
                    break;
                }
                case 2: {
                    if (--depth < 0) {
                        out.flush();
                        return;
                    }
                    out.writeEndElement();
                    break;
                }
                case 9: {
                    out.writeEntityRef(in.getText());
                    break;
                }
                case 13: {
                    break;
                }
                case 3: {
                    out.writeProcessingInstruction(in.getPITarget(), in.getPIData());
                    break;
                }
                case 6: {
                    out.writeCharacters(in.getText());
                    break;
                }
                case 7: {
                    out.writeStartDocument(in.getEncoding(), in.getVersion());
                    break;
                }
                case 1: {
                    int i;
                    QName qname = in.getName();
                    if (qname.getNamespaceURI() == null || "".equals(qname.getNamespaceURI())) {
                        out.writeStartElement(qname.getLocalPart());
                    } else if (qname.getPrefix() == null || "".equals(qname.getPrefix())) {
                        out.writeStartElement(qname.getNamespaceURI(), qname.getLocalPart());
                    } else {
                        out.writeStartElement(qname.getPrefix(), qname.getLocalPart(), qname.getNamespaceURI());
                    }
                    for (i = 0; i < in.getAttributeCount(); ++i) {
                        qname = in.getAttributeName(i);
                        String value = in.getAttributeValue(i);
                        if (qname.getNamespaceURI() == null || "".equals(qname.getNamespaceURI())) {
                            out.writeAttribute(qname.getLocalPart(), value);
                            continue;
                        }
                        if (qname.getPrefix() == null || "".equals(qname.getPrefix())) {
                            out.writeAttribute(qname.getNamespaceURI(), qname.getLocalPart(), value);
                            continue;
                        }
                        out.writeAttribute(qname.getPrefix(), qname.getNamespaceURI(), qname.getLocalPart(), value);
                    }
                    for (i = 0; i < in.getNamespaceCount(); ++i) {
                        out.writeNamespace(in.getNamespacePrefix(i), in.getNamespaceURI(i));
                    }
                    ++depth;
                }
            }
            if (!in.hasNext()) break;
            in.next();
        } while (depth >= 0);
        out.flush();
    }

    public static String constantToString(int constant) throws XMLStreamException {
        switch (constant) {
            case 10: {
                return "ATTRIBUTE";
            }
            case 12: {
                return "CDATA";
            }
            case 4: {
                return "CHARACTERS";
            }
            case 5: {
                return "COMMENT";
            }
            case 11: {
                return "DTD";
            }
            case 8: {
                return "END_DOCUMENT";
            }
            case 2: {
                return "END_ELEMENT";
            }
            case 15: {
                return "ENTITY_DECLARATION";
            }
            case 9: {
                return "ENTITY_REFERENCE";
            }
            case 13: {
                return "NAMESPACE";
            }
            case 14: {
                return "NOTATION_DECLARATION";
            }
            case 3: {
                return "PROCESSING_INSTRUCTION";
            }
            case 6: {
                return "SPACE";
            }
            case 7: {
                return "START_DOCUMENT";
            }
            case 1: {
                return "START_ELEMENT";
            }
            case -1: {
                throw new XMLStreamException(L.l("Unexpected end of stream"));
            }
        }
        throw new RuntimeException(L.l("constantToString({0}) unknown", constant));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String printStreamState(XMLStreamReader in) throws XMLStreamException {
        StringBuilder sb = new StringBuilder(StaxUtil.constantToString(in.getEventType()));
        if (in.getEventType() != 1) {
            if (in.getEventType() != 2) {
                if (in.getEventType() != 4) return sb.toString();
                sb.append(": ");
                sb.append(in.getText());
                return sb.toString();
            }
        }
        sb.append(": ");
        sb.append(in.getName());
        return sb.toString();
    }

    public static String qnameToString(XMLStreamWriter out, QName qname) throws XMLStreamException {
        if (qname.getNamespaceURI() == null || "".equals(qname.getNamespaceURI())) {
            return qname.getLocalPart();
        }
        NamespaceContext context = out.getNamespaceContext();
        String prefix = context.getPrefix(qname.getNamespaceURI());
        if (prefix == null) {
            if (qname.getPrefix() != null && !"".equals(qname.getPrefix())) {
                out.writeNamespace(qname.getPrefix(), qname.getNamespaceURI());
                return qname.getPrefix() + ':' + qname.getLocalPart();
            }
            prefix = StaxUtil.getNamespacePrefix(out, qname.getNamespaceURI());
            out.writeNamespace(prefix, qname.getNamespaceURI());
        }
        return prefix + ':' + qname.getLocalPart();
    }

    public static void writeStartElement(XMLStreamWriter out, QName name) throws XMLStreamException {
        if (name == null) {
            return;
        }
        if (name.getPrefix() != null && !"".equals(name.getPrefix())) {
            out.writeStartElement(name.getPrefix(), name.getLocalPart(), name.getNamespaceURI());
        } else if (name.getNamespaceURI() != null && !"".equals(name.getNamespaceURI())) {
            out.writeStartElement(name.getNamespaceURI(), name.getLocalPart());
        } else {
            out.writeStartElement(name.getLocalPart());
        }
    }

    public static void writeEndElement(XMLStreamWriter out, QName name) throws XMLStreamException {
        if (name == null) {
            return;
        }
        out.writeEndElement();
    }

    public static void writeAttribute(XMLStreamWriter out, QName name, String value) throws XMLStreamException {
        if (name.getNamespaceURI() == null || "".equals(name.getNamespaceURI())) {
            out.writeAttribute(name.getLocalPart(), value);
        } else if (name.getPrefix() == null || "".equals(name.getPrefix())) {
            out.writeAttribute(name.getNamespaceURI(), name.getLocalPart(), value);
        } else {
            out.writeAttribute(name.getPrefix(), name.getNamespaceURI(), name.getLocalPart(), value);
        }
    }
}

