/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml.stream;

import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EndDocument;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.EntityDeclaration;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.NotationDeclaration;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class XMLEventWriterImpl
implements XMLEventWriter {
    private XMLStreamWriter _out;

    public XMLEventWriterImpl(XMLStreamWriter out) {
        this._out = out;
    }

    public XMLStreamWriter getXMLStreamWriter() {
        return this._out;
    }

    public void add(XMLEvent event) throws XMLStreamException {
        if (event instanceof Namespace) {
            Namespace namespace = (Namespace)event;
            if (namespace.isDefaultNamespaceDeclaration()) {
                this._out.writeDefaultNamespace(namespace.getNamespaceURI());
            } else {
                this._out.writeNamespace(namespace.getPrefix(), namespace.getNamespaceURI());
            }
        } else if (event instanceof Attribute) {
            Attribute attribute = (Attribute)event;
            QName name = attribute.getName();
            if (name.getPrefix() != null && !"".equals(name.getPrefix())) {
                this._out.writeAttribute(name.getPrefix(), name.getNamespaceURI(), name.getLocalPart(), attribute.getValue());
            } else if (name.getNamespaceURI() != null && !"".equals(name.getNamespaceURI())) {
                this._out.writeAttribute(name.getNamespaceURI(), name.getLocalPart(), attribute.getValue());
            } else {
                this._out.writeAttribute(name.getLocalPart(), attribute.getValue());
            }
        } else if (event instanceof Characters) {
            Characters characters = (Characters)event;
            switch (characters.getEventType()) {
                case 12: {
                    this._out.writeCData(characters.getData());
                    break;
                }
                default: {
                    this._out.writeCharacters(characters.getData());
                    break;
                }
            }
        } else if (event instanceof Comment) {
            Comment comment = (Comment)event;
            this._out.writeComment(comment.getText());
        } else if (event instanceof DTD) {
            DTD dtd = (DTD)event;
            this._out.writeDTD(dtd.getDocumentTypeDeclaration());
        } else if (event instanceof EndDocument) {
            this._out.writeEndDocument();
        } else if (event instanceof EndElement) {
            this._out.writeEndElement();
        } else {
            if (event instanceof EntityDeclaration) {
                throw new UnsupportedOperationException();
            }
            if (event instanceof EntityReference) {
                throw new UnsupportedOperationException();
            }
            if (event instanceof NotationDeclaration) {
                throw new UnsupportedOperationException();
            }
            if (event instanceof ProcessingInstruction) {
                ProcessingInstruction pi = (ProcessingInstruction)event;
                if (pi.getData() == null || "".equals(pi.getData())) {
                    this._out.writeProcessingInstruction(pi.getTarget());
                } else {
                    this._out.writeProcessingInstruction(pi.getTarget(), pi.getData());
                }
            } else if (event instanceof StartDocument) {
                StartDocument startDocument = (StartDocument)event;
                if (startDocument.encodingSet()) {
                    this._out.writeStartDocument(startDocument.getCharacterEncodingScheme(), startDocument.getVersion());
                } else if (startDocument.getVersion() != null && !"".equals(startDocument.getVersion())) {
                    this._out.writeStartDocument(startDocument.getVersion());
                } else {
                    this._out.writeStartDocument();
                }
            } else if (event instanceof StartElement) {
                StartElement startElement = (StartElement)event;
                QName name = startElement.getName();
                Iterator namespaces = startElement.getNamespaces();
                while (namespaces.hasNext()) {
                    this.add((Namespace)namespaces.next());
                }
                if (name.getPrefix() != null && !"".equals(name.getPrefix())) {
                    this._out.writeStartElement(name.getPrefix(), name.getLocalPart(), name.getNamespaceURI());
                } else if (name.getNamespaceURI() != null && !"".equals(name.getNamespaceURI())) {
                    this._out.writeStartElement(name.getNamespaceURI(), name.getLocalPart());
                } else {
                    this._out.writeStartElement(name.getLocalPart());
                }
                Iterator attributes = startElement.getAttributes();
                while (attributes.hasNext()) {
                    this.add((Attribute)attributes.next());
                }
            } else {
                throw new XMLStreamException();
            }
        }
    }

    public void add(XMLEventReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            this.add(reader.nextEvent());
        }
    }

    public void close() throws XMLStreamException {
        this._out.close();
    }

    public void flush() throws XMLStreamException {
        this._out.flush();
    }

    public NamespaceContext getNamespaceContext() {
        return this._out.getNamespaceContext();
    }

    public String getPrefix(String uri) throws XMLStreamException {
        return this._out.getPrefix(uri);
    }

    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this._out.setDefaultNamespace(uri);
    }

    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        this._out.setNamespaceContext(context);
    }

    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this._out.setPrefix(prefix, uri);
    }
}

