/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml.stream.events;

import com.caucho.xml.stream.events.XMLEventImpl;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartElementImpl
extends XMLEventImpl
implements StartElement {
    private final QName _name;
    private final HashMap<QName, Attribute> _attributes;
    private final HashMap<String, Namespace> _namespaces;
    private final NamespaceContext _namespaceContext;

    public StartElementImpl(QName name, HashMap<QName, Attribute> attributes, HashMap<String, Namespace> namespaces, NamespaceContext namespaceContext) {
        this._name = name;
        this._attributes = attributes;
        this._namespaces = namespaces;
        this._namespaceContext = namespaceContext;
    }

    @Override
    public Attribute getAttributeByName(QName name) {
        return this._attributes.get(name);
    }

    @Override
    public Iterator getAttributes() {
        return this._attributes.values().iterator();
    }

    @Override
    public QName getName() {
        return this._name;
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this._namespaceContext;
    }

    @Override
    public Iterator getNamespaces() {
        return this._namespaces.values().iterator();
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this._namespaces.get(prefix).getNamespaceURI();
    }

    @Override
    public int getEventType() {
        return 1;
    }

    @Override
    public void writeAsEncodedUnicode(Writer writer) throws XMLStreamException {
        try {
            writer.write("<" + this._name + ">");
            for (Attribute attribute : this._attributes.values()) {
                attribute.writeAsEncodedUnicode(writer);
            }
            for (Namespace namespace : this._namespaces.values()) {
                namespace.writeAsEncodedUnicode(writer);
            }
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("StartElement[" + this._name);
        for (Attribute attribute : this._attributes.values()) {
            sb.append(" ");
            sb.append(attribute.toString());
        }
        for (Namespace namespace : this._namespaces.values()) {
            sb.append(" ");
            sb.append(namespace.toString());
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof StartElement)) {
            return false;
        }
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        StartElement start = (StartElement)o;
        int namespaceCount = 0;
        Iterator namespaces = start.getNamespaces();
        while (namespaces.hasNext()) {
            Namespace ns2 = (Namespace)namespaces.next();
            ++namespaceCount;
            Namespace ns1 = this._namespaces.get(ns2.getPrefix());
            if (ns2.equals(ns1)) continue;
            return false;
        }
        if (namespaceCount < this._namespaces.size()) {
            return false;
        }
        int attributeCount = 0;
        Iterator attributes = start.getAttributes();
        while (attributes.hasNext()) {
            Attribute a2 = (Attribute)attributes.next();
            ++attributeCount;
            Attribute a1 = this._attributes.get(a2.getName());
            if (a2.equals(a1)) continue;
            return false;
        }
        if (attributeCount < this._attributes.size()) {
            return false;
        }
        return this.getName().equals(start.getName());
    }
}

