/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml2;

import com.caucho.server.util.CauchoSystem;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.VfsStream;
import com.caucho.xml2.ContentHandlerAdapter;
import com.caucho.xml2.DOMBuilder;
import com.caucho.xml2.Entities;
import com.caucho.xml2.QDocument;
import com.caucho.xml2.QDocumentType;
import com.caucho.xml2.RemoteURLException;
import com.caucho.xml2.XmlEntities;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Locale;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public abstract class AbstractParser
implements XMLReader,
Parser {
    static final Logger log = Logger.getLogger(AbstractParser.class.getName());
    static final L10N L = new L10N(AbstractParser.class);
    static Hashtable<String, String> _attrTypes = new Hashtable();
    static Entities _xmlEntities = new XmlEntities();
    boolean _isCoalescing = true;
    boolean _optionalTags = true;
    boolean _skipWhitespace;
    boolean _skipComments;
    boolean _strictComments;
    boolean _strictAttributes;
    boolean _entitiesAsText = false;
    boolean _expandEntities = true;
    boolean _strictCharacters;
    boolean _strictXml;
    boolean _singleTopElement;
    boolean _isNamespaceAware = true;
    boolean _isNamespacePrefixes = true;
    boolean _isSAXNamespaces = false;
    boolean _isXmlnsPrefix;
    boolean _isXmlnsAttribute;
    boolean _isValidating = false;
    boolean _isStaticEncoding = false;
    String _defaultEncoding = "UTF-8";
    ContentHandler _contentHandler;
    EntityResolver _entityResolver;
    DTDHandler _dtdHandler;
    LexicalHandler _lexicalHandler;
    ErrorHandler _errorHandler;
    Locale _locale;
    Entities _entities;
    QDocument _owner;
    QDocumentType _dtd;
    DOMBuilder _builder;
    Path _searchPath;
    String _publicId;
    String _systemId;
    String _filename;
    int _line = 1;

    AbstractParser() {
        this(null);
    }

    AbstractParser(QDocumentType dtd) {
        if (dtd == null) {
            dtd = new QDocumentType(null);
        }
        this._dtd = dtd;
        this._entities = _xmlEntities;
    }

    void clear() {
        this._isCoalescing = true;
        this._isNamespaceAware = true;
        this._isSAXNamespaces = false;
        this._isNamespacePrefixes = false;
        this._optionalTags = true;
        this._skipWhitespace = false;
        this._skipComments = false;
        this._strictComments = false;
        this._strictAttributes = false;
        this._entitiesAsText = false;
        this._expandEntities = true;
        this._strictCharacters = false;
        this._strictXml = false;
        this._singleTopElement = false;
        this._defaultEncoding = "UTF-8";
        this._isStaticEncoding = false;
    }

    void init() {
        this._isXmlnsPrefix = this._isNamespaceAware || this._isNamespacePrefixes;
        this._isXmlnsAttribute = this._isNamespacePrefixes || !this._isNamespaceAware;
    }

    public void setOwner(QDocument doc) {
        this._owner = doc;
    }

    public void setConfig(DocumentBuilderFactory factory) {
        if (this._builder == null) {
            this._builder = new DOMBuilder();
        }
        this._isCoalescing = factory.isCoalescing();
        this.setExpandEntities(factory.isExpandEntityReferences());
        this.setSkipComments(factory.isIgnoringComments());
        this.setSkipWhitespace(factory.isIgnoringElementContentWhitespace());
        this.setNamespaceAware(factory.isNamespaceAware());
        this.setNamespacePrefixes(false);
        this.setValidating(factory.isValidating());
    }

    public void setEntitiesAsText(boolean entitiesAsText) {
        this._entitiesAsText = entitiesAsText;
    }

    public boolean getEntitiesAsText() {
        return this._entitiesAsText;
    }

    public void setExpandEntities(boolean expandEntities) {
        this._expandEntities = expandEntities;
    }

    public void setSkipComments(boolean skipComments) {
        this._skipComments = skipComments;
    }

    public void setSkipWhitespace(boolean skipWhitespace) {
        this._skipWhitespace = skipWhitespace;
    }

    public boolean isCoalescing() {
        return this._isCoalescing;
    }

    public void setCoalescing(boolean isCoalescing) {
        this._isCoalescing = isCoalescing;
    }

    public boolean isValidating() {
        return this._isValidating;
    }

    public void setValidating(boolean isValidating) {
        this._isValidating = isValidating;
    }

    public boolean isNamespaceAware() {
        return this._isNamespaceAware;
    }

    public void setNamespaceAware(boolean isNamespaceAware) {
        this._isNamespaceAware = isNamespaceAware;
    }

    public boolean isSAXNamespaces() {
        return this._isSAXNamespaces;
    }

    public void setSAXNamespaces(boolean isNamespaces) {
        this._isSAXNamespaces = isNamespaces;
    }

    public boolean isNamespacePrefixes() {
        return this._isNamespacePrefixes;
    }

    public void setNamespacePrefixes(boolean isNamespaces) {
        this._isNamespacePrefixes = isNamespaces;
    }

    public boolean getSkipComments() {
        return this._skipComments;
    }

    public void setDefaultEncoding(String encoding) {
        this._defaultEncoding = encoding;
    }

    public String getDefaultEncoding() {
        return this._defaultEncoding;
    }

    public Object getProperty(String name) throws SAXNotRecognizedException {
        if (name.equals("http://xml.org/sax/properties/lexical-handler")) {
            return this._lexicalHandler;
        }
        if (name.equals("http://xml.org/sax/properties/dom-node")) {
            return null;
        }
        if (name.equals("http://xml.org/sax/properties/xml-string")) {
            return null;
        }
        throw new SAXNotRecognizedException(name);
    }

    public void setProperty(String name, Object obj) throws SAXNotSupportedException {
        if (name.equals("http://xml.org/sax/properties/lexical-handler")) {
            this._lexicalHandler = (LexicalHandler)obj;
        } else if (name.equals("http://xml.org/sax/handlers/LexicalHandler")) {
            this._lexicalHandler = (LexicalHandler)obj;
        } else {
            throw new SAXNotSupportedException(name);
        }
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException {
        if (name.equals("http://xml.org/sax/features/namespaces")) {
            return this._isSAXNamespaces;
        }
        if (name.equals("http://xml.org/sax/features/namespace-prefixes")) {
            return this._isNamespacePrefixes;
        }
        if (name.equals("http://xml.org/sax/features/string-interning")) {
            return true;
        }
        if (name.equals("http://xml.org/sax/features/validation")) {
            return this._isValidating;
        }
        if (name.equals("http://xml.org/sax/features/external-general-entities")) {
            return true;
        }
        if (name.equals("http://xml.org/sax/features/external-parameter-entities")) {
            return false;
        }
        if (name.equals("http://caucho.com/xml/features/skip-comments")) {
            return this._skipComments;
        }
        throw new SAXNotRecognizedException(name);
    }

    public void setFeature(String name, boolean value) throws SAXNotSupportedException {
        if (name.equals("http://xml.org/sax/features/namespaces")) {
            this._isNamespaceAware = value;
        } else if (name.equals("http://xml.org/sax/features/namespace-prefixes")) {
            this._isNamespacePrefixes = value;
            this._isNamespaceAware = true;
        } else if (name.equals("http://caucho.com/xml/features/skip-comments")) {
            this._skipComments = value;
        } else if (name.equals("http://xml.org/sax/features/validation")) {
            this._isValidating = value;
        } else {
            throw new SAXNotSupportedException(name);
        }
    }

    public void setLexicalHandler(LexicalHandler handler) {
        this._lexicalHandler = handler;
    }

    public void setEntityResolver(EntityResolver resolver) {
        this._entityResolver = resolver;
    }

    public EntityResolver getEntityResolver() {
        return this._entityResolver;
    }

    public void setDTDHandler(DTDHandler handler) {
        this._dtdHandler = handler;
    }

    public DTDHandler getDTDHandler() {
        return this._dtdHandler;
    }

    public void setContentHandler(ContentHandler handler) {
        this._contentHandler = handler;
    }

    public ContentHandler getContentHandler() {
        return this._contentHandler;
    }

    public void setDocumentHandler(DocumentHandler handler) {
        this._contentHandler = handler == null ? null : new ContentHandlerAdapter(handler);
    }

    public void setErrorHandler(ErrorHandler handler) {
        this._errorHandler = handler;
    }

    public ErrorHandler getErrorHandler() {
        return this._errorHandler;
    }

    public void setLocale(Locale locale) {
        this._locale = locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputSource source) throws IOException, SAXException {
        ReadStream stream;
        this.init();
        if (this._searchPath == null && source.getSystemId() != null) {
            this._searchPath = Vfs.lookup(source.getSystemId()).getParent();
        }
        this._systemId = source.getSystemId();
        this._publicId = source.getPublicId();
        String encoding = null;
        if (source.getByteStream() != null) {
            stream = Vfs.openRead(source.getByteStream());
            encoding = source.getEncoding();
        } else if (source.getCharacterStream() != null) {
            encoding = "UTF-8";
            this._isStaticEncoding = true;
            stream = Vfs.openRead(source.getCharacterStream());
        } else if (source.getSystemId() != null) {
            InputStream is = this.openStream(source.getSystemId(), source.getPublicId(), null, true);
            stream = Vfs.openRead(is);
            encoding = source.getEncoding();
        } else {
            throw new FileNotFoundException(L.l("invalid InputSource"));
        }
        if (encoding != null) {
            stream.setEncoding(encoding);
        }
        try {
            this.parseInt(stream);
            Object var6_5 = null;
            stream.close();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            stream.close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream is) throws IOException, SAXException {
        this.init();
        this._systemId = "stream";
        if (is instanceof ReadStream) {
            Path path = ((ReadStream)is).getPath();
            this._systemId = path.getURL();
            this._filename = path.getUserPath();
            if (this._searchPath == null && path != null) {
                this._searchPath = path.getParent();
            }
            this.parseInt((ReadStream)is);
        } else {
            ReadStream rs = VfsStream.openRead(is);
            try {
                this.parseInt(rs);
                Object var4_4 = null;
                if (rs != is) {
                    rs.close();
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (rs != is) {
                    rs.close();
                }
                throw throwable;
            }
        }
    }

    public void parse(InputStream is, String systemId) throws IOException, SAXException {
        this.init();
        this.parseImpl(is, systemId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseImpl(InputStream is, String systemId) throws IOException, SAXException {
        if (is instanceof ReadStream) {
            Path path = ((ReadStream)is).getPath();
            if (this._searchPath == null) {
                if (path != null) {
                    this._searchPath = path.getParent();
                    if (systemId != null) {
                        this._searchPath = this._searchPath.lookup(systemId).getParent();
                    }
                } else if (systemId != null) {
                    this._searchPath = Vfs.lookup(systemId).getParent();
                }
            }
            if (systemId == null) {
                systemId = path.getURL();
                this._filename = ((ReadStream)is).getUserPath();
            } else {
                this._filename = systemId;
            }
            this._systemId = systemId;
            this.parseInt((ReadStream)is);
        } else {
            if (systemId == null) {
                this._systemId = "anonymous.xml";
            } else {
                this._searchPath = Vfs.lookup(systemId).getParent();
                this._systemId = systemId;
            }
            ReadStream rs = VfsStream.openRead(is);
            try {
                this.parseInt(rs);
                Object var5_5 = null;
                if (rs != is) {
                    rs.close();
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (rs != is) {
                    rs.close();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(String systemId) throws IOException, SAXException {
        InputStream is = this.openTopStream(systemId, null);
        try {
            this.parse(is);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            is.close();
            throw throwable;
        }
        is.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(Path path) throws IOException, SAXException {
        this.init();
        if (this._searchPath == null) {
            this._searchPath = path.getParent();
        }
        ReadStream is = path.openRead();
        try {
            this.parseInt(is);
            Object var4_3 = null;
            is.close();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            is.close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseString(String string) throws IOException, SAXException {
        this.init();
        ReadStream is = Vfs.openString(string);
        try {
            this.parseInt(is);
            Object var4_3 = null;
            is.close();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            is.close();
            throw throwable;
        }
    }

    public Document parseDocument(InputSource source) throws IOException, SAXException {
        this.init();
        QDocument doc = new QDocument();
        if (this._builder == null) {
            this._builder = new DOMBuilder();
        }
        this._builder.init(doc);
        this.setOwner(doc);
        doc.setSystemId(source.getSystemId());
        this._builder.setSystemId(source.getSystemId());
        this._builder.setStrictXML(this._strictXml);
        this._builder.setCoalescing(this._isCoalescing);
        this._builder.setSkipWhitespace(this._skipWhitespace);
        this._contentHandler = this._builder;
        this.parse(source);
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document parseDocument(String systemId) throws IOException, SAXException {
        Document document;
        InputStream is = this.openTopStream(systemId, null);
        try {
            document = this.parseDocument(is);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            is.close();
            throw throwable;
        }
        is.close();
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document parseDocument(Path path) throws IOException, SAXException {
        if (this._searchPath == null) {
            this._searchPath = path.getParent();
        }
        ReadStream is = path.openRead();
        try {
            Document document = this.parseDocument(is);
            Object var5_4 = null;
            is.close();
            return document;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            is.close();
            throw throwable;
        }
    }

    public Document parseDocument(InputStream is) throws IOException, SAXException {
        return this.parseDocument(is, null);
    }

    public Document parseDocument(InputStream is, String systemId) throws IOException, SAXException {
        this.init();
        QDocument doc = new QDocument();
        this.parseDocument(doc, is, systemId);
        return doc;
    }

    public void parseDocument(QDocument doc, InputStream is, String systemId) throws IOException, SAXException {
        this._owner = doc;
        if (this._builder == null) {
            this._builder = new DOMBuilder();
        }
        this._builder.init(this._owner);
        this._builder.setSystemId(systemId);
        this._builder.setCoalescing(this._isCoalescing);
        this._builder.setSkipWhitespace(this._skipWhitespace);
        this._contentHandler = this._builder;
        this.parseImpl(is, systemId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document parseDocumentString(String string) throws IOException, SAXException {
        ReadStream is = Vfs.openString(string);
        try {
            this._isStaticEncoding = true;
            Document document = this.parseDocument(is);
            Object var5_4 = null;
            is.close();
            return document;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            is.close();
            throw throwable;
        }
    }

    public InputStream openStream(String systemId, String publicId) throws IOException, SAXException {
        return this.openStream(systemId, publicId, this._entityResolver, false);
    }

    public InputStream openTopStream(String systemId, String publicId) throws IOException, SAXException {
        return this.openStream(systemId, publicId, this._entityResolver, true);
    }

    public InputStream openStream(String systemId, String publicId, EntityResolver entityResolver) throws IOException, SAXException {
        return this.openStream(systemId, publicId, entityResolver, false);
    }

    protected InputStream openStream(String systemId, String publicId, EntityResolver entityResolver, boolean isTop) throws IOException, SAXException {
        char ch;
        InputSource source;
        boolean isAbsolute;
        int colon = systemId.indexOf(58);
        int slash = systemId.indexOf(47);
        boolean bl = isAbsolute = colon > 0 && (colon < slash || slash < 0);
        if (slash == 0 || !isAbsolute) {
            Path pwd = this._searchPath != null ? this._searchPath : Vfs.lookup(systemId).getParent();
            String newId = pwd.lookup(systemId).getURL();
            if (!newId.startsWith("error:")) {
                systemId = newId;
            } else {
                int tail = this._systemId.lastIndexOf(47);
                if (tail >= 0) {
                    systemId = this._systemId.substring(0, tail + 1) + systemId;
                }
            }
        }
        if (entityResolver != null && (source = entityResolver.resolveEntity(publicId, systemId)) != null) {
            this._filename = systemId;
            this._systemId = systemId;
            return this.openSource(source);
        }
        if (CauchoSystem.isWindows() && systemId.startsWith("file:") && systemId.length() > 7 && systemId.charAt(6) == ':' && ((ch = systemId.charAt(5)) >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z')) {
            colon = 1;
            isAbsolute = false;
            systemId = "/" + systemId.substring(5);
        }
        if (!(isTop || !isAbsolute || systemId.startsWith("file:") || systemId.startsWith("jar:") || colon == 1 && CauchoSystem.isWindows())) {
            throw new RemoteURLException(L.l("URL `{0}' was not opened because it is a remote URL.  Any URL scheme other than file: must be handled by a custom entity resolver.", (Object)systemId));
        }
        if (this._searchPath != null) {
            return this._searchPath.lookup(systemId).openRead();
        }
        return Vfs.lookup(systemId).openRead();
    }

    protected InputStream openSource(InputSource source) throws IOException, SAXException {
        if (source.getByteStream() != null) {
            return source.getByteStream();
        }
        if (source.getCharacterStream() != null) {
            return Vfs.openRead(source.getCharacterStream());
        }
        if (source.getSystemId() != null) {
            return Vfs.openRead(source.getSystemId());
        }
        throw new FileNotFoundException(L.l("invalid InputSource {0}", (Object)source));
    }

    abstract Document parseInt(ReadStream var1) throws IOException, SAXException;

    static {
        _attrTypes.put("CDATA", "CDATA");
        _attrTypes.put("ID", "ID");
        _attrTypes.put("IDREF", "IDREF");
        _attrTypes.put("IDREFS", "IDREFS");
        _attrTypes.put("ENTITY", "ENTITY");
        _attrTypes.put("ENTITIES", "ENTITIES");
        _attrTypes.put("NMTOKEN", "NMTOKEN");
        _attrTypes.put("NMTOKENS", "NMTOKENS");
    }
}

