/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.pattern;

import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.pattern.AbstractPattern;
import org.w3c.dom.Node;

public class NamespacePattern
extends AbstractPattern {
    private String _prefix;
    private int _nodeType;

    public NamespacePattern(AbstractPattern parent, String prefix, int nodeType) {
        super(parent);
        this._prefix = prefix;
        this._nodeType = nodeType;
        if (parent == null) {
            throw new RuntimeException();
        }
    }

    public double getPriority() {
        return -0.25;
    }

    public boolean match(Node node, ExprEnvironment env) throws XPathException {
        if (node == null) {
            return false;
        }
        if (node.getNodeType() != this._nodeType) {
            return false;
        }
        String prefix = node.getPrefix();
        if (!(prefix == this._prefix || prefix != null && prefix.equals(this._prefix))) {
            return false;
        }
        return this._parent.match(node, env);
    }

    public String toString() {
        switch (this._nodeType) {
            case 2: {
                return this._parent.toString() + "@" + this._prefix + ":*";
            }
            case 1: {
                return this._parent.toString() + this._prefix + ":*";
            }
        }
        return super.toString();
    }
}

