/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.impl;

import com.browseengine.bobo.api.BrowseFacet;
import com.browseengine.bobo.api.BrowseSelection;
import com.browseengine.bobo.api.ComparatorFactory;
import com.browseengine.bobo.api.FacetIterator;
import com.browseengine.bobo.api.FacetSpec;
import com.browseengine.bobo.facets.FacetCountCollector;
import com.browseengine.bobo.facets.data.FacetDataCache;
import com.browseengine.bobo.facets.impl.FacetHitcountComparatorFactory;
import com.browseengine.bobo.facets.impl.FacetValueComparatorFactory;
import com.browseengine.bobo.facets.impl.PathFacetHandler;
import com.browseengine.bobo.facets.impl.PathFacetIterator;
import com.browseengine.bobo.util.BigIntArray;
import com.browseengine.bobo.util.BigSegmentedArray;
import com.browseengine.bobo.util.BoundedPriorityQueue;
import com.browseengine.bobo.util.LazyBigIntArray;
import com.browseengine.bobo.util.ListMerger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class PathFacetCountCollector
implements FacetCountCollector {
    private static final Logger log = Logger.getLogger((String)PathFacetCountCollector.class.getName());
    private final BrowseSelection _sel;
    private final FacetSpec _ospec;
    protected BigSegmentedArray _count;
    private final String _name;
    private final String _sep;
    private final BigSegmentedArray _orderArray;
    protected final FacetDataCache _dataCache;
    private final ComparatorFactory _comparatorFactory;
    private final int _minHitCount;
    private int _maxCount;
    private static Pattern _splitPat;
    private String[] _stringData;
    private char[] _sepArray;
    private int _patStart;
    private int _patEnd;

    PathFacetCountCollector(String name, String sep, BrowseSelection sel, FacetSpec ospec, FacetDataCache dataCache) {
        this._sel = sel;
        this._ospec = ospec;
        this._name = name;
        this._dataCache = dataCache;
        this._sep = sep;
        this._sepArray = sep.toCharArray();
        this._count = new LazyBigIntArray(this._dataCache.freqs.length);
        log.info((Object)(name + ": " + this._count.size()));
        this._orderArray = this._dataCache.orderArray;
        this._minHitCount = ospec.getMinHitCount();
        this._maxCount = ospec.getMaxCount();
        if (this._maxCount < 1) {
            this._maxCount = this._count.size();
        }
        FacetSpec.FacetSortSpec sortOption = ospec.getOrderBy();
        switch (sortOption) {
            case OrderHitsDesc: {
                this._comparatorFactory = new FacetHitcountComparatorFactory();
                break;
            }
            case OrderValueAsc: {
                this._comparatorFactory = null;
                break;
            }
            case OrderByCustom: {
                this._comparatorFactory = ospec.getCustomComparatorFactory();
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid sort option: " + (Object)((Object)sortOption));
            }
        }
        _splitPat = Pattern.compile(this._sep);
        this._stringData = new String[10];
        this._patStart = 0;
        this._patEnd = 0;
    }

    @Override
    public BigSegmentedArray getCountDistribution() {
        return this._count;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void collect(int docid) {
        int i = this._orderArray.get(docid);
        this._count.add(i, this._count.get(i) + 1);
    }

    @Override
    public void collectAll() {
        this._count = BigIntArray.fromArray(this._dataCache.freqs);
    }

    @Override
    public BrowseFacet getFacet(String value) {
        return null;
    }

    @Override
    public int getFacetHitsCount(Object value) {
        return 0;
    }

    private void ensureCapacity(int minCapacity) {
        int oldCapacity = this._stringData.length;
        if (minCapacity > oldCapacity) {
            String[] oldData = this._stringData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this._stringData = new String[newCapacity];
            System.arraycopy(oldData, 0, this._stringData, Math.min(oldData.length, newCapacity), newCapacity);
        }
    }

    private int patListSize() {
        return this._patEnd - this._patStart;
    }

    public boolean splitString(String input) {
        this._patStart = 0;
        this._patEnd = 0;
        char[] str = input.toCharArray();
        int index = 0;
        int sepindex = 0;
        int tokStart = -1;
        int tokEnd = 0;
        while (index < input.length()) {
            for (sepindex = 0; sepindex < this._sepArray.length && str[index + sepindex] == this._sepArray[sepindex]; ++sepindex) {
            }
            if (sepindex == this._sepArray.length) {
                index += this._sepArray.length;
                if (tokStart >= 0) {
                    this.ensureCapacity(this._patEnd + 1);
                    this._stringData[this._patEnd++] = input.substring(tokStart, ++tokEnd);
                }
                tokStart = -1;
                continue;
            }
            if (tokStart < 0) {
                tokStart = index;
                tokEnd = index;
            } else {
                ++tokEnd;
            }
            ++index;
        }
        if (this._patEnd == 0) {
            return false;
        }
        if (tokStart >= 0) {
            this.ensureCapacity(this._patEnd + 1);
            this._stringData[this._patEnd++] = input.substring(tokStart, ++tokEnd);
        }
        str = null;
        while (this._patEnd > 0 && this._stringData[this.patListSize() - 1].equals("")) {
            --this._patEnd;
        }
        return true;
    }

    private List<BrowseFacet> getFacetsForPath(String selectedPath, int depth, boolean strict, int minCount, int maxCount) {
        LinkedList<BrowseFacet> list = new LinkedList<BrowseFacet>();
        BoundedPriorityQueue<BrowseFacet> pq = null;
        if (this._comparatorFactory != null) {
            final Comparator<BrowseFacet> comparator = this._comparatorFactory.newComparator();
            pq = new BoundedPriorityQueue<BrowseFacet>(new Comparator<BrowseFacet>(){

                @Override
                public int compare(BrowseFacet o1, BrowseFacet o2) {
                    return -comparator.compare(o1, o2);
                }
            }, maxCount);
        }
        String[] startParts = null;
        int startDepth = 0;
        if (selectedPath != null && selectedPath.length() > 0) {
            startParts = selectedPath.split(this._sep);
            startDepth = startParts.length;
            if (!selectedPath.endsWith(this._sep)) {
                selectedPath = selectedPath + this._sep;
            }
        }
        String currentPath = null;
        int currentCount = 0;
        int wantedDepth = startDepth + depth;
        int index = 0;
        if (selectedPath != null && selectedPath.length() > 0 && (index = this._dataCache.valArray.indexOf(selectedPath)) < 0) {
            index = -(index + 1);
        }
        StringBuffer buf = new StringBuffer();
        for (int i = index; i < this._count.size(); ++i) {
            BrowseFacet ch;
            if (this._count.get(i) < minCount) continue;
            String path = this._dataCache.valArray.get(i);
            int subCount = this._count.get(i);
            int pathDepth = 0;
            pathDepth = !this.splitString(path) ? 0 : this.patListSize();
            int tmpdepth = 0;
            if (startDepth != 0 && (startDepth <= 0 || !path.startsWith(selectedPath))) break;
            buf.delete(0, buf.length());
            int minDepth = Math.min(wantedDepth, pathDepth);
            tmpdepth = 0;
            for (int k = this._patStart; k < this._patEnd && tmpdepth < minDepth; ++k, ++tmpdepth) {
                buf.append(this._stringData[k]);
                if (this._stringData[k].endsWith(this._sep) || pathDepth == wantedDepth && k >= wantedDepth - 1) continue;
                buf.append(this._sep);
            }
            String wantedPath = buf.toString();
            if (currentPath == null) {
                currentPath = wantedPath;
                currentCount = subCount;
                continue;
            }
            if (wantedPath.equals(currentPath)) {
                if (strict) continue;
                currentCount += subCount;
                continue;
            }
            boolean directNode = false;
            if (wantedPath.endsWith(this._sep) && currentPath.equals(wantedPath.substring(0, wantedPath.length() - 1))) {
                directNode = true;
            }
            if (strict) {
                if (directNode) {
                    currentCount += subCount;
                    continue;
                }
                ch = new BrowseFacet(currentPath, currentCount);
                if (pq != null) {
                    pq.add(ch);
                } else if (list.size() < maxCount) {
                    list.add(ch);
                }
                currentPath = wantedPath;
                currentCount = subCount;
                continue;
            }
            if (!directNode) {
                ch = new BrowseFacet(currentPath, currentCount);
                if (pq != null) {
                    pq.add(ch);
                } else if (list.size() < maxCount) {
                    list.add(ch);
                }
                currentPath = wantedPath;
                currentCount = subCount;
                continue;
            }
            currentCount += subCount;
        }
        if (currentPath != null && currentCount > 0) {
            BrowseFacet ch = new BrowseFacet(currentPath, currentCount);
            if (pq != null) {
                pq.add(ch);
            } else if (list.size() < maxCount) {
                list.add(ch);
            }
        }
        if (pq != null) {
            BrowseFacet val;
            while ((val = (BrowseFacet)pq.poll()) != null) {
                list.addFirst(val);
            }
        }
        return list;
    }

    @Override
    public List<BrowseFacet> getFacets() {
        String[] paths;
        Properties props = this._sel == null ? null : this._sel.getSelectionProperties();
        int depth = PathFacetHandler.getDepth(props);
        boolean strict = PathFacetHandler.isStrict(props);
        String[] stringArray = paths = this._sel == null ? null : this._sel.getValues();
        if (paths == null || paths.length == 0) {
            return this.getFacetsForPath(null, depth, strict, this._minHitCount, this._maxCount);
        }
        if (paths.length == 1) {
            return this.getFacetsForPath(paths[0], depth, strict, this._minHitCount, this._maxCount);
        }
        LinkedList<BrowseFacet> finalList = new LinkedList<BrowseFacet>();
        ArrayList<Iterator<BrowseFacet>> iterList = new ArrayList<Iterator<BrowseFacet>>(paths.length);
        for (String path : paths) {
            List<BrowseFacet> subList = this.getFacetsForPath(path, depth, strict, this._minHitCount, this._maxCount);
            if (subList.size() <= 0) continue;
            iterList.add(subList.iterator());
        }
        Iterator<BrowseFacet> finalIter = ListMerger.mergeLists(iterList.toArray(new Iterator[iterList.size()]), this._comparatorFactory == null ? new FacetValueComparatorFactory().newComparator() : this._comparatorFactory.newComparator());
        while (finalIter.hasNext()) {
            BrowseFacet f = finalIter.next();
            finalList.addFirst(f);
        }
        return finalList;
    }

    @Override
    public void close() {
    }

    @Override
    public FacetIterator iterator() {
        String[] paths;
        Properties props = this._sel == null ? null : this._sel.getSelectionProperties();
        int depth = PathFacetHandler.getDepth(props);
        boolean strict = PathFacetHandler.isStrict(props);
        String[] stringArray = paths = this._sel == null ? null : this._sel.getValues();
        if (paths == null || paths.length == 0) {
            List<BrowseFacet> finalList = this.getFacetsForPath(null, depth, strict, Integer.MIN_VALUE, this._count.size());
            return new PathFacetIterator(finalList);
        }
        if (paths.length == 1) {
            List<BrowseFacet> finalList = this.getFacetsForPath(paths[0], depth, strict, Integer.MIN_VALUE, this._count.size());
            return new PathFacetIterator(finalList);
        }
        LinkedList<BrowseFacet> finalList = new LinkedList<BrowseFacet>();
        ArrayList<Iterator<BrowseFacet>> iterList = new ArrayList<Iterator<BrowseFacet>>(paths.length);
        for (String path : paths) {
            List<BrowseFacet> subList = this.getFacetsForPath(path, depth, strict, Integer.MIN_VALUE, this._count.size());
            if (subList.size() <= 0) continue;
            iterList.add(subList.iterator());
        }
        Iterator<BrowseFacet> finalIter = ListMerger.mergeLists(iterList.toArray(new Iterator[iterList.size()]), this._comparatorFactory == null ? new FacetValueComparatorFactory().newComparator() : this._comparatorFactory.newComparator());
        while (finalIter.hasNext()) {
            BrowseFacet f = finalIter.next();
            finalList.add(f);
        }
        return new PathFacetIterator(finalList);
    }
}

