/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.opensocial.service;

import com.liferay.opensocial.DuplicateGadgetURLException;
import com.liferay.opensocial.GadgetPortletCategoryNamesException;
import com.liferay.opensocial.GadgetURLException;
import com.liferay.opensocial.NoSuchGadgetException;
import com.liferay.opensocial.NoSuchOAuthConsumerException;
import com.liferay.opensocial.NoSuchOAuthTokenException;
import com.liferay.opensocial.model.GadgetClp;
import com.liferay.opensocial.model.OAuthConsumerClp;
import com.liferay.opensocial.model.OAuthTokenClp;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ClassLoaderObjectInputStream;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class ClpSerializer {
    private static Log _log = LogFactoryUtil.getLog(ClpSerializer.class);
    private static String _servletContextName;
    private static boolean _useReflectionToTranslateThrowable;

    static {
        _useReflectionToTranslateThrowable = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getServletContextName() {
        if (Validator.isNotNull((String)_servletContextName)) {
            return _servletContextName;
        }
        Class<ClpSerializer> clazz = ClpSerializer.class;
        synchronized (ClpSerializer.class) {
            block14: {
                block13: {
                    if (Validator.isNotNull((String)_servletContextName)) {
                        // ** MonitorExit[var0] (shouldn't be in output)
                        return _servletContextName;
                    }
                    try {
                        ClassLoader classLoader = ClpSerializer.class.getClassLoader();
                        Class<?> portletPropsClass = classLoader.loadClass("com.liferay.util.portlet.PortletProps");
                        Method getMethod = portletPropsClass.getMethod("get", String.class);
                        String portletPropsServletContextName = (String)getMethod.invoke(null, "opensocial-portlet-deployment-context");
                        if (Validator.isNotNull((String)portletPropsServletContextName)) {
                            _servletContextName = portletPropsServletContextName;
                        }
                    }
                    catch (Throwable throwable) {
                        if (!_log.isInfoEnabled()) break block13;
                        _log.info((Object)"Unable to locate deployment context from portlet properties");
                    }
                }
                if (Validator.isNull((String)_servletContextName)) {
                    try {
                        String propsUtilServletContextName = PropsUtil.get((String)"opensocial-portlet-deployment-context");
                        if (Validator.isNotNull((String)propsUtilServletContextName)) {
                            _servletContextName = propsUtilServletContextName;
                        }
                    }
                    catch (Throwable throwable) {
                        if (!_log.isInfoEnabled()) break block14;
                        _log.info((Object)"Unable to locate deployment context from portal properties");
                    }
                }
            }
            if (Validator.isNull((String)_servletContextName)) {
                _servletContextName = "opensocial-portlet";
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _servletContextName;
        }
    }

    public static Object translateInput(BaseModel<?> oldModel) {
        Class<?> oldModelClass = oldModel.getClass();
        String oldModelClassName = oldModelClass.getName();
        if (oldModelClassName.equals(GadgetClp.class.getName())) {
            return ClpSerializer.translateInputGadget(oldModel);
        }
        if (oldModelClassName.equals(OAuthConsumerClp.class.getName())) {
            return ClpSerializer.translateInputOAuthConsumer(oldModel);
        }
        if (oldModelClassName.equals(OAuthTokenClp.class.getName())) {
            return ClpSerializer.translateInputOAuthToken(oldModel);
        }
        return oldModel;
    }

    public static Object translateInput(List<Object> oldList) {
        ArrayList<Object> newList = new ArrayList<Object>(oldList.size());
        int i = 0;
        while (i < oldList.size()) {
            Object curObj = oldList.get(i);
            newList.add(ClpSerializer.translateInput(curObj));
            ++i;
        }
        return newList;
    }

    public static Object translateInputGadget(BaseModel<?> oldModel) {
        GadgetClp oldClpModel = (GadgetClp)oldModel;
        BaseModel<?> newModel = oldClpModel.getGadgetRemoteModel();
        newModel.setModelAttributes(oldClpModel.getModelAttributes());
        return newModel;
    }

    public static Object translateInputOAuthConsumer(BaseModel<?> oldModel) {
        OAuthConsumerClp oldClpModel = (OAuthConsumerClp)oldModel;
        BaseModel<?> newModel = oldClpModel.getOAuthConsumerRemoteModel();
        newModel.setModelAttributes(oldClpModel.getModelAttributes());
        return newModel;
    }

    public static Object translateInputOAuthToken(BaseModel<?> oldModel) {
        OAuthTokenClp oldClpModel = (OAuthTokenClp)oldModel;
        BaseModel<?> newModel = oldClpModel.getOAuthTokenRemoteModel();
        newModel.setModelAttributes(oldClpModel.getModelAttributes());
        return newModel;
    }

    public static Object translateInput(Object obj) {
        if (obj instanceof BaseModel) {
            return ClpSerializer.translateInput((BaseModel)obj);
        }
        if (obj instanceof List) {
            return ClpSerializer.translateInput((List)obj);
        }
        return obj;
    }

    public static Object translateOutput(BaseModel<?> oldModel) {
        Class<?> oldModelClass = oldModel.getClass();
        String oldModelClassName = oldModelClass.getName();
        if (oldModelClassName.equals("com.liferay.opensocial.model.impl.GadgetImpl")) {
            return ClpSerializer.translateOutputGadget(oldModel);
        }
        if (oldModelClassName.equals("com.liferay.opensocial.model.impl.OAuthConsumerImpl")) {
            return ClpSerializer.translateOutputOAuthConsumer(oldModel);
        }
        if (oldModelClassName.equals("com.liferay.opensocial.model.impl.OAuthTokenImpl")) {
            return ClpSerializer.translateOutputOAuthToken(oldModel);
        }
        return oldModel;
    }

    public static Object translateOutput(List<Object> oldList) {
        ArrayList<Object> newList = new ArrayList<Object>(oldList.size());
        int i = 0;
        while (i < oldList.size()) {
            Object curObj = oldList.get(i);
            newList.add(ClpSerializer.translateOutput(curObj));
            ++i;
        }
        return newList;
    }

    public static Object translateOutput(Object obj) {
        if (obj instanceof BaseModel) {
            return ClpSerializer.translateOutput((BaseModel)obj);
        }
        if (obj instanceof List) {
            return ClpSerializer.translateOutput((List)obj);
        }
        return obj;
    }

    public static Throwable translateThrowable(Throwable throwable) {
        Class<?> clazz;
        String className;
        if (_useReflectionToTranslateThrowable) {
            try {
                UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)unsyncByteArrayOutputStream);
                objectOutputStream.writeObject(throwable);
                objectOutputStream.flush();
                objectOutputStream.close();
                UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(unsyncByteArrayOutputStream.unsafeGetByteArray(), 0, unsyncByteArrayOutputStream.size());
                Thread currentThread = Thread.currentThread();
                ClassLoader contextClassLoader = currentThread.getContextClassLoader();
                ClassLoaderObjectInputStream objectInputStream = new ClassLoaderObjectInputStream((InputStream)unsyncByteArrayInputStream, contextClassLoader);
                throwable = (Throwable)objectInputStream.readObject();
                objectInputStream.close();
                return throwable;
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"Do not use reflection to translate throwable");
                }
                _useReflectionToTranslateThrowable = false;
            }
            catch (SecurityException securityException) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"Do not use reflection to translate throwable");
                }
                _useReflectionToTranslateThrowable = false;
            }
            catch (Throwable throwable2) {
                _log.error((Object)throwable2, throwable2);
                return throwable2;
            }
        }
        if ((className = (clazz = throwable.getClass()).getName()).equals("com.liferay.opensocial.DuplicateGadgetURLException")) {
            return new DuplicateGadgetURLException(throwable.getMessage(), throwable.getCause());
        }
        if (className.equals("com.liferay.opensocial.GadgetPortletCategoryNamesException")) {
            return new GadgetPortletCategoryNamesException(throwable.getMessage(), throwable.getCause());
        }
        if (className.equals("com.liferay.opensocial.GadgetURLException")) {
            return new GadgetURLException(throwable.getMessage(), throwable.getCause());
        }
        if (className.equals("com.liferay.opensocial.NoSuchGadgetException")) {
            return new NoSuchGadgetException(throwable.getMessage(), throwable.getCause());
        }
        if (className.equals("com.liferay.opensocial.NoSuchOAuthConsumerException")) {
            return new NoSuchOAuthConsumerException(throwable.getMessage(), throwable.getCause());
        }
        if (className.equals("com.liferay.opensocial.NoSuchOAuthTokenException")) {
            return new NoSuchOAuthTokenException(throwable.getMessage(), throwable.getCause());
        }
        return throwable;
    }

    public static Object translateOutputGadget(BaseModel<?> oldModel) {
        GadgetClp newModel = new GadgetClp();
        newModel.setModelAttributes(oldModel.getModelAttributes());
        newModel.setGadgetRemoteModel(oldModel);
        return newModel;
    }

    public static Object translateOutputOAuthConsumer(BaseModel<?> oldModel) {
        OAuthConsumerClp newModel = new OAuthConsumerClp();
        newModel.setModelAttributes(oldModel.getModelAttributes());
        newModel.setOAuthConsumerRemoteModel(oldModel);
        return newModel;
    }

    public static Object translateOutputOAuthToken(BaseModel<?> oldModel) {
        OAuthTokenClp newModel = new OAuthTokenClp();
        newModel.setModelAttributes(oldModel.getModelAttributes());
        newModel.setOAuthTokenRemoteModel(oldModel);
        return newModel;
    }
}

