/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.tomcat;

import com.caucho.config.inject.InjectManager;
import java.lang.reflect.InvocationTargetException;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.naming.NamingException;

public class InstanceManager
implements org.apache.tomcat.InstanceManager {
    public void destroyInstance(Object instance) throws IllegalAccessException, InvocationTargetException {
        InjectManager beanManager = InjectManager.create();
        Class<?> instanceClass = instance.getClass();
        AnnotatedType annotatedType = beanManager.createAnnotatedType(instanceClass);
        InjectionTarget injectionTarget = beanManager.createInjectionTarget(annotatedType);
        injectionTarget.preDestroy(instance);
        injectionTarget.dispose(instance);
    }

    public void newInstance(Object instance) throws IllegalAccessException, InvocationTargetException, NamingException {
        Class<?> instanceClass = instance.getClass();
        this.newInstance(instance, instanceClass);
    }

    public Object newInstance(String className) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<?> instanceClass = classLoader.loadClass(className);
        Object instance = this.newInstance(null, instanceClass);
        return instance;
    }

    public Object newInstance(String className, ClassLoader classLoader) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
        Class<?> instanceClass = classLoader.loadClass(className);
        Object instance = this.newInstance(null, instanceClass);
        return instance;
    }

    private Object newInstance(Object instance, Class instanceClass) {
        InjectManager beanManager = InjectManager.create();
        AnnotatedType annotatedType = beanManager.createAnnotatedType(instanceClass);
        InjectionTarget injectionTarget = beanManager.createInjectionTarget(annotatedType);
        CreationalContext context = beanManager.createCreationalContext(null);
        if (instance == null) {
            instance = injectionTarget.produce(context);
        }
        injectionTarget.inject(instance, context);
        injectionTarget.postConstruct(instance);
        return instance;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

