/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.authz.aop;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.apache.shiro.authz.aop.AuthorizingAnnotationHandler;

public class RoleAnnotationHandler
extends AuthorizingAnnotationHandler {
    public RoleAnnotationHandler() {
        super(RequiresRoles.class);
    }

    public void assertAuthorized(Annotation a) throws AuthorizationException {
        if (!(a instanceof RequiresRoles)) {
            return;
        }
        RequiresRoles rrAnnotation = (RequiresRoles)a;
        String roleId = rrAnnotation.value();
        String[] roles = roleId.split(",");
        if (roles.length == 1) {
            this.getSubject().checkRole(roles[0]);
        } else {
            LinkedHashSet<String> rolesSet = new LinkedHashSet<String>(Arrays.asList(roles));
            this.getSubject().checkRoles(rolesSet);
        }
    }
}

