/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.doc;

import com.caucho.server.webapp.WebApp;
import com.caucho.server.webapp.WebAppController;
import com.caucho.util.L10N;
import com.caucho.util.URLUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JavadocRedirectServlet
extends HttpServlet {
    protected static final Logger log = Logger.getLogger(JavadocRedirectServlet.class.getName());
    static final L10N L = new L10N(JavadocRedirectServlet.class);

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String href;
        String query = request.getParameter("query");
        if (query == null || query.length() == 0) {
            query = request.getPathInfo();
        }
        if (query == null) {
            query = "";
        }
        query = URLUtil.encodeURL((String)query);
        WebApp app = (WebApp)this.getServletContext();
        WebApp japp = null;
        for (WebAppController appController : app.getParent().getWebAppList()) {
            String contextPath = appController.getContextPath();
            if (!contextPath.startsWith("/resin-javadoc")) continue;
            japp = appController.getWebApp();
            break;
        }
        if (japp != null) {
            href = japp.getContextPath() + "?query=" + query;
            if (log.isLoggable(Level.FINER)) {
                log.finer(L.l("javadoc redirect to {0}", (Object)href));
            }
            response.sendRedirect(response.encodeRedirectURL(href));
        } else {
            if (log.isLoggable(Level.FINER)) {
                log.finer(L.l("javadoc no local javadoc"));
            }
            href = "http://www.caucho.com/resin-javadoc/?query=" + query;
            PrintWriter out = response.getWriter();
            out.println("<html>");
            out.println("<head><title>Resin&#174; Javadoc Not Found</title></head>");
            out.println("<body>");
            out.println("<h1 style='background: #ccddff'>Resin&#174; Javadoc Not Found</h1>");
            out.println("A local copy of the Resin javadoc could not be found.");
            out.println("<ul>");
            out.println("<li><a href='" + href + "'>use Caucho website</a>");
            out.println("</ul>");
            out.println("</body>");
            out.println("</html>");
            out.close();
        }
    }
}

