/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.doc;

import com.caucho.util.CharBuffer;
import com.caucho.util.Html;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.servlet.GenericServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class ViewFileServlet
extends GenericServlet {
    private static final Logger log = Logger.getLogger(ViewFileServlet.class.getName());
    static final L10N L = new L10N(ViewFileServlet.class);
    private static final String PARAM_CONTEXTPATH = "contextpath";
    private static final String PARAM_SERVLETPATH = "servletpath";
    private static final String PARAM_FILE = "file";
    private static final String PARAM_RE_MARKER = "re-marker";
    private static final String PARAM_RE_START = "re-start";
    private static final String PARAM_RE_END = "re-end";
    ServletContext _context;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this._context = config.getServletContext();
    }

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        try {
            this.viewFile(response.getWriter(), request);
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    private void viewFile(PrintWriter out, ServletRequest request) throws Exception {
        String file = this.getFileName(request);
        Path path = this.getFilePath(request);
        if (path != null) {
            String line;
            ReadStream is;
            String re_mrk_str = request.getParameter(PARAM_RE_MARKER);
            String re_beg_str = request.getParameter(PARAM_RE_START);
            String re_end_str = request.getParameter(PARAM_RE_END);
            Pattern re_mrk = null;
            Pattern re_beg = null;
            Pattern re_end = null;
            out.println("<html>");
            out.println("<head>");
            out.print("<title>");
            out.print(Html.escapeHtml((String)file));
            out.println("</title>");
            out.println("<style type='text/css'>");
            out.println("  .code-highlight { color: #1764FF; }");
            out.println("  .face-xmlelement { color: #003DB8; font-weight: bold }");
            out.println("</style>");
            out.println("</head>");
            out.println("<body bgcolor=white>");
            out.print("<code>");
            out.print("<b>");
            out.print(Html.escapeHtml((String)file));
            out.print("</b>");
            out.print("</code>");
            out.println("<p>");
            try {
                is = path.openRead();
            }
            catch (FileNotFoundException ex) {
                out.println("<font color='red'><b>File not found: " + Html.escapeHtml((String)path.getPath()) + "</b></font>");
                out.println("</body>");
                out.println("</html>");
                return;
            }
            out.print("<pre>");
            boolean h = false;
            boolean m = false;
            while ((line = is.readln()) != null) {
                if (!m && re_mrk != null && re_mrk.matcher(line).matches()) {
                    out.print("<a name='code-highlight'></a>");
                    m = true;
                }
                if (!h && re_beg != null && re_beg.matcher(line).matches()) {
                    h = true;
                    out.print("<b class='code-highlight'>");
                    if (!m && re_mrk == null) {
                        out.print("<a name='code-highlight'></a>");
                        m = true;
                    }
                }
                int l = line.length();
                for (int i = 0; i < l; ++i) {
                    char ch = line.charAt(i);
                    if (ch == '<') {
                        if (h) {
                            out.print("<span class='face-xmlelement'>");
                        }
                        out.print("&lt;");
                        continue;
                    }
                    if (ch == '>') {
                        out.print("&gt;");
                        if (!h) continue;
                        out.print("</span>");
                        continue;
                    }
                    out.print(ch);
                }
                out.println();
                if (!h || re_end != null && (re_end == null || !re_end.matcher(line).matches())) continue;
                h = false;
                out.print("</b>");
            }
            is.close();
            if (h) {
                out.print("</b>");
            }
            out.println("</pre>");
            out.println("</body>");
            out.println("</html>");
            return;
        }
    }

    private String getFileName(ServletRequest request) {
        String f = request.getParameter(PARAM_FILE);
        if (f != null && f.length() > 0 && f.indexOf("..") < 0) {
            return f;
        }
        return null;
    }

    private Path getFilePath(ServletRequest request) {
        String cp = request.getParameter(PARAM_CONTEXTPATH);
        String sp = request.getParameter(PARAM_SERVLETPATH);
        String f = this.getFileName(request);
        Path pwd = Vfs.lookup().createRoot();
        if (f != null) {
            ServletContext ctx = this._context;
            String requestContext = ((HttpServletRequest)request).getContextPath();
            if (cp != null && cp.startsWith(requestContext)) {
                cp = cp.substring(requestContext.length());
            }
            CharBuffer cb = new CharBuffer();
            if (cp != null) {
                cb.append(cp);
            }
            cb.append('/');
            cb.append(f);
            return pwd.lookup(cb.toString());
        }
        return null;
    }
}

