/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xtpdoc;

import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import com.caucho.xtpdoc.Chapter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;

public class Book {
    private static final L10N L = new L10N(Book.class);
    private String _title;
    private ArrayList<Chapter> _chapters = new ArrayList();
    private String _type = "book";

    public void setTitle(String title) {
        this._title = title;
    }

    public void setType(String type) {
        this._type = type;
        if (!"book".equals(type) && !"article".equals(type)) {
            throw new ConfigException(L.l("'{0}' is an unknown document type", (Object)type));
        }
    }

    public boolean isBook() {
        return "book".equals(this._type);
    }

    public boolean isArticle() {
        return "article".equals(this._type);
    }

    public void addChapter(Chapter chapter) {
        this._chapters.add(chapter);
    }

    public void writeLaTeX(PrintWriter out) throws IOException {
        if (this.isBook()) {
            out.println("\\documentclass[twoside]{book}");
        } else {
            out.println("\\documentclass{article}");
        }
        out.println();
        out.println("\\usepackage{url}");
        out.println("\\usepackage{hyperref}");
        out.println("\\usepackage{graphicx}");
        out.println("\\usepackage{color}");
        out.println("\\usepackage{colortbl}");
        out.println("\\usepackage{fancyvrb}");
        out.println("\\usepackage{listings}");
        out.println("\\usepackage{tabularx}");
        out.println("\\usepackage{filecontents}");
        out.println("\\usepackage{ltxtable}");
        out.println("\\usepackage{epsfig}");
        out.println("\\usepackage{boxedminipage}");
        out.println("\\usepackage{fancyhdr}");
        out.println();
        out.println("\\pagestyle{fancy}");
        out.println();
        if (this.isBook()) {
            out.println("\\lhead[\\leftmark]{}");
            out.println("\\rhead[]{\\rightmark}");
        }
        out.println();
        out.println("\\definecolor{example-gray}{gray}{0.8}");
        out.println("\\definecolor{results-gray}{gray}{0.6}");
        out.println();
        out.println("\\newcommand{\\verbbf}[1]{\\textbf{\\Verb #1}}");
        out.println();
        out.println("\\title{" + this._title + "}");
        out.println("\\begin{document}");
        if (!this.isBook()) {
            out.println("\\maketitle");
        }
        out.println("\\tableofcontents");
        out.println("\\sloppy");
        for (Chapter chapter : this._chapters) {
            if (this.isBook()) {
                chapter.writeLaTeX(out);
                continue;
            }
            chapter.writeLaTeXArticle(out);
        }
        out.println("\\end{document}");
    }

    public void writeAsciiDoc(PrintWriter out) throws IOException {
        out.println();
        out.println("= " + this._title + " =");
        for (Chapter chapter : this._chapters) {
            chapter.writeAsciiDoc(out);
        }
    }
}

