/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xtpdoc;

import com.caucho.xtpdoc.ChapterSection;
import com.caucho.xtpdoc.EnclosingChapterSection;
import com.caucho.xtpdoc.LaTeXUtil;
import com.caucho.xtpdoc.LinkedChapterSection;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;

public class Chapter {
    private String _title;
    private ArrayList<ChapterSection> _sections = new ArrayList();

    public void setTitle(String title) {
        this._title = title;
    }

    public void addLinkedSection(LinkedChapterSection section) {
        this._sections.add(section);
    }

    public void addEnclosingSection(EnclosingChapterSection section) {
        this._sections.add(section);
    }

    public void writeLaTeX(PrintWriter out) throws IOException {
        out.println("\\chapter{" + LaTeXUtil.escapeForLaTeX(this._title) + "}");
        this.writeLaTeXBody(out);
    }

    public void writeLaTeXBody(PrintWriter out) throws IOException {
        for (ChapterSection section : this._sections) {
            section.writeLaTeX(out);
        }
    }

    public void writeLaTeXArticle(PrintWriter out) throws IOException {
        for (ChapterSection section : this._sections) {
            section.writeLaTeXArticle(out);
        }
    }

    public void writeAsciiDoc(PrintWriter out) throws IOException {
        out.println();
        out.println();
        out.println("== " + this._title + " ==");
        for (ChapterSection section : this._sections) {
            section.writeAsciiDoc(out);
        }
    }
}

