/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xtpdoc;

import com.caucho.xtpdoc.ContentItem;
import com.caucho.xtpdoc.Document;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContainerNode
implements ContentItem {
    private static Logger log = Logger.getLogger(ContainerNode.class.getName());
    private Document _document;
    private ArrayList<ContentItem> _items = new ArrayList();
    private boolean _isWebOnly;
    private String _location = "";

    public ContainerNode(Document document) {
        this._document = document;
    }

    public Document getDocument() {
        return this._document;
    }

    public String getLocation() {
        return this._location;
    }

    public void setConfigLocation(String fileName, int line) {
        this._location = fileName + ":" + line + ": ";
    }

    public void setWebOnly(boolean isWebOnly) {
        this._isWebOnly = true;
    }

    public boolean isWebOnly() {
        return this._isWebOnly;
    }

    public boolean isArticle() {
        return this._document.isArticle();
    }

    protected void addItem(ContentItem item) {
        this._items.add(item);
    }

    protected ArrayList<ContentItem> getItems() {
        return this._items;
    }

    protected void setItems(ArrayList<ContentItem> items) {
        this._items = items;
    }

    @Override
    public void writeHtml(XMLStreamWriter out) throws XMLStreamException {
        for (ContentItem item : this._items) {
            item.writeHtml(out);
        }
    }

    @Override
    public void writeLaTeXTop(PrintWriter out) throws IOException {
        for (ContentItem item : this._items) {
            item.writeLaTeXTop(out);
        }
    }

    @Override
    public void writeLaTeX(PrintWriter out) throws IOException {
        for (ContentItem item : this._items) {
            item.writeLaTeX(out);
        }
    }

    @Override
    public void writeLaTeXEnclosed(PrintWriter out) throws IOException {
        for (ContentItem item : this._items) {
            item.writeLaTeXEnclosed(out);
        }
    }

    @Override
    public void writeLaTeXVerbatim(PrintWriter out) throws IOException {
        for (ContentItem item : this._items) {
            item.writeLaTeXVerbatim(out);
        }
    }

    public void writeLaTeXArticle(PrintWriter out) throws IOException {
        for (ContentItem item : this._items) {
            item.writeLaTeXTop(out);
        }
    }

    @Override
    public void writeAsciiDoc(PrintWriter out) throws IOException {
        for (ContentItem item : this._items) {
            item.writeAsciiDoc(out);
        }
    }
}

