/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xtpdoc;

import com.caucho.xtpdoc.ContentItem;
import com.caucho.xtpdoc.Document;
import com.caucho.xtpdoc.Keywords;
import com.caucho.xtpdoc.LaTeXUtil;
import com.caucho.xtpdoc.NavigationItem;
import com.caucho.xtpdoc.S1;
import com.caucho.xtpdoc.Section;
import java.io.IOException;
import java.io.PrintWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class Header {
    private Document _document;
    private String _product;
    private String _version;
    private String _title;
    private String _browserTitle;
    private String _author;
    private String _date;
    private Section _description;
    private Keywords _keywords;
    private String _tutorial;
    private boolean _cauchoSite = true;

    public Header(Document document) {
        this._document = document;
    }

    public void setCauchoSite(boolean cauchoSite) {
        this._cauchoSite = cauchoSite;
    }

    public void setProduct(String product) {
        this._product = product;
    }

    public void setVersion(String version) {
        this._version = version;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public void setBrowserTitle(String title) {
        this._browserTitle = title;
    }

    public String getTitle() {
        return this._title;
    }

    public void setDate(String date) {
        this._date = date;
    }

    public void setAuthor(String author) {
        this._author = author;
    }

    public void setResin2_0(String resin2_0) {
    }

    public void setType(String type) {
    }

    public void setTutorialStartpage(String startPage) {
        this._tutorial = startPage;
    }

    public String getTutorialStartPage() {
        return this._tutorial;
    }

    public void setLevel(String level) {
    }

    public void setKeywords(Keywords keywords) {
        this._keywords = keywords;
    }

    public ContentItem getDescription() {
        return this._description;
    }

    public Section createDescription() {
        this._description = new S1(this._document);
        return this._description;
    }

    public void writeHtml(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement("head");
        out.writeEmptyElement("meta");
        out.writeAttribute("http-equiv", "Content-Type");
        out.writeAttribute("content", "text/html; charset=utf-8");
        if (this._product != null) {
            out.writeEmptyElement("meta");
            out.writeAttribute("name", "product");
            out.writeAttribute("content", this._product);
        }
        if (this._version != null) {
            out.writeEmptyElement("meta");
            out.writeAttribute("name", "version");
            out.writeAttribute("content", this._version);
        }
        if (this._keywords != null) {
            out.writeEmptyElement("meta");
            out.writeAttribute("name", "keywords");
            out.writeAttribute("content", this._keywords.toString());
        }
        if (this._cauchoSite) {
            out.writeStartElement("script");
            out.writeAttribute("type", "text/javascript");
            out.writeCharacters("    var _gaq = _gaq || [];\n    _gaq.push(['_setAccount', 'UA-27887123-1']);\n    _gaq.push(['_setDomainName', 'caucho.com']);\n    _gaq.push(['_trackPageview']);\n    (function() {\n          var ga = document.createElement('script'); \n           ga.type = 'text/javascript'; ga.async = true;\n          ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') +                   '.google-analytics.com/ga.js';          var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s);\n    })();");
            out.writeEndElement();
        }
        out.writeEmptyElement("link");
        out.writeAttribute("rel", "STYLESHEET");
        out.writeAttribute("type", "text/css");
        out.writeAttribute("href", this._document.getContextPath() + "/css/default.css");
        out.writeEmptyElement("link");
        out.writeAttribute("rel", "shortcut icon");
        out.writeAttribute("href", this._document.getContextPath() + "/images/favicon.ico");
        out.writeStartElement("script");
        out.writeAttribute("type", "text/javascript");
        out.writeAttribute("src", this._document.getContextPath() + "/js/default.js");
        out.writeEndElement();
        out.writeStartElement("script");
        out.writeAttribute("type", "text/javascript");
        out.writeCharacters("  window.onload = function() {\n");
        out.writeCharacters("    init();\n");
        out.writeCharacters("  };\n");
        out.writeEndElement();
        out.writeStartElement("title");
        NavigationItem nav = this._document.getNavigation();
        if (nav != null && nav.getNavigation() != null && nav.getNavigation().getSection() != null) {
            out.writeCharacters(nav.getNavigation().getSection());
        }
        out.writeCharacters(this._title);
        out.writeEndElement();
        out.writeEndElement();
    }

    public void writeLaTeXTop(PrintWriter out) throws IOException {
        out.println("\\usepackage[margin=1in]{geometry}");
        out.println("\\usepackage{url}");
        out.println("\\usepackage{hyperref}");
        out.println("\\usepackage{graphicx}");
        out.println("\\usepackage{color}");
        out.println("\\usepackage{colortbl}");
        out.println("\\usepackage{fancyvrb}");
        out.println("\\usepackage{listings}");
        out.println();
        out.println("\\definecolor{example-gray}{gray}{0.8}");
        out.println("\\definecolor{results-gray}{gray}{0.6}");
        out.println();
        out.println("\\title{" + this._title + "}");
    }

    public void writeLaTeX(PrintWriter out) throws IOException {
        String label = this._document.getDocumentPath().getUserPath();
        out.println("\\label{" + label + "}");
        out.println("\\hypertarget{" + label + "}{}");
        out.println("\\section{" + LaTeXUtil.escapeForLaTeX(this._title) + "}");
    }

    public void writeLaTeXEnclosed(PrintWriter out) throws IOException {
        String label = this._document.getDocumentPath().getUserPath();
        out.println("\\label{" + label + "}");
        out.println("\\hypertarget{" + label + "}{}");
        out.println("\\subsection{" + LaTeXUtil.escapeForLaTeX(this._title) + "}");
    }

    public void writeLaTeXArticle(PrintWriter out) throws IOException {
    }

    public void writeAsciiDoc(PrintWriter out) {
    }
}

