/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xtpdoc;

import com.caucho.config.ConfigException;
import com.caucho.xtpdoc.ContentItem;
import com.caucho.xtpdoc.Document;
import java.io.IOException;
import java.io.PrintWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class Image
implements ContentItem {
    private int _height = -1;
    private int _width = -1;
    private String _source;
    private Document _document;

    public Image(Document document) {
        this._document = document;
    }

    public Document getDocument() {
        return this._document;
    }

    public void setHeight(int height) {
        this._height = height;
    }

    public void setWidth(int width) {
        this._width = width;
    }

    public void setSrc(String source) {
        this._source = source;
    }

    public void writeHtml(XMLStreamWriter out) throws XMLStreamException {
        out.writeEmptyElement("img");
        if (this._height >= 0) {
            out.writeAttribute("height", Integer.toString(this._height));
        }
        if (this._width >= 0) {
            out.writeAttribute("width", Integer.toString(this._width));
        }
        out.writeAttribute("src", this._document.getContextPath() + "/images/" + this._source);
    }

    public void writeLaTeX(PrintWriter out) throws IOException {
        int dot = this._source.lastIndexOf(46);
        String basename = this._source.substring(0, dot);
        out.println("\\epsfig{file=../images/" + basename + ",width=\\linewidth}");
    }

    public void writeLaTeXVerbatim(PrintWriter out) throws IOException {
        throw new ConfigException("<image> not allowed in a verbatim context");
    }

    public void writeLaTeXEnclosed(PrintWriter out) throws IOException {
        this.writeLaTeX(out);
    }

    public void writeLaTeXTop(PrintWriter out) throws IOException {
        this.writeLaTeX(out);
    }

    public void writeAsciiDoc(PrintWriter out) throws IOException {
    }
}

