/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xtpdoc;

import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.xtpdoc.Body;
import com.caucho.xtpdoc.Defun;
import com.caucho.xtpdoc.Document;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;

public class ReferenceDocument
extends Document {
    private static Logger log = Logger.getLogger(ReferenceDocument.class.getName());
    private static L10N L = new L10N(ReferenceDocument.class);
    private final HashMap<String, Defun> _defuns = new HashMap();

    public ReferenceDocument(Path documentPath, String contextPath) {
        super(documentPath, contextPath);
    }

    public ReferenceDocument(ServletContext webApp, Path documentPath, String contextPath, String uri, String encoding) {
        super(webApp, documentPath, contextPath, uri, encoding);
    }

    ReferenceDocument getReferenceDocument() {
        return this;
    }

    public Body createBody() {
        return new ReferenceBody(this);
    }

    public Defun getDefun(String ref) {
        return this._defuns.get(ref);
    }

    private class ReferenceDefun
    extends Defun {
        public ReferenceDefun(Document document) {
            super(document);
        }

        @PostConstruct
        public void init() {
            Defun oldDefun = (Defun)ReferenceDocument.this._defuns.get(this.getName());
            if (oldDefun != null) {
                ReferenceDocument.this._defuns.remove(this.getName());
                if (oldDefun.getParents() != null) {
                    for (String parent : oldDefun.getParents()) {
                        ReferenceDocument.this._defuns.put(parent + ":" + this.getName(), oldDefun);
                    }
                }
                if (this.getParents() != null) {
                    for (String parent : this.getParents()) {
                        ReferenceDocument.this._defuns.put(parent + ":" + this.getName(), this);
                    }
                }
            } else {
                ReferenceDocument.this._defuns.put(this.getName(), this);
            }
        }
    }

    private class ReferenceBody
    extends Body {
        public ReferenceBody(Document document) {
            super(document);
        }

        public Defun createDefun() {
            ReferenceDefun defun = new ReferenceDefun(this.getDocument());
            this.addItem(defun);
            return defun;
        }
    }
}

