/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xtpdoc;

import com.caucho.config.ConfigException;
import com.caucho.xtpdoc.ContentItem;
import com.caucho.xtpdoc.Document;
import com.caucho.xtpdoc.LaTeXUtil;
import com.caucho.xtpdoc.Node;
import com.caucho.xtpdoc.TableRow;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class Table
extends Node
implements ContentItem {
    private static int _count = 0;
    private int _myCount = _count++;
    private Document _document;
    protected String _title;
    protected String _width;
    protected int _columns = 0;
    protected ArrayList<TableRow> _rows = new ArrayList();

    public Table(Document document) {
        this._document = document;
    }

    public void setWidth(String width) {
        this._width = width;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public TableRow createTr() {
        TableRow row = new TableRow(this._document);
        this._rows.add(row);
        return row;
    }

    public void writeHtml(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement("table");
        if (this._width != null) {
            out.writeAttribute("style", "width: " + this._width);
        }
        int index = 0;
        for (TableRow row : this._rows) {
            row.writeHtml(out, index++);
        }
        out.writeEndElement();
    }

    protected void writeRows(PrintWriter out) throws IOException {
        for (TableRow row : this._rows) {
            row.writeLaTeX(out);
        }
    }

    public void writeLaTeX(PrintWriter out) throws IOException {
        for (TableRow row : this._rows) {
            this._columns = Math.max(this._columns, row.getNumberOfColumns());
        }
        out.println("\\begin{filecontents}{ltx" + this._myCount + ".tex}");
        out.print("\\begin{longtable}");
        out.print("{");
        for (int i = 0; i < this._columns; ++i) {
            out.print("X");
        }
        out.println("}");
        out.println("\\hline");
        this.writeRows(out);
        out.println("\\end{longtable}");
        out.println("\\end{filecontents}");
        out.println("\\begin{center}");
        if (this._title != null) {
            out.println("\\textbf{" + LaTeXUtil.escapeForLaTeX(this._title) + "}");
        }
        out.println("\\LTXtable{\\linewidth}{ltx" + this._myCount + "}");
        out.println("\\end{center}");
    }

    public void writeLaTeXVerbatim(PrintWriter out) throws IOException {
        throw new ConfigException("<table> not allowed in a verbatim context");
    }

    public void writeLaTeXEnclosed(PrintWriter out) throws IOException {
        this.writeLaTeX(out);
    }

    public void writeLaTeXTop(PrintWriter out) throws IOException {
        this.writeLaTeX(out);
    }

    public void writeAsciiDoc(PrintWriter out) throws IOException {
        out.println();
        out.println();
        if (this._title != null) {
            out.println("." + this._title);
        }
        if (this._rows.size() > 0 && this._rows.get(0).isHeader()) {
            out.println("[options=\"header\"]");
        }
        out.println("|=======");
        for (TableRow row : this._rows) {
            row.writeAsciiDoc(out);
        }
        out.println("|=======");
    }
}

