/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xtpdoc;

import com.caucho.config.types.RawString;
import com.caucho.xtpdoc.Document;
import com.caucho.xtpdoc.FormattedTextWithAnchors;
import com.caucho.xtpdoc.TableCell;
import com.caucho.xtpdoc.Text;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class TableHeader
extends FormattedTextWithAnchors
implements TableCell {
    private String _rowspan;
    private String _colspan;
    private String _width;
    private String _id;
    private String _scope;

    public TableHeader(Document document) {
        super(document);
    }

    public void setRowspan(String rowspan) {
        this._rowspan = rowspan;
    }

    public void setColspan(String colspan) {
        this._colspan = colspan;
    }

    public void setWidth(String width) {
        this._width = width;
    }

    public void setId(String id) {
        this._id = id;
    }

    public void setScope(String scope) {
        this._scope = scope;
    }

    public void addText(RawString text) {
        this.addItem(new Text(text.getValue().toUpperCase(Locale.ENGLISH)));
    }

    public void writeHtml(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement("th");
        if (this._width != null) {
            out.writeAttribute("width", this._width);
        }
        if (this._colspan != null) {
            out.writeAttribute("colspan", this._colspan);
        }
        if (this._rowspan != null) {
            out.writeAttribute("rowspan", this._rowspan);
        }
        if (this._scope != null) {
            out.writeAttribute("scope", this._scope);
        } else {
            out.writeAttribute("scope", "col");
        }
        if (this._id != null) {
            out.writeAttribute("id", this._id);
        }
        super.writeHtml(out);
        out.writeEndElement();
    }

    public void writeLaTeX(PrintWriter out) throws IOException {
        out.print("\\textbf{");
        super.writeLaTeX(out);
        out.print("}");
    }
}

