/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xtpdoc;

import com.caucho.xtpdoc.Document;
import com.caucho.xtpdoc.TableCell;
import com.caucho.xtpdoc.TableData;
import com.caucho.xtpdoc.TableHeader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class TableRow {
    private Document _document;
    private ArrayList<TableCell> _cells = new ArrayList();

    public TableRow(Document document) {
        this._document = document;
    }

    public int getNumberOfColumns() {
        return this._cells.size();
    }

    public boolean isHeader() {
        return this._cells.size() > 0 && this._cells.get(0) instanceof TableHeader;
    }

    public TableData createTd() {
        TableData data = new TableData(this._document);
        this._cells.add(data);
        return data;
    }

    public TableHeader createTh() {
        TableHeader header = new TableHeader(this._document);
        this._cells.add(header);
        return header;
    }

    public void setOccur(String occur) {
    }

    public void writeHtml(XMLStreamWriter out, int count) throws XMLStreamException {
        out.writeStartElement("tr");
        out.writeAttribute("class", count % 2 == 0 ? "a" : "b");
        for (TableCell cell : this._cells) {
            cell.writeHtml(out);
        }
        out.writeEndElement();
    }

    public void writeLaTeX(PrintWriter out) throws IOException {
        for (int i = 0; i < this._cells.size(); ++i) {
            this._cells.get(i).writeLaTeX(out);
            if (i < this._cells.size() - 1) {
                out.print("&");
            } else {
                out.println("\\\\");
            }
            out.flush();
        }
    }

    public void writeAsciiDoc(PrintWriter out) throws IOException {
        for (int i = 0; i < this._cells.size(); ++i) {
            out.print("|");
            this._cells.get(i).writeAsciiDoc(out);
        }
        out.println();
    }
}

