/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xtpdoc;

import com.caucho.config.ConfigException;
import com.caucho.xtpdoc.ContentItem;
import com.caucho.xtpdoc.Document;
import java.io.IOException;
import java.io.PrintWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class ViewFileLink
implements ContentItem {
    private String _file;
    private Document _document;

    public ViewFileLink(Document document) {
        this._document = document;
    }

    public void setFile(String file) {
        this._file = file;
    }

    public void writeHtml(XMLStreamWriter out) throws XMLStreamException {
        if (!this._document.isDisableAction()) {
            String cp = this._document.getContextPath();
            out.writeStartElement("a");
            out.writeAttribute("href", "viewfile?file=" + this._file);
            out.writeCharacters(this._file);
            out.writeEndElement();
        } else {
            out.writeCharacters(this._file);
        }
    }

    public void writeLaTeX(PrintWriter out) throws IOException {
        out.print("\\href{" + this._file + "}{" + this._file + "}");
    }

    public void writeLaTeXVerbatim(PrintWriter out) throws IOException {
        throw new ConfigException("<viewfile-link> not allowed in a verbatim context");
    }

    public void writeLaTeXEnclosed(PrintWriter out) throws IOException {
        this.writeLaTeX(out);
    }

    public void writeLaTeXTop(PrintWriter out) throws IOException {
        this.writeLaTeX(out);
    }

    public void writeAsciiDoc(PrintWriter out) throws IOException {
    }
}

