/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scripting.ruby;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.scripting.BaseScriptingExecutor;
import com.liferay.portal.kernel.scripting.ExecutionException;
import com.liferay.portal.kernel.scripting.ScriptingException;
import com.liferay.portal.kernel.util.AggregateClassLoader;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.NamedThreadFactory;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.util.ClassLoaderUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import jodd.io.ZipUtil;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.embed.LocalContextScope;
import org.jruby.embed.ScriptingContainer;
import org.jruby.embed.internal.LocalContextProvider;
import org.jruby.exceptions.RaiseException;

public class RubyExecutor
extends BaseScriptingExecutor {
    public static final String LANGUAGE = "ruby";
    private static final String _COMPILE_MODE_FORCE = "force";
    private static final String _COMPILE_MODE_JIT = "jit";
    private static Log _log = LogFactoryUtil.getLog(RubyExecutor.class);
    private static Field _globalRuntimeField;
    private static ThreadFactory _threadFactory;
    private String _basePath;
    private boolean _executeInSeparateThread = true;
    private List<String> _loadPaths;
    private ScriptingContainer _scriptingContainer;

    static {
        _threadFactory = new NamedThreadFactory(RubyExecutor.class.getName(), 5, RubyExecutor.class.getClassLoader());
        try {
            _globalRuntimeField = ReflectionUtil.getDeclaredField(Ruby.class, (String)"globalRuntime");
        }
        catch (Exception e2) {
            throw new ExceptionInInitializerError(e2);
        }
    }

    public RubyExecutor() {
        try {
            this.initRubyGems();
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        this._scriptingContainer = new ScriptingContainer(LocalContextScope.THREADSAFE);
        LocalContextProvider localContextProvider = this._scriptingContainer.getProvider();
        RubyInstanceConfig rubyInstanceConfig = localContextProvider.getRubyInstanceConfig();
        if (PropsValues.SCRIPTING_JRUBY_COMPILE_MODE.equals(_COMPILE_MODE_FORCE)) {
            rubyInstanceConfig.setCompileMode(RubyInstanceConfig.CompileMode.FORCE);
        } else if (PropsValues.SCRIPTING_JRUBY_COMPILE_MODE.equals(_COMPILE_MODE_JIT)) {
            rubyInstanceConfig.setCompileMode(RubyInstanceConfig.CompileMode.JIT);
        }
        rubyInstanceConfig.setJitThreshold(PropsValues.SCRIPTING_JRUBY_COMPILE_THRESHOLD);
        rubyInstanceConfig.setLoader(ClassLoaderUtil.getPortalClassLoader());
        this._basePath = PropsValues.LIFERAY_LIB_PORTAL_DIR;
        this._loadPaths = new ArrayList<String>(PropsValues.SCRIPTING_JRUBY_LOAD_PATHS.length);
        String[] stringArray = PropsValues.SCRIPTING_JRUBY_LOAD_PATHS;
        int n = PropsValues.SCRIPTING_JRUBY_LOAD_PATHS.length;
        int n2 = 0;
        while (n2 < n) {
            String gemLibPath = stringArray[n2];
            this._loadPaths.add(gemLibPath);
            ++n2;
        }
        rubyInstanceConfig.setLoadPaths(this._loadPaths);
        this._scriptingContainer.setCurrentDirectory(this._basePath);
    }

    public Map<String, Object> eval(Set<String> allowedClasses, Map<String, Object> inputObjects, Set<String> outputNames, File scriptFile, ClassLoader ... classLoaders) throws ScriptingException {
        return this.eval(allowedClasses, inputObjects, outputNames, scriptFile, (String)null, classLoaders);
    }

    public Map<String, Object> eval(Set<String> allowedClasses, Map<String, Object> inputObjects, Set<String> outputNames, String script, ClassLoader ... classLoaders) throws ScriptingException {
        return this.eval(allowedClasses, inputObjects, outputNames, null, script, classLoaders);
    }

    public String getLanguage() {
        return LANGUAGE;
    }

    public void setExecuteInSeparateThread(boolean executeInSeparateThread) {
        this._executeInSeparateThread = executeInSeparateThread;
    }

    protected Map<String, Object> doEval(Set<String> allowedClasses, Map<String, Object> inputObjects, Set<String> outputNames, File scriptFile, String script, ClassLoader ... classLoaders) throws ScriptingException {
        if (allowedClasses != null) {
            throw new ExecutionException("Constrained execution not supported for Ruby");
        }
        try {
            LocalContextProvider localContextProvider = this._scriptingContainer.getProvider();
            RubyInstanceConfig rubyInstanceConfig = localContextProvider.getRubyInstanceConfig();
            rubyInstanceConfig.setCurrentDirectory(this._basePath);
            if (ArrayUtil.isNotEmpty((Object[])classLoaders)) {
                ClassLoader aggregateClassLoader = AggregateClassLoader.getAggregateClassLoader((ClassLoader)ClassLoaderUtil.getPortalClassLoader(), (ClassLoader[])classLoaders);
                rubyInstanceConfig.setLoader(aggregateClassLoader);
            }
            rubyInstanceConfig.setLoadPaths(this._loadPaths);
            for (Map.Entry<String, Object> entry : inputObjects.entrySet()) {
                String inputName = entry.getKey();
                Object inputObject = entry.getValue();
                if (!inputName.startsWith("$")) {
                    inputName = "$" + inputName;
                }
                this._scriptingContainer.put(inputName, inputObject);
            }
            if (scriptFile != null) {
                this._scriptingContainer.runScriptlet((InputStream)new FileInputStream(scriptFile), scriptFile.toString());
            } else {
                this._scriptingContainer.runScriptlet(script);
            }
            if (outputNames == null) {
                return null;
            }
            HashMap<String, Object> outputObjects = new HashMap<String, Object>();
            for (String outputName : outputNames) {
                outputObjects.put(outputName, this._scriptingContainer.get(outputName));
            }
            HashMap<String, Object> hashMap = outputObjects;
            return hashMap;
        }
        catch (RaiseException re) {
            throw new ScriptingException(String.valueOf(re.getException().message.asJavaString()) + "\n\n", (Throwable)re);
        }
        catch (FileNotFoundException fnfe) {
            throw new ScriptingException((Throwable)fnfe);
        }
        finally {
            try {
                _globalRuntimeField.set(null, null);
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
            }
        }
    }

    protected Map<String, Object> eval(Set<String> allowedClasses, Map<String, Object> inputObjects, Set<String> outputNames, File scriptFile, String script, ClassLoader ... classLoaders) throws ScriptingException {
        if (!this._executeInSeparateThread) {
            return this.doEval(allowedClasses, inputObjects, outputNames, scriptFile, script, classLoaders);
        }
        EvalCallable evalCallable = new EvalCallable(allowedClasses, inputObjects, outputNames, scriptFile, script, classLoaders);
        FutureTask<Map<String, Object>> futureTask = new FutureTask<Map<String, Object>>(evalCallable);
        Thread oneTimeExecutorThread = _threadFactory.newThread(futureTask);
        oneTimeExecutorThread.start();
        try {
            oneTimeExecutorThread.join();
            return futureTask.get();
        }
        catch (Exception e2) {
            futureTask.cancel(true);
            oneTimeExecutorThread.interrupt();
            throw new ScriptingException((Throwable)e2);
        }
    }

    protected void initRubyGems() throws Exception {
        File rubyGemsJarFile = new File(PropsValues.LIFERAY_LIB_PORTAL_DIR, "ruby-gems.jar");
        if (!rubyGemsJarFile.exists()) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)(rubyGemsJarFile + " does not exist"));
            }
            return;
        }
        String tmpDir = SystemProperties.get((String)"java.io.tmpdir");
        File rubyDir = new File(String.valueOf(tmpDir) + "/liferay/ruby");
        if (!rubyDir.exists() || rubyDir.lastModified() < rubyGemsJarFile.lastModified()) {
            FileUtil.deltree((File)rubyDir);
            FileUtil.mkdirs((File)rubyDir);
            ZipUtil.unzip((File)rubyGemsJarFile, (File)rubyDir, (String[])new String[0]);
            rubyDir.setLastModified(rubyGemsJarFile.lastModified());
        }
    }

    private class EvalCallable
    implements Callable<Map<String, Object>> {
        private final Set<String> _allowedClasses;
        private final Map<String, Object> _inputObjects;
        private final Set<String> _outputNames;
        private final File _scriptFile;
        private final String _script;
        private final ClassLoader[] _classLoaders;

        public EvalCallable(Set<String> allowedClasses, Map<String, Object> inputObjects, Set<String> outputNames, File scriptFile, String script, ClassLoader[] classLoaders) {
            this._allowedClasses = allowedClasses;
            this._inputObjects = inputObjects;
            this._outputNames = outputNames;
            this._scriptFile = scriptFile;
            this._script = script;
            this._classLoaders = classLoaders;
        }

        @Override
        public Map<String, Object> call() throws Exception {
            return RubyExecutor.this.doEval(this._allowedClasses, this._inputObjects, this._outputNames, this._scriptFile, this._script, this._classLoaders);
        }
    }
}

