/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.message.pape;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.message.MessageException;
import org.openid4java.message.Parameter;
import org.openid4java.message.ParameterList;
import org.openid4java.message.pape.PapeMessage;
import org.openid4java.util.InternetDateFormat;

public class PapeResponse
extends PapeMessage {
    private static Log _log = LogFactory.getLog(PapeResponse.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    protected static final List PAPE_FIELDS = Arrays.asList("auth_policies", "auth_time");
    private static final String AUTH_POLICY_NONE = "http://schemas.openid.net/pape/policies/2007/06/none";
    private static InternetDateFormat _dateFormat = new InternetDateFormat();

    protected PapeResponse() {
        this.set("auth_policies", AUTH_POLICY_NONE);
        if (DEBUG) {
            _log.debug((Object)"Created empty PAPE response.");
        }
    }

    public static PapeResponse createPapeResponse() {
        return new PapeResponse();
    }

    protected PapeResponse(ParameterList params) {
        super(params);
    }

    public static PapeResponse createPapeResponse(ParameterList params) throws MessageException {
        PapeResponse resp = new PapeResponse(params);
        resp.validate();
        if (DEBUG) {
            _log.debug((Object)("Created PAPE response from parameter list:\n" + params));
        }
        return resp;
    }

    public String getAuthPolicies() {
        return this.getParameterValue("auth_policies");
    }

    public void setAuthPolicies(String policyUris) {
        this.set("auth_policies", policyUris);
    }

    public void addAuthPolicy(String policyUri) {
        String policies = this.getAuthPolicies();
        if (policies == null || AUTH_POLICY_NONE.equals(policies)) {
            this.setAuthPolicies(policyUri);
        } else {
            this.setAuthPolicies(policies + " " + policyUri);
        }
    }

    public List getAuthPoliciesList() {
        String policies = this.getParameterValue("auth_policies");
        if (policies == null || AUTH_POLICY_NONE.equals(policies)) {
            return new ArrayList();
        }
        return Arrays.asList(policies.split(" "));
    }

    public void setAuthTime(Date timestamp) {
        this.set("auth_time", _dateFormat.format(timestamp));
    }

    public String getAuthTime() {
        return this.getParameterValue("auth_time");
    }

    public Date getAuthDate() {
        String authTime = this.getParameterValue("auth_time");
        if (authTime != null) {
            try {
                return _dateFormat.parse(authTime);
            }
            catch (ParseException e) {
                _log.warn((Object)("Invalid auth_time: " + authTime + "; returning null."));
            }
        }
        return null;
    }

    private void validate() throws MessageException {
        if (!this._parameters.hasParameter("auth_policies")) {
            throw new MessageException("auth_policies is required in a PAPE response.", 3120);
        }
        String authTime = this.getAuthTime();
        if (authTime != null) {
            try {
                _dateFormat.parse(authTime);
            }
            catch (ParseException e) {
                throw new MessageException("Invalid auth_time in PAPE response: " + authTime, 3120, e);
            }
        }
        Iterator it = this._parameters.getParameters().iterator();
        while (it.hasNext()) {
            String paramName = ((Parameter)it.next()).getKey();
            if (PAPE_FIELDS.contains(paramName) || paramName.startsWith("auth_level.ns.") || paramName.startsWith("auth_level.") && this.authLevelAliases.values().contains(paramName.substring("auth_level.".length()))) continue;
            throw new MessageException("Invalid parameter in PAPE response: " + paramName, 3120);
        }
    }

    public void setCustomAuthLevel(String authLevelTypeUri, String level) {
        String alias = this.addAuthLevelExtension(authLevelTypeUri);
        this.set("auth_level." + alias, level);
    }

    public String getCustomAuthLevel(String authLevelTypeUri) {
        if (this.hasCustomAuthLevel(authLevelTypeUri)) {
            return this.getParameterValue("auth_level." + this.getCustomAuthLevelAlias(authLevelTypeUri));
        }
        return null;
    }
}

