/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.compat.jodatime;

import com.google.ical.compat.jodatime.DateTimeIterable;
import com.google.ical.compat.jodatime.DateTimeIterator;
import com.google.ical.compat.jodatime.TimeZoneConverter;
import com.google.ical.iter.RecurrenceIterable;
import com.google.ical.iter.RecurrenceIterator;
import com.google.ical.iter.RecurrenceIteratorFactory;
import com.google.ical.values.DateTimeValueImpl;
import com.google.ical.values.DateValue;
import com.google.ical.values.TimeValue;
import java.text.ParseException;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableDateTime;

public class DateTimeIteratorFactory {
    public static DateTimeIterator createDateTimeIterator(String rdata, ReadableDateTime start, DateTimeZone tzid, boolean strict) throws ParseException {
        return new RecurrenceIteratorWrapper(RecurrenceIteratorFactory.createRecurrenceIterator(rdata, DateTimeIteratorFactory.dateTimeToDateValue((ReadableDateTime)start.toDateTime().withZone(tzid)), TimeZoneConverter.toTimeZone(tzid), strict));
    }

    public static DateTimeIterable createDateTimeIterable(String rdata, ReadableDateTime start, DateTimeZone tzid, boolean strict) throws ParseException {
        return new RecurrenceIterableWrapper(RecurrenceIteratorFactory.createRecurrenceIterable(rdata, DateTimeIteratorFactory.dateTimeToDateValue((ReadableDateTime)start.toDateTime().withZone(tzid)), TimeZoneConverter.toTimeZone(tzid), strict));
    }

    public static DateTimeIterator createDateTimeIterator(RecurrenceIterator rit) {
        return new RecurrenceIteratorWrapper(rit);
    }

    static DateTime dateValueToDateTime(DateValue dvUtc) {
        if (dvUtc instanceof TimeValue) {
            TimeValue tvUtc = (TimeValue)((Object)dvUtc);
            return new DateTime(dvUtc.year(), dvUtc.month(), dvUtc.day(), tvUtc.hour(), tvUtc.minute(), tvUtc.second(), 0, DateTimeZone.UTC);
        }
        return new DateTime(dvUtc.year(), dvUtc.month(), dvUtc.day(), 0, 0, 0, 0, DateTimeZone.UTC);
    }

    static DateValue dateTimeToDateValue(ReadableDateTime dt) {
        return new DateTimeValueImpl(dt.getYear(), dt.getMonthOfYear(), dt.getDayOfMonth(), dt.getHourOfDay(), dt.getMinuteOfHour(), dt.getSecondOfMinute());
    }

    private DateTimeIteratorFactory() {
    }

    private static final class RecurrenceIterableWrapper
    implements DateTimeIterable {
        private final RecurrenceIterable it;

        public RecurrenceIterableWrapper(RecurrenceIterable it) {
            this.it = it;
        }

        @Override
        public DateTimeIterator iterator() {
            return new RecurrenceIteratorWrapper(this.it.iterator());
        }
    }

    private static final class RecurrenceIteratorWrapper
    implements DateTimeIterator {
        private final RecurrenceIterator it;

        RecurrenceIteratorWrapper(RecurrenceIterator it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public DateTime next() {
            return DateTimeIteratorFactory.dateValueToDateTime(this.it.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void advanceTo(ReadableDateTime d) {
            DateTime dUtc = d.toDateTime().withZone(DateTimeZone.UTC);
            this.it.advanceTo(DateTimeIteratorFactory.dateTimeToDateValue((ReadableDateTime)dUtc));
        }
    }
}

