/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.calendar.model.impl;

import com.liferay.calendar.model.CalendarBooking;
import com.liferay.calendar.model.CalendarBookingModel;
import com.liferay.calendar.model.CalendarBookingSoap;

import com.liferay.compat.portal.kernel.util.LocalizationUtil;

import com.liferay.portal.LocaleException;
import com.liferay.portal.NoSuchModelException;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowConstants;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.ContainerModel;
import com.liferay.portal.model.TrashedModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;

import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;
import com.liferay.portlet.trash.model.TrashEntry;
import com.liferay.portlet.trash.service.TrashEntryLocalServiceUtil;

import java.io.Serializable;

import java.sql.Types;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/**
 * The base model implementation for the CalendarBooking service. Represents a row in the &quot;CalendarBooking&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link com.liferay.calendar.model.CalendarBookingModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CalendarBookingImpl}.
 * </p>
 *
 * @author Eduardo Lundgren
 * @see CalendarBookingImpl
 * @see com.liferay.calendar.model.CalendarBooking
 * @see com.liferay.calendar.model.CalendarBookingModel
 * @generated
 */
@JSON(strict = true)
public class CalendarBookingModelImpl extends BaseModelImpl<CalendarBooking>
	implements CalendarBookingModel {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a calendar booking model instance should use the {@link com.liferay.calendar.model.CalendarBooking} interface instead.
	 */
	public static final String TABLE_NAME = "CalendarBooking";
	public static final Object[][] TABLE_COLUMNS = {
			{ "uuid_", Types.VARCHAR },
			{ "calendarBookingId", Types.BIGINT },
			{ "groupId", Types.BIGINT },
			{ "companyId", Types.BIGINT },
			{ "userId", Types.BIGINT },
			{ "userName", Types.VARCHAR },
			{ "createDate", Types.TIMESTAMP },
			{ "modifiedDate", Types.TIMESTAMP },
			{ "resourceBlockId", Types.BIGINT },
			{ "calendarId", Types.BIGINT },
			{ "calendarResourceId", Types.BIGINT },
			{ "parentCalendarBookingId", Types.BIGINT },
			{ "vEventUid", Types.VARCHAR },
			{ "title", Types.VARCHAR },
			{ "description", Types.CLOB },
			{ "location", Types.VARCHAR },
			{ "startTime", Types.BIGINT },
			{ "endTime", Types.BIGINT },
			{ "allDay", Types.BOOLEAN },
			{ "recurrence", Types.VARCHAR },
			{ "firstReminder", Types.BIGINT },
			{ "firstReminderType", Types.VARCHAR },
			{ "secondReminder", Types.BIGINT },
			{ "secondReminderType", Types.VARCHAR },
			{ "status", Types.INTEGER },
			{ "statusByUserId", Types.BIGINT },
			{ "statusByUserName", Types.VARCHAR },
			{ "statusDate", Types.TIMESTAMP }
		};
	public static final String TABLE_SQL_CREATE = "create table CalendarBooking (uuid_ VARCHAR(75) null,calendarBookingId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,resourceBlockId LONG,calendarId LONG,calendarResourceId LONG,parentCalendarBookingId LONG,vEventUid VARCHAR(255) null,title STRING null,description TEXT null,location STRING null,startTime LONG,endTime LONG,allDay BOOLEAN,recurrence STRING null,firstReminder LONG,firstReminderType VARCHAR(75) null,secondReminder LONG,secondReminderType VARCHAR(75) null,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null)";
	public static final String TABLE_SQL_DROP = "drop table CalendarBooking";
	public static final String ORDER_BY_JPQL = " ORDER BY calendarBooking.startTime ASC, calendarBooking.title ASC";
	public static final String ORDER_BY_SQL = " ORDER BY CalendarBooking.startTime ASC, CalendarBooking.title ASC";
	public static final String DATA_SOURCE = "liferayDataSource";
	public static final String SESSION_FACTORY = "liferaySessionFactory";
	public static final String TX_MANAGER = "liferayTransactionManager";
	public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
				"value.object.entity.cache.enabled.com.liferay.calendar.model.CalendarBooking"),
			true);
	public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
				"value.object.finder.cache.enabled.com.liferay.calendar.model.CalendarBooking"),
			true);
	public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.util.service.ServiceProps.get(
				"value.object.column.bitmask.enabled.com.liferay.calendar.model.CalendarBooking"),
			true);
	public static long CALENDARID_COLUMN_BITMASK = 1L;
	public static long CALENDARRESOURCEID_COLUMN_BITMASK = 2L;
	public static long COMPANYID_COLUMN_BITMASK = 4L;
	public static long GROUPID_COLUMN_BITMASK = 8L;
	public static long PARENTCALENDARBOOKINGID_COLUMN_BITMASK = 16L;
	public static long RESOURCEBLOCKID_COLUMN_BITMASK = 32L;
	public static long STATUS_COLUMN_BITMASK = 64L;
	public static long UUID_COLUMN_BITMASK = 128L;
	public static long VEVENTUID_COLUMN_BITMASK = 256L;
	public static long STARTTIME_COLUMN_BITMASK = 512L;
	public static long TITLE_COLUMN_BITMASK = 1024L;

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 */
	public static CalendarBooking toModel(CalendarBookingSoap soapModel) {
		if (soapModel == null) {
			return null;
		}

		CalendarBooking model = new CalendarBookingImpl();

		model.setUuid(soapModel.getUuid());
		model.setCalendarBookingId(soapModel.getCalendarBookingId());
		model.setGroupId(soapModel.getGroupId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setResourceBlockId(soapModel.getResourceBlockId());
		model.setCalendarId(soapModel.getCalendarId());
		model.setCalendarResourceId(soapModel.getCalendarResourceId());
		model.setParentCalendarBookingId(soapModel.getParentCalendarBookingId());
		model.setVEventUid(soapModel.getVEventUid());
		model.setTitle(soapModel.getTitle());
		model.setDescription(soapModel.getDescription());
		model.setLocation(soapModel.getLocation());
		model.setStartTime(soapModel.getStartTime());
		model.setEndTime(soapModel.getEndTime());
		model.setAllDay(soapModel.getAllDay());
		model.setRecurrence(soapModel.getRecurrence());
		model.setFirstReminder(soapModel.getFirstReminder());
		model.setFirstReminderType(soapModel.getFirstReminderType());
		model.setSecondReminder(soapModel.getSecondReminder());
		model.setSecondReminderType(soapModel.getSecondReminderType());
		model.setStatus(soapModel.getStatus());
		model.setStatusByUserId(soapModel.getStatusByUserId());
		model.setStatusByUserName(soapModel.getStatusByUserName());
		model.setStatusDate(soapModel.getStatusDate());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 */
	public static List<CalendarBooking> toModels(
		CalendarBookingSoap[] soapModels) {
		if (soapModels == null) {
			return null;
		}

		List<CalendarBooking> models = new ArrayList<CalendarBooking>(soapModels.length);

		for (CalendarBookingSoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.util.service.ServiceProps.get(
				"lock.expiration.time.com.liferay.calendar.model.CalendarBooking"));

	public CalendarBookingModelImpl() {
	}


	public long getPrimaryKey() {
		return _calendarBookingId;
	}


	public void setPrimaryKey(long primaryKey) {
		setCalendarBookingId(primaryKey);
	}


	public Serializable getPrimaryKeyObj() {
		return _calendarBookingId;
	}


	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}


	public Class<?> getModelClass() {
		return CalendarBooking.class;
	}


	public String getModelClassName() {
		return CalendarBooking.class.getName();
	}


	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		attributes.put("uuid", getUuid());
		attributes.put("calendarBookingId", getCalendarBookingId());
		attributes.put("groupId", getGroupId());
		attributes.put("companyId", getCompanyId());
		attributes.put("userId", getUserId());
		attributes.put("userName", getUserName());
		attributes.put("createDate", getCreateDate());
		attributes.put("modifiedDate", getModifiedDate());
		attributes.put("resourceBlockId", getResourceBlockId());
		attributes.put("calendarId", getCalendarId());
		attributes.put("calendarResourceId", getCalendarResourceId());
		attributes.put("parentCalendarBookingId", getParentCalendarBookingId());
		attributes.put("vEventUid", getVEventUid());
		attributes.put("title", getTitle());
		attributes.put("description", getDescription());
		attributes.put("location", getLocation());
		attributes.put("startTime", getStartTime());
		attributes.put("endTime", getEndTime());
		attributes.put("allDay", getAllDay());
		attributes.put("recurrence", getRecurrence());
		attributes.put("firstReminder", getFirstReminder());
		attributes.put("firstReminderType", getFirstReminderType());
		attributes.put("secondReminder", getSecondReminder());
		attributes.put("secondReminderType", getSecondReminderType());
		attributes.put("status", getStatus());
		attributes.put("statusByUserId", getStatusByUserId());
		attributes.put("statusByUserName", getStatusByUserName());
		attributes.put("statusDate", getStatusDate());

		return attributes;
	}


	public void setModelAttributes(Map<String, Object> attributes) {
		String uuid = (String)attributes.get("uuid");

		if (uuid != null) {
			setUuid(uuid);
		}

		Long calendarBookingId = (Long)attributes.get("calendarBookingId");

		if (calendarBookingId != null) {
			setCalendarBookingId(calendarBookingId);
		}

		Long groupId = (Long)attributes.get("groupId");

		if (groupId != null) {
			setGroupId(groupId);
		}

		Long companyId = (Long)attributes.get("companyId");

		if (companyId != null) {
			setCompanyId(companyId);
		}

		Long userId = (Long)attributes.get("userId");

		if (userId != null) {
			setUserId(userId);
		}

		String userName = (String)attributes.get("userName");

		if (userName != null) {
			setUserName(userName);
		}

		Date createDate = (Date)attributes.get("createDate");

		if (createDate != null) {
			setCreateDate(createDate);
		}

		Date modifiedDate = (Date)attributes.get("modifiedDate");

		if (modifiedDate != null) {
			setModifiedDate(modifiedDate);
		}

		Long resourceBlockId = (Long)attributes.get("resourceBlockId");

		if (resourceBlockId != null) {
			setResourceBlockId(resourceBlockId);
		}

		Long calendarId = (Long)attributes.get("calendarId");

		if (calendarId != null) {
			setCalendarId(calendarId);
		}

		Long calendarResourceId = (Long)attributes.get("calendarResourceId");

		if (calendarResourceId != null) {
			setCalendarResourceId(calendarResourceId);
		}

		Long parentCalendarBookingId = (Long)attributes.get(
				"parentCalendarBookingId");

		if (parentCalendarBookingId != null) {
			setParentCalendarBookingId(parentCalendarBookingId);
		}

		String vEventUid = (String)attributes.get("vEventUid");

		if (vEventUid != null) {
			setVEventUid(vEventUid);
		}

		String title = (String)attributes.get("title");

		if (title != null) {
			setTitle(title);
		}

		String description = (String)attributes.get("description");

		if (description != null) {
			setDescription(description);
		}

		String location = (String)attributes.get("location");

		if (location != null) {
			setLocation(location);
		}

		Long startTime = (Long)attributes.get("startTime");

		if (startTime != null) {
			setStartTime(startTime);
		}

		Long endTime = (Long)attributes.get("endTime");

		if (endTime != null) {
			setEndTime(endTime);
		}

		Boolean allDay = (Boolean)attributes.get("allDay");

		if (allDay != null) {
			setAllDay(allDay);
		}

		String recurrence = (String)attributes.get("recurrence");

		if (recurrence != null) {
			setRecurrence(recurrence);
		}

		Long firstReminder = (Long)attributes.get("firstReminder");

		if (firstReminder != null) {
			setFirstReminder(firstReminder);
		}

		String firstReminderType = (String)attributes.get("firstReminderType");

		if (firstReminderType != null) {
			setFirstReminderType(firstReminderType);
		}

		Long secondReminder = (Long)attributes.get("secondReminder");

		if (secondReminder != null) {
			setSecondReminder(secondReminder);
		}

		String secondReminderType = (String)attributes.get("secondReminderType");

		if (secondReminderType != null) {
			setSecondReminderType(secondReminderType);
		}

		Integer status = (Integer)attributes.get("status");

		if (status != null) {
			setStatus(status);
		}

		Long statusByUserId = (Long)attributes.get("statusByUserId");

		if (statusByUserId != null) {
			setStatusByUserId(statusByUserId);
		}

		String statusByUserName = (String)attributes.get("statusByUserName");

		if (statusByUserName != null) {
			setStatusByUserName(statusByUserName);
		}

		Date statusDate = (Date)attributes.get("statusDate");

		if (statusDate != null) {
			setStatusDate(statusDate);
		}
	}

	@JSON

	public String getUuid() {
		if (_uuid == null) {
			return StringPool.BLANK;
		}
		else {
			return _uuid;
		}
	}


	public void setUuid(String uuid) {
		if (_originalUuid == null) {
			_originalUuid = _uuid;
		}

		_uuid = uuid;
	}

	public String getOriginalUuid() {
		return GetterUtil.getString(_originalUuid);
	}

	@JSON

	public long getCalendarBookingId() {
		return _calendarBookingId;
	}


	public void setCalendarBookingId(long calendarBookingId) {
		_calendarBookingId = calendarBookingId;
	}

	@JSON

	public long getGroupId() {
		return _groupId;
	}


	public void setGroupId(long groupId) {
		_columnBitmask |= GROUPID_COLUMN_BITMASK;

		if (!_setOriginalGroupId) {
			_setOriginalGroupId = true;

			_originalGroupId = _groupId;
		}

		_groupId = groupId;
	}

	public long getOriginalGroupId() {
		return _originalGroupId;
	}

	@JSON

	public long getCompanyId() {
		return _companyId;
	}


	public void setCompanyId(long companyId) {
		_columnBitmask |= COMPANYID_COLUMN_BITMASK;

		if (!_setOriginalCompanyId) {
			_setOriginalCompanyId = true;

			_originalCompanyId = _companyId;
		}

		_companyId = companyId;
	}

	public long getOriginalCompanyId() {
		return _originalCompanyId;
	}

	@JSON

	public long getUserId() {
		return _userId;
	}


	public void setUserId(long userId) {
		_userId = userId;
	}


	public String getUserUuid() throws SystemException {
		return PortalUtil.getUserValue(getUserId(), "uuid", _userUuid);
	}


	public void setUserUuid(String userUuid) {
		_userUuid = userUuid;
	}

	@JSON

	public String getUserName() {
		if (_userName == null) {
			return StringPool.BLANK;
		}
		else {
			return _userName;
		}
	}


	public void setUserName(String userName) {
		_userName = userName;
	}

	@JSON

	public Date getCreateDate() {
		return _createDate;
	}


	public void setCreateDate(Date createDate) {
		_createDate = createDate;
	}

	@JSON

	public Date getModifiedDate() {
		return _modifiedDate;
	}


	public void setModifiedDate(Date modifiedDate) {
		_modifiedDate = modifiedDate;
	}

	@JSON

	public long getResourceBlockId() {
		return _resourceBlockId;
	}


	public void setResourceBlockId(long resourceBlockId) {
		_columnBitmask |= RESOURCEBLOCKID_COLUMN_BITMASK;

		if (!_setOriginalResourceBlockId) {
			_setOriginalResourceBlockId = true;

			_originalResourceBlockId = _resourceBlockId;
		}

		_resourceBlockId = resourceBlockId;
	}

	public long getOriginalResourceBlockId() {
		return _originalResourceBlockId;
	}

	@JSON

	public long getCalendarId() {
		return _calendarId;
	}


	public void setCalendarId(long calendarId) {
		_columnBitmask |= CALENDARID_COLUMN_BITMASK;

		if (!_setOriginalCalendarId) {
			_setOriginalCalendarId = true;

			_originalCalendarId = _calendarId;
		}

		_calendarId = calendarId;
	}

	public long getOriginalCalendarId() {
		return _originalCalendarId;
	}

	@JSON

	public long getCalendarResourceId() {
		return _calendarResourceId;
	}


	public void setCalendarResourceId(long calendarResourceId) {
		_columnBitmask |= CALENDARRESOURCEID_COLUMN_BITMASK;

		if (!_setOriginalCalendarResourceId) {
			_setOriginalCalendarResourceId = true;

			_originalCalendarResourceId = _calendarResourceId;
		}

		_calendarResourceId = calendarResourceId;
	}

	public long getOriginalCalendarResourceId() {
		return _originalCalendarResourceId;
	}

	@JSON

	public long getParentCalendarBookingId() {
		return _parentCalendarBookingId;
	}


	public void setParentCalendarBookingId(long parentCalendarBookingId) {
		_columnBitmask |= PARENTCALENDARBOOKINGID_COLUMN_BITMASK;

		if (!_setOriginalParentCalendarBookingId) {
			_setOriginalParentCalendarBookingId = true;

			_originalParentCalendarBookingId = _parentCalendarBookingId;
		}

		_parentCalendarBookingId = parentCalendarBookingId;
	}

	public long getOriginalParentCalendarBookingId() {
		return _originalParentCalendarBookingId;
	}

	@JSON

	public String getVEventUid() {
		if (_vEventUid == null) {
			return StringPool.BLANK;
		}
		else {
			return _vEventUid;
		}
	}


	public void setVEventUid(String vEventUid) {
		_columnBitmask |= VEVENTUID_COLUMN_BITMASK;

		if (_originalVEventUid == null) {
			_originalVEventUid = _vEventUid;
		}

		_vEventUid = vEventUid;
	}

	public String getOriginalVEventUid() {
		return GetterUtil.getString(_originalVEventUid);
	}

	@JSON

	public String getTitle() {
		if (_title == null) {
			return StringPool.BLANK;
		}
		else {
			return _title;
		}
	}


	public String getTitle(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getTitle(languageId);
	}


	public String getTitle(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getTitle(languageId, useDefault);
	}


	public String getTitle(String languageId) {
		return LocalizationUtil.getLocalization(getTitle(), languageId);
	}


	public String getTitle(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(getTitle(), languageId,
			useDefault);
	}


	public String getTitleCurrentLanguageId() {
		return _titleCurrentLanguageId;
	}

	@JSON

	public String getTitleCurrentValue() {
		Locale locale = getLocale(_titleCurrentLanguageId);

		return getTitle(locale);
	}


	public Map<Locale, String> getTitleMap() {
		return LocalizationUtil.getLocalizationMap(getTitle());
	}


	public void setTitle(String title) {
		_columnBitmask = -1L;

		_title = title;
	}


	public void setTitle(String title, Locale locale) {
		setTitle(title, locale, LocaleUtil.getSiteDefault());
	}


	public void setTitle(String title, Locale locale, Locale defaultLocale) {
		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(title)) {
			setTitle(LocalizationUtil.updateLocalization(getTitle(), "Title",
					title, languageId, defaultLanguageId));
		}
		else {
			setTitle(LocalizationUtil.removeLocalization(getTitle(), "Title",
					languageId));
		}
	}


	public void setTitleCurrentLanguageId(String languageId) {
		_titleCurrentLanguageId = languageId;
	}


	public void setTitleMap(Map<Locale, String> titleMap) {
		setTitleMap(titleMap, LocaleUtil.getSiteDefault());
	}


	public void setTitleMap(Map<Locale, String> titleMap, Locale defaultLocale) {
		if (titleMap == null) {
			return;
		}

		setTitle(LocalizationUtil.updateLocalization(titleMap, getTitle(),
				"Title", LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON

	public String getDescription() {
		if (_description == null) {
			return StringPool.BLANK;
		}
		else {
			return _description;
		}
	}


	public String getDescription(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getDescription(languageId);
	}


	public String getDescription(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getDescription(languageId, useDefault);
	}


	public String getDescription(String languageId) {
		return LocalizationUtil.getLocalization(getDescription(), languageId);
	}


	public String getDescription(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(getDescription(), languageId,
			useDefault);
	}


	public String getDescriptionCurrentLanguageId() {
		return _descriptionCurrentLanguageId;
	}

	@JSON

	public String getDescriptionCurrentValue() {
		Locale locale = getLocale(_descriptionCurrentLanguageId);

		return getDescription(locale);
	}


	public Map<Locale, String> getDescriptionMap() {
		return LocalizationUtil.getLocalizationMap(getDescription());
	}


	public void setDescription(String description) {
		_description = description;
	}


	public void setDescription(String description, Locale locale) {
		setDescription(description, locale, LocaleUtil.getSiteDefault());
	}


	public void setDescription(String description, Locale locale,
		Locale defaultLocale) {
		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(description)) {
			setDescription(LocalizationUtil.updateLocalization(
					getDescription(), "Description", description, languageId,
					defaultLanguageId));
		}
		else {
			setDescription(LocalizationUtil.removeLocalization(
					getDescription(), "Description", languageId));
		}
	}


	public void setDescriptionCurrentLanguageId(String languageId) {
		_descriptionCurrentLanguageId = languageId;
	}


	public void setDescriptionMap(Map<Locale, String> descriptionMap) {
		setDescriptionMap(descriptionMap, LocaleUtil.getSiteDefault());
	}


	public void setDescriptionMap(Map<Locale, String> descriptionMap,
		Locale defaultLocale) {
		if (descriptionMap == null) {
			return;
		}

		setDescription(LocalizationUtil.updateLocalization(descriptionMap,
				getDescription(), "Description",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON

	public String getLocation() {
		if (_location == null) {
			return StringPool.BLANK;
		}
		else {
			return _location;
		}
	}


	public void setLocation(String location) {
		_location = location;
	}

	@JSON

	public long getStartTime() {
		return _startTime;
	}


	public void setStartTime(long startTime) {
		_columnBitmask = -1L;

		_startTime = startTime;
	}

	@JSON

	public long getEndTime() {
		return _endTime;
	}


	public void setEndTime(long endTime) {
		_endTime = endTime;
	}

	@JSON

	public boolean getAllDay() {
		return _allDay;
	}


	public boolean isAllDay() {
		return _allDay;
	}


	public void setAllDay(boolean allDay) {
		_allDay = allDay;
	}

	@JSON

	public String getRecurrence() {
		if (_recurrence == null) {
			return StringPool.BLANK;
		}
		else {
			return _recurrence;
		}
	}


	public void setRecurrence(String recurrence) {
		_recurrence = recurrence;
	}

	@JSON

	public long getFirstReminder() {
		return _firstReminder;
	}


	public void setFirstReminder(long firstReminder) {
		_firstReminder = firstReminder;
	}

	@JSON

	public String getFirstReminderType() {
		if (_firstReminderType == null) {
			return StringPool.BLANK;
		}
		else {
			return _firstReminderType;
		}
	}


	public void setFirstReminderType(String firstReminderType) {
		_firstReminderType = firstReminderType;
	}

	@JSON

	public long getSecondReminder() {
		return _secondReminder;
	}


	public void setSecondReminder(long secondReminder) {
		_secondReminder = secondReminder;
	}

	@JSON

	public String getSecondReminderType() {
		if (_secondReminderType == null) {
			return StringPool.BLANK;
		}
		else {
			return _secondReminderType;
		}
	}


	public void setSecondReminderType(String secondReminderType) {
		_secondReminderType = secondReminderType;
	}

	@JSON

	public int getStatus() {
		return _status;
	}


	public void setStatus(int status) {
		_columnBitmask |= STATUS_COLUMN_BITMASK;

		if (!_setOriginalStatus) {
			_setOriginalStatus = true;

			_originalStatus = _status;
		}

		_status = status;
	}

	public int getOriginalStatus() {
		return _originalStatus;
	}

	@JSON

	public long getStatusByUserId() {
		return _statusByUserId;
	}


	public void setStatusByUserId(long statusByUserId) {
		_statusByUserId = statusByUserId;
	}


	public String getStatusByUserUuid() throws SystemException {
		return PortalUtil.getUserValue(getStatusByUserId(), "uuid",
			_statusByUserUuid);
	}


	public void setStatusByUserUuid(String statusByUserUuid) {
		_statusByUserUuid = statusByUserUuid;
	}

	@JSON

	public String getStatusByUserName() {
		if (_statusByUserName == null) {
			return StringPool.BLANK;
		}
		else {
			return _statusByUserName;
		}
	}


	public void setStatusByUserName(String statusByUserName) {
		_statusByUserName = statusByUserName;
	}

	@JSON

	public Date getStatusDate() {
		return _statusDate;
	}


	public void setStatusDate(Date statusDate) {
		_statusDate = statusDate;
	}


	public StagedModelType getStagedModelType() {
		return new StagedModelType(PortalUtil.getClassNameId(
				CalendarBooking.class.getName()));
	}


	public TrashEntry getTrashEntry() throws PortalException, SystemException {
		if (!isInTrash()) {
			return null;
		}

		TrashEntry trashEntry = TrashEntryLocalServiceUtil.fetchEntry(getModelClassName(),
				getTrashEntryClassPK());

		if (trashEntry != null) {
			return trashEntry;
		}

		TrashHandler trashHandler = getTrashHandler();

		if (!Validator.isNull(trashHandler.getContainerModelClassName())) {
			ContainerModel containerModel = null;

			try {
				containerModel = trashHandler.getParentContainerModel(this);
			}
			catch (NoSuchModelException nsme) {
				return null;
			}

			while (containerModel != null) {
				if (containerModel instanceof TrashedModel) {
					TrashedModel trashedModel = (TrashedModel)containerModel;

					return trashedModel.getTrashEntry();
				}

				trashHandler = TrashHandlerRegistryUtil.getTrashHandler(trashHandler.getContainerModelClassName());

				if (trashHandler == null) {
					return null;
				}

				containerModel = trashHandler.getContainerModel(containerModel.getParentContainerModelId());
			}
		}

		return null;
	}


	public long getTrashEntryClassPK() {
		return getPrimaryKey();
	}


	public TrashHandler getTrashHandler() {
		return TrashHandlerRegistryUtil.getTrashHandler(getModelClassName());
	}


	public boolean isInTrash() {
		if (getStatus() == WorkflowConstants.STATUS_IN_TRASH) {
			return true;
		}
		else {
			return false;
		}
	}


	public boolean isInTrashContainer() {
		TrashHandler trashHandler = getTrashHandler();

		if ((trashHandler == null) ||
				Validator.isNull(trashHandler.getContainerModelClassName())) {
			return false;
		}

		try {
			ContainerModel containerModel = trashHandler.getParentContainerModel(this);

			if (containerModel == null) {
				return false;
			}

			if (containerModel instanceof TrashedModel) {
				return ((TrashedModel)containerModel).isInTrash();
			}
		}
		catch (Exception e) {
		}

		return false;
	}

	/**
	 * @deprecated As of 6.1.0, replaced by {@link #isApproved}
	 */

	public boolean getApproved() {
		return isApproved();
	}


	public boolean isApproved() {
		if (getStatus() == WorkflowConstants.STATUS_APPROVED) {
			return true;
		}
		else {
			return false;
		}
	}


	public boolean isDenied() {
		if (getStatus() == WorkflowConstants.STATUS_DENIED) {
			return true;
		}
		else {
			return false;
		}
	}


	public boolean isDraft() {
		if (getStatus() == WorkflowConstants.STATUS_DRAFT) {
			return true;
		}
		else {
			return false;
		}
	}


	public boolean isExpired() {
		if (getStatus() == WorkflowConstants.STATUS_EXPIRED) {
			return true;
		}
		else {
			return false;
		}
	}


	public boolean isInactive() {
		if (getStatus() == WorkflowConstants.STATUS_INACTIVE) {
			return true;
		}
		else {
			return false;
		}
	}


	public boolean isIncomplete() {
		if (getStatus() == WorkflowConstants.STATUS_INCOMPLETE) {
			return true;
		}
		else {
			return false;
		}
	}


	public boolean isPending() {
		if (getStatus() == WorkflowConstants.STATUS_PENDING) {
			return true;
		}
		else {
			return false;
		}
	}


	public boolean isScheduled() {
		if (getStatus() == WorkflowConstants.STATUS_SCHEDULED) {
			return true;
		}
		else {
			return false;
		}
	}

	public long getColumnBitmask() {
		return _columnBitmask;
	}


	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(getCompanyId(),
			CalendarBooking.class.getName(), getPrimaryKey());
	}


	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}


	public String[] getAvailableLanguageIds() {
		Set<String> availableLanguageIds = new TreeSet<String>();

		Map<Locale, String> titleMap = getTitleMap();

		for (Map.Entry<Locale, String> entry : titleMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		Map<Locale, String> descriptionMap = getDescriptionMap();

		for (Map.Entry<Locale, String> entry : descriptionMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		return availableLanguageIds.toArray(new String[availableLanguageIds.size()]);
	}


	public String getDefaultLanguageId() {
		String xml = getTitle();

		if (xml == null) {
			return StringPool.BLANK;
		}

		Locale defaultLocale = LocaleUtil.getSiteDefault();

		return LocalizationUtil.getDefaultLanguageId(xml, defaultLocale);
	}


	public void prepareLocalizedFieldsForImport() throws LocaleException {
		prepareLocalizedFieldsForImport(null);
	}


	@SuppressWarnings("unused")
	public void prepareLocalizedFieldsForImport(Locale defaultImportLocale)
		throws LocaleException {
		Locale defaultLocale = LocaleUtil.getSiteDefault();

		String modelDefaultLanguageId = getDefaultLanguageId();

		String title = getTitle(defaultLocale);

		if (Validator.isNull(title)) {
			setTitle(getTitle(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setTitle(getTitle(defaultLocale), defaultLocale, defaultLocale);
		}

		String description = getDescription(defaultLocale);

		if (Validator.isNull(description)) {
			setDescription(getDescription(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setDescription(getDescription(defaultLocale), defaultLocale,
				defaultLocale);
		}
	}


	public CalendarBooking toEscapedModel() {
		if (_escapedModel == null) {
			_escapedModel = (CalendarBooking)ProxyUtil.newProxyInstance(_classLoader,
					_escapedModelInterfaces, new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}


	public Object clone() {
		CalendarBookingImpl calendarBookingImpl = new CalendarBookingImpl();

		calendarBookingImpl.setUuid(getUuid());
		calendarBookingImpl.setCalendarBookingId(getCalendarBookingId());
		calendarBookingImpl.setGroupId(getGroupId());
		calendarBookingImpl.setCompanyId(getCompanyId());
		calendarBookingImpl.setUserId(getUserId());
		calendarBookingImpl.setUserName(getUserName());
		calendarBookingImpl.setCreateDate(getCreateDate());
		calendarBookingImpl.setModifiedDate(getModifiedDate());
		calendarBookingImpl.setResourceBlockId(getResourceBlockId());
		calendarBookingImpl.setCalendarId(getCalendarId());
		calendarBookingImpl.setCalendarResourceId(getCalendarResourceId());
		calendarBookingImpl.setParentCalendarBookingId(getParentCalendarBookingId());
		calendarBookingImpl.setVEventUid(getVEventUid());
		calendarBookingImpl.setTitle(getTitle());
		calendarBookingImpl.setDescription(getDescription());
		calendarBookingImpl.setLocation(getLocation());
		calendarBookingImpl.setStartTime(getStartTime());
		calendarBookingImpl.setEndTime(getEndTime());
		calendarBookingImpl.setAllDay(getAllDay());
		calendarBookingImpl.setRecurrence(getRecurrence());
		calendarBookingImpl.setFirstReminder(getFirstReminder());
		calendarBookingImpl.setFirstReminderType(getFirstReminderType());
		calendarBookingImpl.setSecondReminder(getSecondReminder());
		calendarBookingImpl.setSecondReminderType(getSecondReminderType());
		calendarBookingImpl.setStatus(getStatus());
		calendarBookingImpl.setStatusByUserId(getStatusByUserId());
		calendarBookingImpl.setStatusByUserName(getStatusByUserName());
		calendarBookingImpl.setStatusDate(getStatusDate());

		calendarBookingImpl.resetOriginalValues();

		return calendarBookingImpl;
	}


	public int compareTo(CalendarBooking calendarBooking) {
		int value = 0;

		if (getStartTime() < calendarBooking.getStartTime()) {
			value = -1;
		}
		else if (getStartTime() > calendarBooking.getStartTime()) {
			value = 1;
		}
		else {
			value = 0;
		}

		if (value != 0) {
			return value;
		}

		value = getTitle().compareToIgnoreCase(calendarBooking.getTitle());

		if (value != 0) {
			return value;
		}

		return 0;
	}


	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}

		if (!(obj instanceof CalendarBooking)) {
			return false;
		}

		CalendarBooking calendarBooking = (CalendarBooking)obj;

		long primaryKey = calendarBooking.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}


	public int hashCode() {
		return (int)getPrimaryKey();
	}


	public void resetOriginalValues() {
		CalendarBookingModelImpl calendarBookingModelImpl = this;

		calendarBookingModelImpl._originalUuid = calendarBookingModelImpl._uuid;

		calendarBookingModelImpl._originalGroupId = calendarBookingModelImpl._groupId;

		calendarBookingModelImpl._setOriginalGroupId = false;

		calendarBookingModelImpl._originalCompanyId = calendarBookingModelImpl._companyId;

		calendarBookingModelImpl._setOriginalCompanyId = false;

		calendarBookingModelImpl._originalResourceBlockId = calendarBookingModelImpl._resourceBlockId;

		calendarBookingModelImpl._setOriginalResourceBlockId = false;

		calendarBookingModelImpl._originalCalendarId = calendarBookingModelImpl._calendarId;

		calendarBookingModelImpl._setOriginalCalendarId = false;

		calendarBookingModelImpl._originalCalendarResourceId = calendarBookingModelImpl._calendarResourceId;

		calendarBookingModelImpl._setOriginalCalendarResourceId = false;

		calendarBookingModelImpl._originalParentCalendarBookingId = calendarBookingModelImpl._parentCalendarBookingId;

		calendarBookingModelImpl._setOriginalParentCalendarBookingId = false;

		calendarBookingModelImpl._originalVEventUid = calendarBookingModelImpl._vEventUid;

		calendarBookingModelImpl._originalStatus = calendarBookingModelImpl._status;

		calendarBookingModelImpl._setOriginalStatus = false;

		calendarBookingModelImpl._columnBitmask = 0;
	}


	public CacheModel<CalendarBooking> toCacheModel() {
		CalendarBookingCacheModel calendarBookingCacheModel = new CalendarBookingCacheModel();

		calendarBookingCacheModel.uuid = getUuid();

		String uuid = calendarBookingCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			calendarBookingCacheModel.uuid = null;
		}

		calendarBookingCacheModel.calendarBookingId = getCalendarBookingId();

		calendarBookingCacheModel.groupId = getGroupId();

		calendarBookingCacheModel.companyId = getCompanyId();

		calendarBookingCacheModel.userId = getUserId();

		calendarBookingCacheModel.userName = getUserName();

		String userName = calendarBookingCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			calendarBookingCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			calendarBookingCacheModel.createDate = createDate.getTime();
		}
		else {
			calendarBookingCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			calendarBookingCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			calendarBookingCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		calendarBookingCacheModel.resourceBlockId = getResourceBlockId();

		calendarBookingCacheModel.calendarId = getCalendarId();

		calendarBookingCacheModel.calendarResourceId = getCalendarResourceId();

		calendarBookingCacheModel.parentCalendarBookingId = getParentCalendarBookingId();

		calendarBookingCacheModel.vEventUid = getVEventUid();

		String vEventUid = calendarBookingCacheModel.vEventUid;

		if ((vEventUid != null) && (vEventUid.length() == 0)) {
			calendarBookingCacheModel.vEventUid = null;
		}

		calendarBookingCacheModel.title = getTitle();

		String title = calendarBookingCacheModel.title;

		if ((title != null) && (title.length() == 0)) {
			calendarBookingCacheModel.title = null;
		}

		calendarBookingCacheModel.description = getDescription();

		String description = calendarBookingCacheModel.description;

		if ((description != null) && (description.length() == 0)) {
			calendarBookingCacheModel.description = null;
		}

		calendarBookingCacheModel.location = getLocation();

		String location = calendarBookingCacheModel.location;

		if ((location != null) && (location.length() == 0)) {
			calendarBookingCacheModel.location = null;
		}

		calendarBookingCacheModel.startTime = getStartTime();

		calendarBookingCacheModel.endTime = getEndTime();

		calendarBookingCacheModel.allDay = getAllDay();

		calendarBookingCacheModel.recurrence = getRecurrence();

		String recurrence = calendarBookingCacheModel.recurrence;

		if ((recurrence != null) && (recurrence.length() == 0)) {
			calendarBookingCacheModel.recurrence = null;
		}

		calendarBookingCacheModel.firstReminder = getFirstReminder();

		calendarBookingCacheModel.firstReminderType = getFirstReminderType();

		String firstReminderType = calendarBookingCacheModel.firstReminderType;

		if ((firstReminderType != null) && (firstReminderType.length() == 0)) {
			calendarBookingCacheModel.firstReminderType = null;
		}

		calendarBookingCacheModel.secondReminder = getSecondReminder();

		calendarBookingCacheModel.secondReminderType = getSecondReminderType();

		String secondReminderType = calendarBookingCacheModel.secondReminderType;

		if ((secondReminderType != null) && (secondReminderType.length() == 0)) {
			calendarBookingCacheModel.secondReminderType = null;
		}

		calendarBookingCacheModel.status = getStatus();

		calendarBookingCacheModel.statusByUserId = getStatusByUserId();

		calendarBookingCacheModel.statusByUserName = getStatusByUserName();

		String statusByUserName = calendarBookingCacheModel.statusByUserName;

		if ((statusByUserName != null) && (statusByUserName.length() == 0)) {
			calendarBookingCacheModel.statusByUserName = null;
		}

		Date statusDate = getStatusDate();

		if (statusDate != null) {
			calendarBookingCacheModel.statusDate = statusDate.getTime();
		}
		else {
			calendarBookingCacheModel.statusDate = Long.MIN_VALUE;
		}

		return calendarBookingCacheModel;
	}


	public String toString() {
		StringBundler sb = new StringBundler(57);

		sb.append("{uuid=");
		sb.append(getUuid());
		sb.append(", calendarBookingId=");
		sb.append(getCalendarBookingId());
		sb.append(", groupId=");
		sb.append(getGroupId());
		sb.append(", companyId=");
		sb.append(getCompanyId());
		sb.append(", userId=");
		sb.append(getUserId());
		sb.append(", userName=");
		sb.append(getUserName());
		sb.append(", createDate=");
		sb.append(getCreateDate());
		sb.append(", modifiedDate=");
		sb.append(getModifiedDate());
		sb.append(", resourceBlockId=");
		sb.append(getResourceBlockId());
		sb.append(", calendarId=");
		sb.append(getCalendarId());
		sb.append(", calendarResourceId=");
		sb.append(getCalendarResourceId());
		sb.append(", parentCalendarBookingId=");
		sb.append(getParentCalendarBookingId());
		sb.append(", vEventUid=");
		sb.append(getVEventUid());
		sb.append(", title=");
		sb.append(getTitle());
		sb.append(", description=");
		sb.append(getDescription());
		sb.append(", location=");
		sb.append(getLocation());
		sb.append(", startTime=");
		sb.append(getStartTime());
		sb.append(", endTime=");
		sb.append(getEndTime());
		sb.append(", allDay=");
		sb.append(getAllDay());
		sb.append(", recurrence=");
		sb.append(getRecurrence());
		sb.append(", firstReminder=");
		sb.append(getFirstReminder());
		sb.append(", firstReminderType=");
		sb.append(getFirstReminderType());
		sb.append(", secondReminder=");
		sb.append(getSecondReminder());
		sb.append(", secondReminderType=");
		sb.append(getSecondReminderType());
		sb.append(", status=");
		sb.append(getStatus());
		sb.append(", statusByUserId=");
		sb.append(getStatusByUserId());
		sb.append(", statusByUserName=");
		sb.append(getStatusByUserName());
		sb.append(", statusDate=");
		sb.append(getStatusDate());
		sb.append("}");

		return sb.toString();
	}


	public String toXmlString() {
		StringBundler sb = new StringBundler(88);

		sb.append("<model><model-name>");
		sb.append("com.liferay.calendar.model.CalendarBooking");
		sb.append("</model-name>");

		sb.append(
			"<column><column-name>uuid</column-name><column-value><![CDATA[");
		sb.append(getUuid());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>calendarBookingId</column-name><column-value><![CDATA[");
		sb.append(getCalendarBookingId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>groupId</column-name><column-value><![CDATA[");
		sb.append(getGroupId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>companyId</column-name><column-value><![CDATA[");
		sb.append(getCompanyId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>userId</column-name><column-value><![CDATA[");
		sb.append(getUserId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>userName</column-name><column-value><![CDATA[");
		sb.append(getUserName());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>createDate</column-name><column-value><![CDATA[");
		sb.append(getCreateDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>modifiedDate</column-name><column-value><![CDATA[");
		sb.append(getModifiedDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>resourceBlockId</column-name><column-value><![CDATA[");
		sb.append(getResourceBlockId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>calendarId</column-name><column-value><![CDATA[");
		sb.append(getCalendarId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>calendarResourceId</column-name><column-value><![CDATA[");
		sb.append(getCalendarResourceId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>parentCalendarBookingId</column-name><column-value><![CDATA[");
		sb.append(getParentCalendarBookingId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>vEventUid</column-name><column-value><![CDATA[");
		sb.append(getVEventUid());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>title</column-name><column-value><![CDATA[");
		sb.append(getTitle());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>description</column-name><column-value><![CDATA[");
		sb.append(getDescription());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>location</column-name><column-value><![CDATA[");
		sb.append(getLocation());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>startTime</column-name><column-value><![CDATA[");
		sb.append(getStartTime());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>endTime</column-name><column-value><![CDATA[");
		sb.append(getEndTime());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>allDay</column-name><column-value><![CDATA[");
		sb.append(getAllDay());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>recurrence</column-name><column-value><![CDATA[");
		sb.append(getRecurrence());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>firstReminder</column-name><column-value><![CDATA[");
		sb.append(getFirstReminder());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>firstReminderType</column-name><column-value><![CDATA[");
		sb.append(getFirstReminderType());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>secondReminder</column-name><column-value><![CDATA[");
		sb.append(getSecondReminder());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>secondReminderType</column-name><column-value><![CDATA[");
		sb.append(getSecondReminderType());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>status</column-name><column-value><![CDATA[");
		sb.append(getStatus());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>statusByUserId</column-name><column-value><![CDATA[");
		sb.append(getStatusByUserId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>statusByUserName</column-name><column-value><![CDATA[");
		sb.append(getStatusByUserName());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>statusDate</column-name><column-value><![CDATA[");
		sb.append(getStatusDate());
		sb.append("]]></column-value></column>");

		sb.append("</model>");

		return sb.toString();
	}

	private static ClassLoader _classLoader = CalendarBooking.class.getClassLoader();
	private static Class<?>[] _escapedModelInterfaces = new Class[] {
			CalendarBooking.class
		};
	private String _uuid;
	private String _originalUuid;
	private long _calendarBookingId;
	private long _groupId;
	private long _originalGroupId;
	private boolean _setOriginalGroupId;
	private long _companyId;
	private long _originalCompanyId;
	private boolean _setOriginalCompanyId;
	private long _userId;
	private String _userUuid;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private long _resourceBlockId;
	private long _originalResourceBlockId;
	private boolean _setOriginalResourceBlockId;
	private long _calendarId;
	private long _originalCalendarId;
	private boolean _setOriginalCalendarId;
	private long _calendarResourceId;
	private long _originalCalendarResourceId;
	private boolean _setOriginalCalendarResourceId;
	private long _parentCalendarBookingId;
	private long _originalParentCalendarBookingId;
	private boolean _setOriginalParentCalendarBookingId;
	private String _vEventUid;
	private String _originalVEventUid;
	private String _title;
	private String _titleCurrentLanguageId;
	private String _description;
	private String _descriptionCurrentLanguageId;
	private String _location;
	private long _startTime;
	private long _endTime;
	private boolean _allDay;
	private String _recurrence;
	private long _firstReminder;
	private String _firstReminderType;
	private long _secondReminder;
	private String _secondReminderType;
	private int _status;
	private int _originalStatus;
	private boolean _setOriginalStatus;
	private long _statusByUserId;
	private String _statusByUserUuid;
	private String _statusByUserName;
	private Date _statusDate;
	private long _columnBitmask;
	private CalendarBooking _escapedModel;
}