/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portal.workflow.kaleo.hook.listeners;

import com.liferay.portal.ModelListenerException;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.model.BaseModelListener;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinition;

/**
 * @author Kenneth Chang
 */
public class KaleoDefinitionModelListener
	extends BaseModelListener<KaleoDefinition> {


	public void onAfterRemove(KaleoDefinition kaleoDefinition)
		throws ModelListenerException {

		try {
			Message message = new Message();

			message.put("command", "delete");
			message.put("name", kaleoDefinition.getName());
			message.put(
				"serviceContext",
				ServiceContextThreadLocal.getServiceContext());
			message.put("version", kaleoDefinition.getVersion());

			MessageBusUtil.sendMessage("liferay/kaleo_definition", message);
		}
		catch (Exception e) {
			throw new ModelListenerException(e);
		}
	}

}