/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.opensocial.shindig.servlet;

import com.liferay.portal.kernel.util.BasePortalLifecycle;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

/**
 * @author Michael Young
 */
public class GuiceServletContextListener extends BasePortalLifecycle
	implements ServletContextListener {

	public static ServletContextEvent getInitializedServletContextEvent() {
		return _initializedServletContextEvent;
	}


	public void contextDestroyed(ServletContextEvent servletContextEvent) {
	}


	public void contextInitialized(ServletContextEvent servletContextEvent) {
		setInitializedServletContextEvent(servletContextEvent);

		registerPortalLifecycle();
	}


	protected void doPortalDestroy() throws Exception {
	}


	protected void doPortalInit() throws Exception {
	}

	protected void setInitializedServletContextEvent(
		ServletContextEvent servletContextEvent) {

		_initializedServletContextEvent = servletContextEvent;
	}

	private static ServletContextEvent _initializedServletContextEvent;

}