/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import org.apache.http.HttpHost;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.params.HttpParams;

class SocksSocketFactory
extends PlainSocketFactory {
    private static final String SOCKS_PROXY = "htmlunit.socksproxy";

    SocksSocketFactory() {
    }

    static void setSocksProxy(HttpParams parameters, HttpHost socksProxy) {
        parameters.setParameter(SOCKS_PROXY, socksProxy);
    }

    static HttpHost getSocksProxy(HttpParams parameters) {
        return (HttpHost)parameters.getParameter(SOCKS_PROXY);
    }

    static Socket createSocketWithSocksProxy(HttpHost socksProxy) {
        InetSocketAddress address = new InetSocketAddress(socksProxy.getHostName(), socksProxy.getPort());
        Proxy proxy = new Proxy(Proxy.Type.SOCKS, address);
        return new Socket(proxy);
    }

    @Override
    public Socket createSocket(HttpParams params) {
        HttpHost socksProxy = SocksSocketFactory.getSocksProxy(params);
        if (socksProxy != null) {
            return SocksSocketFactory.createSocketWithSocksProxy(socksProxy);
        }
        return super.createSocket(params);
    }
}

