/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.IncorrectnessListener;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.DomCDataSection;
import com.gargoylesoftware.htmlunit.html.DomChangeEvent;
import com.gargoylesoftware.htmlunit.html.DomChangeListener;
import com.gargoylesoftware.htmlunit.html.DomCharacterData;
import com.gargoylesoftware.htmlunit.html.DomDocumentFragment;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNodeList;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlHtml;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlSerializer;
import com.gargoylesoftware.htmlunit.html.NamedAttrNodeMapImpl;
import com.gargoylesoftware.htmlunit.html.SiblingDomNodeList;
import com.gargoylesoftware.htmlunit.html.StaticDomNodeList;
import com.gargoylesoftware.htmlunit.html.xpath.XPathUtils;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.Document;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleSheet;
import com.gargoylesoftware.htmlunit.javascript.host.css.ComputedCSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLDocument;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.steadystate.css.parser.CSSOMParser;
import com.steadystate.css.parser.SACParserCSS3;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.UserDataHandler;

public abstract class DomNode
implements Cloneable,
Serializable,
Node {
    protected static final String AS_TEXT_BLOCK_SEPARATOR = "\u00a7bs\u00a7";
    protected static final String AS_TEXT_NEW_LINE = "\u00a7nl\u00a7";
    protected static final String AS_TEXT_BLANK = "\u00a7blank\u00a7";
    protected static final String AS_TEXT_TAB = "\u00a7tab\u00a7";
    public static final String READY_STATE_UNINITIALIZED = "uninitialized";
    public static final String READY_STATE_LOADING = "loading";
    public static final String READY_STATE_LOADED = "loaded";
    public static final String READY_STATE_INTERACTIVE = "interactive";
    public static final String READY_STATE_COMPLETE = "complete";
    public static final String PROPERTY_ELEMENT = "element";
    private SgmlPage page_;
    private DomNode parent_;
    private DomNode previousSibling_;
    private DomNode nextSibling_;
    private DomNode firstChild_;
    private ScriptableObject scriptObject_;
    private String readyState_ = "loading";
    private int startLineNumber_ = -1;
    private int startColumnNumber_ = -1;
    private int endLineNumber_ = -1;
    private int endColumnNumber_ = -1;
    private boolean directlyAttachedToPage_;
    private Collection<DomChangeListener> domListeners_;
    private final Object domListeners_lock_ = new Serializable(){};

    @Deprecated
    protected DomNode() {
        this(null);
    }

    protected DomNode(SgmlPage page) {
        this.page_ = page;
    }

    void setStartLocation(int startLineNumber, int startColumnNumber) {
        this.startLineNumber_ = startLineNumber;
        this.startColumnNumber_ = startColumnNumber;
    }

    void setEndLocation(int endLineNumber, int endColumnNumber) {
        this.endLineNumber_ = endLineNumber;
        this.endColumnNumber_ = endColumnNumber;
    }

    public int getStartLineNumber() {
        return this.startLineNumber_;
    }

    public int getStartColumnNumber() {
        return this.startColumnNumber_;
    }

    public int getEndLineNumber() {
        return this.endLineNumber_;
    }

    public int getEndColumnNumber() {
        return this.endColumnNumber_;
    }

    public SgmlPage getPage() {
        return this.page_;
    }

    @Override
    public org.w3c.dom.Document getOwnerDocument() {
        return this.getPage();
    }

    public void setScriptObject(ScriptableObject scriptObject) {
        this.scriptObject_ = scriptObject;
    }

    @Override
    public DomNode getLastChild() {
        if (this.firstChild_ != null) {
            return this.firstChild_.previousSibling_;
        }
        return null;
    }

    @Override
    public DomNode getParentNode() {
        return this.parent_;
    }

    protected void setParentNode(DomNode parent) {
        this.parent_ = parent;
    }

    public int getIndex() {
        int index = 0;
        DomNode n = this.previousSibling_;
        while (n != null && n.nextSibling_ != null) {
            ++index;
            n = n.previousSibling_;
        }
        return index;
    }

    @Override
    public DomNode getPreviousSibling() {
        if (this.parent_ == null || this == this.parent_.firstChild_) {
            return null;
        }
        return this.previousSibling_;
    }

    @Override
    public DomNode getNextSibling() {
        return this.nextSibling_;
    }

    @Override
    public DomNode getFirstChild() {
        return this.firstChild_;
    }

    public boolean isAncestorOf(DomNode node) {
        while (node != null) {
            if (node == this) {
                return true;
            }
            node = node.getParentNode();
        }
        return false;
    }

    public boolean isAncestorOfAny(DomNode ... nodes) {
        for (DomNode node : nodes) {
            if (!this.isAncestorOf(node)) continue;
            return true;
        }
        return false;
    }

    protected void setPreviousSibling(DomNode previous) {
        this.previousSibling_ = previous;
    }

    protected void setNextSibling(DomNode next) {
        this.nextSibling_ = next;
    }

    @Override
    public abstract short getNodeType();

    @Override
    public abstract String getNodeName();

    @Override
    public String getNamespaceURI() {
        return null;
    }

    @Override
    public String getLocalName() {
        return null;
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public void setPrefix(String prefix) {
    }

    @Override
    public boolean hasChildNodes() {
        return this.firstChild_ != null;
    }

    @Override
    public DomNodeList<DomNode> getChildNodes() {
        return new SiblingDomNodeList(this);
    }

    @Override
    public boolean isSupported(String namespace, String featureName) {
        throw new UnsupportedOperationException("DomNode.isSupported is not yet implemented.");
    }

    @Override
    public void normalize() {
        for (DomNode child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof DomText)) continue;
            boolean removeChildTextNodes = this.hasFeature(BrowserVersionFeatures.DOM_NORMALIZE_REMOVE_CHILDREN);
            StringBuilder dataBuilder = new StringBuilder();
            DomNode toRemove = child;
            DomCharacterData firstText = null;
            while (toRemove instanceof DomText && !(toRemove instanceof DomCDataSection)) {
                DomNode nextChild = toRemove.getNextSibling();
                dataBuilder.append(toRemove.getTextContent());
                if (removeChildTextNodes || firstText != null) {
                    toRemove.remove();
                }
                if (firstText == null) {
                    firstText = (DomText)toRemove;
                }
                toRemove = nextChild;
            }
            if (firstText == null) continue;
            if (removeChildTextNodes) {
                DomText newText = new DomText(this.getPage(), dataBuilder.toString());
                this.insertBefore(newText, toRemove);
                continue;
            }
            firstText.setData(dataBuilder.toString());
        }
    }

    @Override
    public String getBaseURI() {
        throw new UnsupportedOperationException("DomNode.getBaseURI is not yet implemented.");
    }

    @Override
    public short compareDocumentPosition(Node other) {
        Node node;
        int i;
        if (other == this) {
            return 0;
        }
        List<Node> myAncestors = this.getAncestors(true);
        List<Node> otherAncestors = ((DomNode)other).getAncestors(true);
        int max = Math.min(myAncestors.size(), otherAncestors.size());
        for (i = 1; i < max && myAncestors.get(i) == otherAncestors.get(i); ++i) {
        }
        if (i != 1 && i == max) {
            if (myAncestors.size() == max) {
                return 20;
            }
            return 10;
        }
        if (max == 1) {
            if (myAncestors.contains(other)) {
                return 8;
            }
            if (otherAncestors.contains(this)) {
                return 20;
            }
            return 33;
        }
        Node myAncestor = myAncestors.get(i);
        Node otherAncestor = otherAncestors.get(i);
        for (node = myAncestor; node != otherAncestor && node != null; node = node.getPreviousSibling()) {
        }
        if (node == null) {
            return 4;
        }
        return 2;
    }

    protected List<Node> getAncestors(boolean includeSelf) {
        ArrayList<Node> list = new ArrayList<Node>();
        if (includeSelf) {
            list.add(this);
        }
        for (Node node = this.getParentNode(); node != null; node = node.getParentNode()) {
            list.add(0, node);
        }
        return list;
    }

    @Override
    public String getTextContent() {
        switch (this.getNodeType()) {
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 11: {
                StringBuilder builder = new StringBuilder();
                for (DomNode child : this.getChildren()) {
                    short childType = child.getNodeType();
                    if (childType == 8 || childType == 7) continue;
                    builder.append(child.getTextContent());
                }
                return builder.toString();
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                return this.getNodeValue();
            }
        }
        return null;
    }

    @Override
    public void setTextContent(String textContent) {
        this.removeAllChildren();
        if (textContent != null) {
            this.appendChild(new DomText(this.getPage(), textContent));
        }
    }

    @Override
    public boolean isSameNode(Node other) {
        return other == this;
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        throw new UnsupportedOperationException("DomNode.lookupPrefix is not yet implemented.");
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        throw new UnsupportedOperationException("DomNode.isDefaultNamespace is not yet implemented.");
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        throw new UnsupportedOperationException("DomNode.lookupNamespaceURI is not yet implemented.");
    }

    @Override
    public boolean isEqualNode(Node arg) {
        throw new UnsupportedOperationException("DomNode.isEqualNode is not yet implemented.");
    }

    @Override
    public Object getFeature(String feature, String version) {
        throw new UnsupportedOperationException("DomNode.getFeature is not yet implemented.");
    }

    @Override
    public Object getUserData(String key) {
        throw new UnsupportedOperationException("DomNode.getUserData is not yet implemented.");
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        throw new UnsupportedOperationException("DomNode.setUserData is not yet implemented.");
    }

    @Override
    public boolean hasAttributes() {
        return false;
    }

    protected boolean isTrimmedText() {
        return true;
    }

    public boolean isDisplayed() {
        if (!this.mayBeDisplayed()) {
            return false;
        }
        SgmlPage page = this.getPage();
        if (page instanceof HtmlPage && page.getEnclosingWindow().getWebClient().getOptions().isCssEnabled()) {
            ComputedCSSStyleDeclaration style;
            ScriptableObject scriptableObject;
            Node node2;
            for (Node node2 : this.getAncestors(true)) {
                String display;
                scriptableObject = ((DomNode)node2).getScriptObject();
                if (!(scriptableObject instanceof HTMLElement) || !"none".equals(display = ((CSSStyleDeclaration)(style = ((HTMLElement)scriptableObject).getCurrentStyle())).getDisplay())) continue;
                return false;
            }
            boolean collapseInvisible = this.hasFeature(BrowserVersionFeatures.DISPLAYED_COLLAPSE);
            node2 = this;
            do {
                String visibility;
                if (!((scriptableObject = ((DomNode)node2).getScriptObject()) instanceof HTMLElement) || (visibility = ((CSSStyleDeclaration)(style = ((HTMLElement)scriptableObject).getCurrentStyle())).getVisibility()).length() <= 0) continue;
                if ("visible".equals(visibility)) {
                    return true;
                }
                if (!"hidden".equals(visibility) && (!collapseInvisible || !"collapse".equals(visibility))) continue;
                return false;
            } while ((node2 = ((DomNode)node2).getParentNode()) != null);
        }
        return true;
    }

    public boolean mayBeDisplayed() {
        return true;
    }

    public String asText() {
        HtmlSerializer ser = new HtmlSerializer();
        return ser.asText(this);
    }

    protected boolean isBlock() {
        return false;
    }

    public String asXml() {
        String charsetName = null;
        if (this.getPage() instanceof HtmlPage) {
            charsetName = ((HtmlPage)this.getPage()).getPageEncoding();
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (charsetName != null && this instanceof HtmlHtml) {
            printWriter.println("<?xml version=\"1.0\" encoding=\"" + charsetName + "\"?>");
        }
        this.printXml("", printWriter);
        printWriter.close();
        return stringWriter.toString();
    }

    protected void printXml(String indent, PrintWriter printWriter) {
        printWriter.println(indent + this);
        this.printChildrenAsXml(indent, printWriter);
    }

    protected void printChildrenAsXml(String indent, PrintWriter printWriter) {
        for (DomNode child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            child.printXml(indent + "  ", printWriter);
        }
    }

    @Override
    public String getNodeValue() {
        return null;
    }

    @Override
    public void setNodeValue(String value) {
    }

    @Override
    public DomNode cloneNode(boolean deep) {
        DomNode newnode;
        try {
            newnode = (DomNode)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Clone not supported for node [" + this + "]");
        }
        newnode.parent_ = null;
        newnode.nextSibling_ = null;
        newnode.previousSibling_ = null;
        newnode.firstChild_ = null;
        newnode.scriptObject_ = null;
        if (deep) {
            DomNode child = this.firstChild_;
            while (child != null) {
                newnode.appendChild(child.cloneNode(true));
                child = child.nextSibling_;
            }
        }
        return newnode;
    }

    public ScriptableObject getScriptObject() {
        if (this.scriptObject_ == null) {
            SgmlPage page = this.getPage();
            if (this == this.getPage()) {
                StringBuilder msg = new StringBuilder("No script object associated with the Page.");
                msg.append(" class: '");
                msg.append(page.getClass().getName());
                msg.append("'");
                try {
                    msg.append(" url: '" + page.getUrl() + "'");
                    msg.append(" content: ");
                    msg.append(page.getWebResponse().getContentAsString());
                }
                catch (Exception e) {
                    msg.append(" no details: '" + e.toString() + "'");
                }
                throw new IllegalStateException(msg.toString());
            }
            this.scriptObject_ = ((SimpleScriptable)this.page_.getScriptObject()).makeScriptableFor(this);
        }
        return this.scriptObject_;
    }

    @Override
    public DomNode appendChild(Node node) {
        if (node == this) {
            if (!this.hasFeature(BrowserVersionFeatures.NODE_APPEND_CHILD_SELF_IGNORE)) {
                Context.throwAsScriptRuntimeEx(new Exception("Can not add not to itself " + this));
            }
            return this;
        }
        DomNode domNode = (DomNode)node;
        if (domNode.isDescendant(this)) {
            Context.throwAsScriptRuntimeEx(new Exception("Can not add (grand)parent to itself " + this));
        }
        if (domNode instanceof DomDocumentFragment) {
            DomDocumentFragment fragment = (DomDocumentFragment)domNode;
            for (DomNode child : fragment.getChildren()) {
                this.appendChild(child);
            }
        } else {
            if (domNode != this && domNode.getParentNode() != null) {
                domNode.remove();
            }
            this.basicAppend(domNode);
            this.fireAddition(domNode);
        }
        return domNode;
    }

    private void fireAddition(DomNode domNode) {
        boolean wasAlreadyAttached = domNode.isDirectlyAttachedToPage();
        domNode.directlyAttachedToPage_ = this.isDirectlyAttachedToPage();
        if (!(this instanceof DomDocumentFragment) && this.getPage() instanceof HtmlPage) {
            ((HtmlPage)this.getPage()).notifyNodeAdded(domNode);
        }
        if (!domNode.isBodyParsed() && this.isDirectlyAttachedToPage() && !wasAlreadyAttached) {
            domNode.onAddedToPage();
            for (DomNode child : domNode.getDescendants()) {
                child.directlyAttachedToPage_ = true;
                child.onAllChildrenAddedToPage(true);
            }
            domNode.onAllChildrenAddedToPage(true);
        }
        this.fireNodeAdded(this, domNode);
    }

    private boolean isBodyParsed() {
        return this.getStartLineNumber() != -1 && this.getEndLineNumber() == -1;
    }

    void quietlyRemoveAndMoveChildrenTo(DomNode destination) {
        if (destination.getPage() != this.getPage()) {
            throw new RuntimeException("Cannot perform quiet move on nodes from different pages.");
        }
        for (DomNode child : this.getChildren()) {
            child.basicRemove();
            destination.basicAppend(child);
        }
        this.basicRemove();
    }

    private void basicAppend(DomNode node) {
        node.setPage(this.getPage());
        if (this.firstChild_ == null) {
            this.firstChild_ = node;
            this.firstChild_.previousSibling_ = node;
        } else {
            DomNode last = this.getLastChild();
            last.nextSibling_ = node;
            node.previousSibling_ = last;
            node.nextSibling_ = null;
            this.firstChild_.previousSibling_ = node;
        }
        node.parent_ = this;
    }

    protected void checkChildHierarchy(Node newChild) throws DOMException {
        for (Node parentNode = this; parentNode != null; parentNode = parentNode.getParentNode()) {
            if (parentNode != newChild) continue;
            throw new DOMException(3, "Child node is already a parent.");
        }
        org.w3c.dom.Document thisDocument = this.getOwnerDocument();
        org.w3c.dom.Document childDocument = newChild.getOwnerDocument();
        if (childDocument != thisDocument && childDocument != null) {
            throw new DOMException(4, "Child node " + newChild.getNodeName() + " is not in the same Document as this " + this.getNodeName() + ".");
        }
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) {
        if (refChild == null) {
            this.appendChild(newChild);
        } else {
            if (refChild.getParentNode() != this) {
                throw new DOMException(8, "Reference node is not a child of this node.");
            }
            ((DomNode)refChild).insertBefore((DomNode)newChild);
        }
        return null;
    }

    public void insertBefore(DomNode newNode) throws IllegalStateException {
        if (this.previousSibling_ == null) {
            throw new IllegalStateException("Previous sibling for " + this + " is null.");
        }
        if (newNode == this) {
            return;
        }
        DomNode exParent = newNode.getParentNode();
        newNode.basicRemove();
        if (this.parent_.firstChild_ == this) {
            this.parent_.firstChild_ = newNode;
        } else {
            this.previousSibling_.nextSibling_ = newNode;
        }
        newNode.previousSibling_ = this.previousSibling_;
        newNode.nextSibling_ = this;
        this.previousSibling_ = newNode;
        newNode.parent_ = this.parent_;
        newNode.setPage(this.page_);
        this.fireAddition(newNode);
        if (exParent != null) {
            this.fireNodeDeleted(exParent, newNode);
            exParent.fireNodeDeleted(exParent, this);
        }
    }

    private void setPage(SgmlPage newPage) {
        if (this.page_ == newPage) {
            return;
        }
        this.page_ = newPage;
        for (DomNode node : this.getChildren()) {
            node.setPage(newPage);
        }
    }

    @Override
    public NamedNodeMap getAttributes() {
        return NamedAttrNodeMapImpl.EMPTY_MAP;
    }

    @Override
    public Node removeChild(Node child) {
        if (child.getParentNode() != this) {
            throw new DOMException(8, "Node is not a child of this node.");
        }
        ((DomNode)child).remove();
        return child;
    }

    public void remove() {
        DomNode exParent = this.parent_;
        this.basicRemove();
        if (this.getPage() instanceof HtmlPage) {
            ((HtmlPage)this.getPage()).notifyNodeRemoved(this);
        }
        if (exParent != null) {
            this.fireNodeDeleted(exParent, this);
            exParent.fireNodeDeleted(exParent, this);
        }
    }

    private void basicRemove() {
        if (this.parent_ != null && this.parent_.firstChild_ == this) {
            this.parent_.firstChild_ = this.nextSibling_;
        } else if (this.previousSibling_ != null && this.previousSibling_.nextSibling_ == this) {
            this.previousSibling_.nextSibling_ = this.nextSibling_;
        }
        if (this.nextSibling_ != null && this.nextSibling_.previousSibling_ == this) {
            this.nextSibling_.previousSibling_ = this.previousSibling_;
        }
        if (this.parent_ != null && this == this.parent_.getLastChild()) {
            this.parent_.firstChild_.previousSibling_ = this.previousSibling_;
        }
        this.nextSibling_ = null;
        this.previousSibling_ = null;
        this.parent_ = null;
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) {
        if (oldChild.getParentNode() != this) {
            throw new DOMException(8, "Node is not a child of this node.");
        }
        ((DomNode)oldChild).replace((DomNode)newChild);
        return oldChild;
    }

    public void replace(DomNode newNode) throws IllegalStateException {
        if (newNode != this) {
            newNode.remove();
            this.insertBefore(newNode);
            this.remove();
        }
    }

    protected void onAddedToPage() {
        if (this.firstChild_ != null) {
            for (DomNode child : this.getChildren()) {
                child.onAddedToPage();
            }
        }
    }

    protected void onAllChildrenAddedToPage(boolean postponed) {
    }

    public final Iterable<DomNode> getChildren() {
        return new Iterable<DomNode>(){

            @Override
            public Iterator<DomNode> iterator() {
                return new ChildIterator();
            }
        };
    }

    public final Iterable<DomNode> getDescendants() {
        return new Iterable<DomNode>(){

            @Override
            public Iterator<DomNode> iterator() {
                return new DescendantElementsIterator<DomNode>(DomNode.class);
            }
        };
    }

    public final Iterable<HtmlElement> getHtmlElementDescendants() {
        return new Iterable<HtmlElement>(){

            @Override
            public Iterator<HtmlElement> iterator() {
                return new DescendantElementsIterator<HtmlElement>(HtmlElement.class);
            }
        };
    }

    public String getReadyState() {
        return this.readyState_;
    }

    public void setReadyState(String state) {
        this.readyState_ = state;
    }

    public void removeAllChildren() {
        if (this.getFirstChild() == null) {
            return;
        }
        Iterator<DomNode> it = this.getChildren().iterator();
        while (it.hasNext()) {
            it.next().removeAllChildren();
            it.remove();
        }
    }

    public List<?> getByXPath(String xpathExpr) {
        return XPathUtils.getByXPath(this, xpathExpr);
    }

    public <X> X getFirstByXPath(String xpathExpr) {
        List<?> results = this.getByXPath(xpathExpr);
        if (results.isEmpty()) {
            return null;
        }
        return (X)results.get(0);
    }

    public String getCanonicalXPath() {
        throw new RuntimeException("Method getCanonicalXPath() not implemented for nodes of type " + this.getNodeType());
    }

    protected void notifyIncorrectness(String message) {
        WebClient client = this.getPage().getEnclosingWindow().getWebClient();
        IncorrectnessListener incorrectnessListener = client.getIncorrectnessListener();
        incorrectnessListener.notify(message, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDomChangeListener(DomChangeListener listener) {
        WebAssert.notNull("listener", listener);
        Object object = this.domListeners_lock_;
        synchronized (object) {
            if (this.domListeners_ == null) {
                this.domListeners_ = new LinkedHashSet<DomChangeListener>();
            }
            this.domListeners_.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDomChangeListener(DomChangeListener listener) {
        WebAssert.notNull("listener", listener);
        Object object = this.domListeners_lock_;
        synchronized (object) {
            if (this.domListeners_ != null) {
                this.domListeners_.remove(listener);
            }
        }
    }

    protected void fireNodeAdded(DomNode parentNode, DomNode addedNode) {
        List<DomChangeListener> listeners = this.safeGetDomListeners();
        if (listeners != null) {
            DomChangeEvent event = new DomChangeEvent(parentNode, addedNode);
            for (DomChangeListener listener : listeners) {
                listener.nodeAdded(event);
            }
        }
        if (this.parent_ != null) {
            this.parent_.fireNodeAdded(parentNode, addedNode);
        }
    }

    protected void fireNodeDeleted(DomNode parentNode, DomNode deletedNode) {
        List<DomChangeListener> listeners = this.safeGetDomListeners();
        if (listeners != null) {
            DomChangeEvent event = new DomChangeEvent(parentNode, deletedNode);
            for (DomChangeListener listener : listeners) {
                listener.nodeDeleted(event);
            }
        }
        if (this.parent_ != null) {
            this.parent_.fireNodeDeleted(parentNode, deletedNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DomChangeListener> safeGetDomListeners() {
        Object object = this.domListeners_lock_;
        synchronized (object) {
            if (this.domListeners_ != null) {
                return new ArrayList<DomChangeListener>(this.domListeners_);
            }
            return null;
        }
    }

    public DomNodeList<DomNode> querySelectorAll(String selectors) {
        ArrayList<DomNode> elements = new ArrayList<DomNode>();
        try {
            WebClient webClient = this.getPage().getWebClient();
            final AtomicBoolean errorOccured = new AtomicBoolean(false);
            ErrorHandler errorHandler = new ErrorHandler(){

                @Override
                public void warning(CSSParseException exception) throws CSSException {
                }

                @Override
                public void fatalError(CSSParseException exception) throws CSSException {
                    errorOccured.set(true);
                }

                @Override
                public void error(CSSParseException exception) throws CSSException {
                    errorOccured.set(true);
                }
            };
            CSSOMParser parser = new CSSOMParser(new SACParserCSS3());
            parser.setErrorHandler(errorHandler);
            SelectorList selectorList = parser.parseSelectors(new InputSource(new StringReader(selectors)));
            if (errorOccured.get()) {
                throw new CSSException("Invalid selectors: " + selectors);
            }
            if (null != selectorList) {
                ScriptableObject sobj;
                BrowserVersion browserVersion = webClient.getBrowserVersion();
                int documentMode = 9;
                if (browserVersion.hasFeature(BrowserVersionFeatures.QUERYSELECTORALL_NOT_IN_QUIRKS) && (sobj = this.getPage().getScriptObject()) instanceof HTMLDocument) {
                    documentMode = ((HTMLDocument)sobj).getDocumentMode();
                }
                CSSStyleSheet.validateSelectors(selectorList, documentMode);
                for (HtmlElement child : this.getHtmlElementDescendants()) {
                    for (int i = 0; i < selectorList.getLength(); ++i) {
                        Selector selector = selectorList.item(i);
                        if (!CSSStyleSheet.selects(browserVersion, selector, (DomElement)child)) continue;
                        elements.add(child);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new CSSException("Error parsing CSS selectors from '" + selectors + "': " + e.getMessage());
        }
        return new StaticDomNodeList(elements);
    }

    public DomNode querySelector(String selectors) {
        DomNodeList<DomNode> list = this.querySelectorAll(selectors);
        if (!list.isEmpty()) {
            return (DomNode)list.get(0);
        }
        return null;
    }

    protected boolean isDirectlyAttachedToPage() {
        return this.directlyAttachedToPage_;
    }

    public void processImportNode(Document doc) {
    }

    protected boolean hasFeature(BrowserVersionFeatures feature) {
        return this.getPage().getWebClient().getBrowserVersion().hasFeature(feature);
    }

    protected boolean isDescendant(DomNode node) {
        for (DomNode parent = node; parent != null; parent = parent.getParentNode()) {
            if (parent != this) continue;
            return true;
        }
        return false;
    }

    protected class DescendantElementsIterator<T extends DomNode>
    implements Iterator<T> {
        private DomNode currentNode_;
        private DomNode nextNode_;
        private final Class<T> type_;

        public DescendantElementsIterator(Class<T> type) {
            this.type_ = type;
            this.nextNode_ = this.getFirstChildElement(DomNode.this);
        }

        @Override
        public boolean hasNext() {
            return this.nextNode_ != null;
        }

        @Override
        public T next() {
            return this.nextNode();
        }

        @Override
        public void remove() {
            if (this.currentNode_ == null) {
                throw new IllegalStateException("Unable to remove current node, because there is no current node.");
            }
            DomNode current = this.currentNode_;
            while (this.nextNode_ != null && current.isAncestorOf(this.nextNode_)) {
                this.next();
            }
            current.remove();
        }

        public T nextNode() {
            this.currentNode_ = this.nextNode_;
            this.setNextElement();
            return (T)this.currentNode_;
        }

        private void setNextElement() {
            DomNode next = this.getFirstChildElement(this.nextNode_);
            if (next == null) {
                next = this.getNextDomSibling(this.nextNode_);
            }
            if (next == null) {
                next = this.getNextElementUpwards(this.nextNode_);
            }
            this.nextNode_ = next;
        }

        private DomNode getNextElementUpwards(DomNode startingNode) {
            DomNode next;
            if (startingNode == DomNode.this) {
                return null;
            }
            DomNode parent = startingNode.getParentNode();
            if (parent == null || parent == DomNode.this) {
                return null;
            }
            for (next = parent.getNextSibling(); next != null && !this.isAccepted(next); next = next.getNextSibling()) {
            }
            if (next == null) {
                return this.getNextElementUpwards(parent);
            }
            return next;
        }

        private DomNode getFirstChildElement(DomNode parent) {
            DomNode node;
            for (node = parent.getFirstChild(); node != null && !this.isAccepted(node); node = node.getNextSibling()) {
            }
            return node;
        }

        protected boolean isAccepted(DomNode node) {
            return this.type_.isAssignableFrom(node.getClass());
        }

        private DomNode getNextDomSibling(DomNode element) {
            DomNode node;
            for (node = element.getNextSibling(); node != null && !this.isAccepted(node); node = node.getNextSibling()) {
            }
            return node;
        }
    }

    protected class ChildIterator
    implements Iterator<DomNode> {
        private DomNode nextNode_;
        private DomNode currentNode_;

        protected ChildIterator() {
            this.nextNode_ = DomNode.this.firstChild_;
            this.currentNode_ = null;
        }

        @Override
        public boolean hasNext() {
            return this.nextNode_ != null;
        }

        @Override
        public DomNode next() {
            if (this.nextNode_ != null) {
                this.currentNode_ = this.nextNode_;
                this.nextNode_ = this.nextNode_.nextSibling_;
                return this.currentNode_;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.currentNode_ == null) {
                throw new IllegalStateException();
            }
            this.currentNode_.remove();
        }
    }
}

