/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomComment;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JavaScriptConfiguration;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.NodeList;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLSubCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;

@JsxClass
public class HTMLCollection
extends NodeList {
    private int currentIndex_ = 0;

    @Deprecated
    public HTMLCollection() {
    }

    private HTMLCollection(ScriptableObject parentScope) {
        this.setParentScope(parentScope);
        this.setPrototype(this.getPrototype(this.getClass()));
    }

    public HTMLCollection(DomNode parentScope, boolean attributeChangeSensitive, String description) {
        super(parentScope, attributeChangeSensitive, description);
    }

    HTMLCollection(DomNode parentScope, List<?> initialElements) {
        super(parentScope, initialElements);
    }

    public static HTMLCollection emptyCollection(Window window) {
        final List list = Collections.emptyList();
        return new HTMLCollection((ScriptableObject)window){

            @Override
            public List<Object> getElements() {
                return list;
            }
        };
    }

    private Object getIt(Object o) {
        if (o instanceof Number) {
            Number n = (Number)o;
            int i = n.intValue();
            return this.get(i, (Scriptable)this);
        }
        String key = String.valueOf(o);
        return this.get(key, (Scriptable)this);
    }

    @Override
    protected List<Object> computeElements() {
        ArrayList<Object> response = new ArrayList<Object>();
        Object domNode = this.getDomNodeOrNull();
        if (domNode == null) {
            return response;
        }
        for (DomNode node : this.getCandidates()) {
            boolean commentIncluded;
            boolean bl = commentIncluded = node instanceof DomComment && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLCOLLECTION_COMMENT_IS_ELEMENT);
            if (!(node instanceof DomElement) && !commentIncluded || !this.isMatching(node)) continue;
            response.add(node);
        }
        return response;
    }

    @Override
    protected Iterable<DomNode> getCandidates() {
        Object domNode = this.getDomNodeOrNull();
        return ((DomNode)domNode).getDescendants();
    }

    @Override
    protected boolean isMatching(DomNode node) {
        return false;
    }

    @Override
    protected Object getWithPreemption(String name) {
        if ("length".equals(name)) {
            return NOT_FOUND;
        }
        List<Object> elements = this.getElements();
        ArrayList<Object> matchingElements = new ArrayList<Object>();
        for (Object next : elements) {
            String id;
            if (!(next instanceof DomElement) || !name.equals(id = ((DomElement)next).getAttribute("id"))) continue;
            if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLCOLLECTION_IDENTICAL_IDS)) {
                return this.getScriptableForElement(next);
            }
            matchingElements.add(next);
        }
        if (matchingElements.size() == 1) {
            return this.getScriptableForElement(matchingElements.get(0));
        }
        if (!matchingElements.isEmpty()) {
            HTMLCollection collection = new HTMLCollection((DomNode)this.getDomNodeOrDie(), (List<?>)matchingElements);
            collection.setAvoidObjectDetection(!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLCOLLECTION_OBJECT_DETECTION));
            return collection;
        }
        for (Object next : elements) {
            String nodeName;
            if (!(next instanceof DomElement) || !name.equals(nodeName = ((DomElement)next).getAttribute("name"))) continue;
            if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLCOLLECTION_IDENTICAL_IDS)) {
                return this.getScriptableForElement(next);
            }
            matchingElements.add(next);
        }
        if (matchingElements.isEmpty()) {
            return NOT_FOUND;
        }
        if (matchingElements.size() == 1) {
            return this.getScriptableForElement(matchingElements.get(0));
        }
        Object domNode = this.getDomNodeOrNull();
        HTMLCollection collection = new HTMLCollection((DomNode)domNode, (List<?>)matchingElements);
        collection.setAvoidObjectDetection(!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLCOLLECTION_OBJECT_DETECTION));
        return collection;
    }

    private Object nullIfNotFound(Object object) {
        if (object == NOT_FOUND) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_48)) {
                return null;
            }
            return Context.getUndefinedValue();
        }
        return object;
    }

    @JsxFunction
    public final Object namedItem(String name) {
        return this.nullIfNotFound(this.getIt(name));
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public Object nextNode() {
        List<Object> elements = this.getElements();
        Object nextNode = this.currentIndex_ >= 0 && this.currentIndex_ < elements.size() ? elements.get(this.currentIndex_) : null;
        ++this.currentIndex_;
        return nextNode;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public void reset() {
        this.currentIndex_ = 0;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public Object tags(String tagName) {
        final String tagNameLC = tagName.toLowerCase();
        HTMLSubCollection collection = new HTMLSubCollection(this, ".tags('" + tagName + "')"){

            @Override
            protected boolean isMatching(DomNode node) {
                return tagNameLC.equalsIgnoreCase(node.getLocalName());
            }
        };
        return collection;
    }

    @Override
    protected Object equivalentValues(Object other) {
        if (other == this) {
            return Boolean.TRUE;
        }
        if (other instanceof HTMLCollection) {
            HTMLCollection otherArray = (HTMLCollection)other;
            Object domNode = this.getDomNodeOrNull();
            Object domNodeOther = otherArray.getDomNodeOrNull();
            if (this.getClass() == other.getClass() && domNode == domNodeOther && this.getElements().equals(otherArray.getElements())) {
                return Boolean.TRUE;
            }
            return NOT_FOUND;
        }
        return super.equivalentValues(other);
    }

    @Override
    public Object[] getIds() {
        if (this.isPrototype()) {
            return super.getIds();
        }
        ArrayList<String> idList = new ArrayList<String>();
        List<Object> elements = this.getElements();
        if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_50)) {
            int length = elements.size();
            for (int i = 0; i < length; ++i) {
                idList.add(Integer.toString(i));
            }
            idList.add("length");
            JavaScriptConfiguration jsConfig = this.getWindow().getWebWindow().getWebClient().getJavaScriptEngine().getJavaScriptConfiguration();
            for (String name : jsConfig.getClassConfiguration(this.getClassName()).functionKeys()) {
                idList.add(name);
            }
        } else {
            idList.add("length");
            this.addElementIds(idList, elements);
        }
        return idList.toArray();
    }

    private boolean isPrototype() {
        return !(this.getPrototype() instanceof HTMLCollection);
    }

    @Override
    protected void addElementIds(List<String> idList, List<Object> elements) {
        int index = 0;
        for (Object next : elements) {
            HtmlElement element = (HtmlElement)next;
            String name = element.getAttribute("name");
            if (name != DomElement.ATTRIBUTE_NOT_DEFINED) {
                idList.add(name);
            } else {
                String id = element.getId();
                if (id != DomElement.ATTRIBUTE_NOT_DEFINED) {
                    idList.add(id);
                } else {
                    idList.add(Integer.toString(index));
                }
            }
            ++index;
        }
    }

    @Override
    protected Scriptable getScriptableForElement(Object object) {
        if (object instanceof Scriptable) {
            return (Scriptable)object;
        }
        return this.getScriptableFor(object);
    }

    @Override
    public String getClassName() {
        return "HTMLCollection";
    }
}

