/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Map;
import org.openqa.selenium.WebDriverException;

public enum OperaProduct {
    CORE("core-gogi"),
    DESKTOP("desktop"),
    SDK("devices"),
    MOBILE("mobile"),
    MINI("mini"),
    ALL(""){

        @Override
        public boolean is(OperaProduct compareWith) {
            return true;
        }
    };

    private static final Map<String, OperaProduct> lookup;
    private final String product;

    private OperaProduct(String product) {
        this.product = product;
    }

    public String getDescriptionString() {
        return this.product;
    }

    public String toString() {
        switch (OperaProduct.get(this.product)) {
            case CORE: {
                return "gogi";
            }
            case SDK: {
                return "SDK";
            }
            case DESKTOP: 
            case MOBILE: 
            case MINI: {
                return "Opera " + Character.toUpperCase(this.product.charAt(0)) + this.product.substring(1);
            }
        }
        return "(not specified)";
    }

    public boolean is(OperaProduct compareWith) {
        return this.equals((Object)compareWith);
    }

    public static OperaProduct get(String product) {
        if (product == null) {
            return ALL;
        }
        if (!lookup.containsKey(product)) {
            throw new WebDriverException("Unknown product: " + product);
        }
        return lookup.get(product);
    }

    static {
        lookup = Maps.uniqueIndex(ImmutableList.copyOf(OperaProduct.values()), new Function<OperaProduct, String>(){

            @Override
            public String apply(OperaProduct product) {
                return product.getDescriptionString();
            }
        });
    }
}

