/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.jetty7.webapp;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.seleniumhq.jetty7.util.Loader;
import org.seleniumhq.jetty7.util.log.Log;
import org.seleniumhq.jetty7.util.log.Logger;
import org.seleniumhq.jetty7.util.resource.Resource;
import org.seleniumhq.jetty7.webapp.AbstractConfiguration;
import org.seleniumhq.jetty7.webapp.Descriptor;
import org.seleniumhq.jetty7.webapp.IterativeDescriptorProcessor;
import org.seleniumhq.jetty7.webapp.WebAppContext;
import org.seleniumhq.jetty7.webapp.WebXmlConfiguration;
import org.seleniumhq.jetty7.xml.XmlParser;

public class TagLibConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = Log.getLogger(TagLibConfiguration.class);
    public static final String TLD_RESOURCES = "org.seleniumhq.jetty7.tlds";

    public void preConfigure(WebAppContext context) throws Exception {
        try {
            Class jsp_page = Loader.loadClass(WebXmlConfiguration.class, "javax.servlet.jsp.JspPage");
        }
        catch (Exception e) {
            return;
        }
        TagLibListener tagLibListener = new TagLibListener(context);
        context.addEventListener((EventListener)((Object)tagLibListener));
    }

    public void configure(WebAppContext context) throws Exception {
    }

    public void postConfigure(WebAppContext context) throws Exception {
    }

    public void cloneConfigure(WebAppContext template, WebAppContext context) throws Exception {
    }

    public void deconfigure(WebAppContext context) throws Exception {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TldProcessor
    extends IterativeDescriptorProcessor {
        public static final String TAGLIB_PROCESSOR = "org.seleniumhq.jetty7.tagLibProcessor";
        XmlParser _parser;
        List<XmlParser.Node> _roots = new ArrayList<XmlParser.Node>();
        List<EventListener> _listeners = new ArrayList<EventListener>();

        public TldProcessor() throws Exception {
            this.registerVisitor("listener", this.getClass().getDeclaredMethod("visitListener", __signature));
        }

        public void visitListener(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
            String className = node.getString("listener-class", false, true);
            if (LOG.isDebugEnabled()) {
                LOG.debug("listener=" + className, new Object[0]);
            }
            try {
                Class<?> listenerClass = context.loadClass(className);
                EventListener l = (EventListener)listenerClass.newInstance();
                this._listeners.add(l);
            }
            catch (Exception e) {
                LOG.warn("Could not instantiate listener " + className + ": " + e, new Object[0]);
                LOG.debug(e);
            }
            catch (Error e) {
                LOG.warn("Could not instantiate listener " + className + ": " + e, new Object[0]);
                LOG.debug(e);
            }
        }

        @Override
        public void end(WebAppContext context, Descriptor descriptor) {
        }

        @Override
        public void start(WebAppContext context, Descriptor descriptor) {
        }

        public List<EventListener> getListeners() {
            return this._listeners;
        }
    }

    public static class TldDescriptor
    extends Descriptor {
        protected static XmlParser __parserSingleton;

        public TldDescriptor(Resource xml) {
            super(xml);
        }

        public void ensureParser() throws ClassNotFoundException {
            if (__parserSingleton == null) {
                __parserSingleton = this.newParser();
            }
            this._parser = __parserSingleton;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public XmlParser newParser() throws ClassNotFoundException {
            XmlParser parser = new XmlParser(false);
            URL taglib11 = null;
            URL taglib12 = null;
            URL taglib20 = null;
            URL taglib21 = null;
            try {
                Class jsp_page = Loader.loadClass(WebXmlConfiguration.class, "javax.servlet.jsp.JspPage");
                taglib11 = jsp_page.getResource("javax/servlet/jsp/resources/web-jsptaglibrary_1_1.dtd");
                taglib12 = jsp_page.getResource("javax/servlet/jsp/resources/web-jsptaglibrary_1_2.dtd");
                taglib20 = jsp_page.getResource("javax/servlet/jsp/resources/web-jsptaglibrary_2_0.xsd");
                taglib21 = jsp_page.getResource("javax/servlet/jsp/resources/web-jsptaglibrary_2_1.xsd");
            }
            catch (Exception e) {
                LOG.ignore(e);
            }
            finally {
                if (taglib11 == null) {
                    taglib11 = Loader.getResource(Servlet.class, "javax/servlet/jsp/resources/web-jsptaglibrary_1_1.dtd", true);
                }
                if (taglib12 == null) {
                    taglib12 = Loader.getResource(Servlet.class, "javax/servlet/jsp/resources/web-jsptaglibrary_1_2.dtd", true);
                }
                if (taglib20 == null) {
                    taglib20 = Loader.getResource(Servlet.class, "javax/servlet/jsp/resources/web-jsptaglibrary_2_0.xsd", true);
                }
                if (taglib21 == null) {
                    taglib21 = Loader.getResource(Servlet.class, "javax/servlet/jsp/resources/web-jsptaglibrary_2_1.xsd", true);
                }
            }
            if (taglib11 != null) {
                this.redirect(parser, "web-jsptaglib_1_1.dtd", taglib11);
                this.redirect(parser, "web-jsptaglibrary_1_1.dtd", taglib11);
            }
            if (taglib12 != null) {
                this.redirect(parser, "web-jsptaglib_1_2.dtd", taglib12);
                this.redirect(parser, "web-jsptaglibrary_1_2.dtd", taglib12);
            }
            if (taglib20 != null) {
                this.redirect(parser, "web-jsptaglib_2_0.xsd", taglib20);
                this.redirect(parser, "web-jsptaglibrary_2_0.xsd", taglib20);
            }
            if (taglib21 != null) {
                this.redirect(parser, "web-jsptaglib_2_1.xsd", taglib21);
                this.redirect(parser, "web-jsptaglibrary_2_1.xsd", taglib21);
            }
            parser.setXpath("/taglib/listener/listener-class");
            return parser;
        }

        public void parse() throws Exception {
            this.ensureParser();
            try {
                this._root = this._parser.parse(this._xml.getInputStream());
            }
            catch (Exception e) {
                this._root = this._parser.parse(this._xml.getURL().toString());
            }
            if (this._root == null) {
                LOG.warn("No TLD root in {}", this._xml);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TagLibListener
    implements ServletContextListener {
        private List<EventListener> _tldListeners;
        private WebAppContext _context;

        public TagLibListener(WebAppContext context) {
            this._context = context;
        }

        public void contextDestroyed(ServletContextEvent sce) {
            if (this._tldListeners == null) {
                return;
            }
            for (int i = this._tldListeners.size() - 1; i >= 0; --i) {
                EventListener l = this._tldListeners.get(i);
                if (!(l instanceof ServletContextListener)) continue;
                ((ServletContextListener)l).contextDestroyed(sce);
            }
        }

        public void contextInitialized(ServletContextEvent sce) {
            try {
                try {
                    Class<?> clazz = this.getClass().getClassLoader().loadClass("org.apache.jasper.compiler.TldLocationsCache");
                    Collection tld_resources = (Collection)this._context.getAttribute(TagLibConfiguration.TLD_RESOURCES);
                    HashMap tldMap = new HashMap();
                    if (tld_resources != null) {
                        for (Resource r : tld_resources) {
                            Resource jarResource = this.extractJarResource(r);
                            if (tldMap.containsKey(jarResource.getURI())) continue;
                            tldMap.put(jarResource.getURI(), null);
                        }
                        sce.getServletContext().setAttribute("com.sun.appserv.tld.map", tldMap);
                    }
                }
                catch (ClassNotFoundException e) {
                    LOG.ignore(e);
                }
                Set<Resource> tlds = this.findTldResources();
                List<TldDescriptor> descriptors = this.parseTlds(tlds);
                this.processTlds(descriptors);
                if (this._tldListeners == null) {
                    return;
                }
                for (EventListener l : this._tldListeners) {
                    if (l instanceof ServletContextListener) {
                        ((ServletContextListener)l).contextInitialized(sce);
                        continue;
                    }
                    this._context.addEventListener(l);
                }
            }
            catch (Exception e) {
                LOG.warn(e);
            }
        }

        private Resource extractJarResource(Resource r) {
            if (r == null) {
                return null;
            }
            try {
                String url = r.getURI().toURL().toString();
                int idx = url.lastIndexOf("!/");
                if (idx >= 0) {
                    url = url.substring(0, idx);
                }
                if (url.startsWith("jar:")) {
                    url = url.substring(4);
                }
                return Resource.newResource(url);
            }
            catch (IOException e) {
                LOG.warn(e);
                return null;
            }
        }

        private Set<Resource> findTldResources() throws IOException {
            Collection tld_resources;
            Resource web_inf_tlds;
            Resource web_inf;
            HashSet<Resource> tlds = new HashSet<Resource>();
            if (this._context.getResourceAliases() != null && this._context.getBaseResource() != null && this._context.getBaseResource().exists()) {
                for (String location : this._context.getResourceAliases().values()) {
                    if (location == null || !location.toLowerCase().endsWith(".tld")) continue;
                    if (!location.startsWith("/")) {
                        location = "/WEB-INF/" + location;
                    }
                    Resource l = this._context.getBaseResource().addPath(location);
                    tlds.add(l);
                }
            }
            if ((web_inf = this._context.getWebInf()) != null) {
                String[] contents = web_inf.list();
                for (int i = 0; contents != null && i < contents.length; ++i) {
                    if (contents[i] == null || !contents[i].toLowerCase().endsWith(".tld")) continue;
                    Resource l = web_inf.addPath(contents[i]);
                    tlds.add(l);
                }
            }
            if (web_inf != null && (web_inf_tlds = this._context.getWebInf().addPath("/tlds/")).exists() && web_inf_tlds.isDirectory()) {
                String[] contents = web_inf_tlds.list();
                for (int i = 0; contents != null && i < contents.length; ++i) {
                    if (contents[i] == null || !contents[i].toLowerCase().endsWith(".tld")) continue;
                    Resource l = web_inf_tlds.addPath(contents[i]);
                    tlds.add(l);
                }
            }
            if ((tld_resources = (Collection)this._context.getAttribute(TagLibConfiguration.TLD_RESOURCES)) != null) {
                tlds.addAll(tld_resources);
            }
            return tlds;
        }

        private List<TldDescriptor> parseTlds(Set<Resource> tlds) {
            ArrayList<TldDescriptor> descriptors = new ArrayList<TldDescriptor>();
            Resource tld = null;
            Iterator<Resource> iter = tlds.iterator();
            while (iter.hasNext()) {
                try {
                    tld = iter.next();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("TLD=" + tld, new Object[0]);
                    }
                    TldDescriptor d = new TldDescriptor(tld);
                    d.parse();
                    descriptors.add(d);
                }
                catch (Exception e) {
                    LOG.warn("Unable to parse TLD: " + tld, e);
                }
            }
            return descriptors;
        }

        private void processTlds(List<TldDescriptor> descriptors) throws Exception {
            TldProcessor processor = new TldProcessor();
            for (TldDescriptor d : descriptors) {
                processor.process(this._context, d);
            }
            this._tldListeners = new ArrayList<EventListener>(processor.getListeners());
        }
    }
}

