/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber;

import com.caucho.amber.AmberException;
import com.caucho.amber.entity.AmberCompletion;
import com.caucho.amber.entity.AmberEntityHome;
import com.caucho.amber.entity.EntityItem;
import com.caucho.amber.entity.EntityKey;
import com.caucho.amber.gen.AmberEnhancer;
import com.caucho.amber.gen.AmberGenerator;
import com.caucho.amber.manager.AmberConnection;
import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.query.QueryCacheKey;
import com.caucho.amber.query.ResultSetCacheChunk;
import com.caucho.amber.type.EntityType;
import com.caucho.bytecode.JClassLoader;
import com.caucho.config.ConfigException;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.loader.enhancer.EnhancerManager;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvAmberManager {
    private static final Logger log = Logger.getLogger(AmberPersistenceUnit.class.getName());
    private static final L10N L = new L10N(AmberPersistenceUnit.class);
    private static EnvironmentLocal<EnvAmberManager> _localManager = new EnvironmentLocal();
    private ClassLoader _parentLoader;
    private ArrayList<AmberPersistenceUnit> _managerList = new ArrayList();
    private AmberEnhancer _enhancer;
    private long _tableCacheTimeout = 250L;
    private JClassLoader _jClassLoader;
    private HashMap<String, AmberEntityHome> _entityHomeMap = new HashMap();
    private LruCache<QueryCacheKey, SoftReference<ResultSetCacheChunk>> _queryCache = new LruCache(1024);
    private LruCache<EntityKey, SoftReference<EntityItem>> _entityCache = new LruCache(32768);
    private EntityKey _entityKey = new EntityKey();
    private long _xid;
    private AmberGenerator _generator;
    private volatile boolean _isInit;

    private EnvAmberManager() {
        this._parentLoader = Thread.currentThread().getContextClassLoader();
        this._jClassLoader = EnhancerManager.create(this._parentLoader).getJavaClassLoader();
        try {
            if (this._parentLoader instanceof DynamicClassLoader) {
                ((DynamicClassLoader)this._parentLoader).make();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        EnhancerManager.create().addClassEnhancer(this._enhancer);
    }

    public static EnvAmberManager createLocal() {
        EnvAmberManager manager = _localManager.get();
        if (manager == null) {
            manager = new EnvAmberManager();
            _localManager.set(manager);
        }
        return manager;
    }

    public void addAmberManager(AmberPersistenceUnit manager) {
        this._managerList.add(manager);
    }

    public void setTableCacheTimeout(long timeout) {
        this._tableCacheTimeout = timeout;
    }

    public long getTableCacheTimeout() {
        return this._tableCacheTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getXid() {
        EnvAmberManager envAmberManager = this;
        synchronized (envAmberManager) {
            return this._xid++;
        }
    }

    public ClassLoader getEnhancedLoader() {
        return this._parentLoader;
    }

    public JClassLoader getJClassLoader() {
        return this._jClassLoader;
    }

    public void addEntityHome(String name, AmberEntityHome home) {
        this._entityHomeMap.put(name, home);
    }

    public AmberEntityHome getEntityHome(String name) {
        if (!this._isInit) {
            // empty if block
        }
        return this._entityHomeMap.get(name);
    }

    public EntityType getEntity(String className) {
        AmberEntityHome home = this._entityHomeMap.get(className);
        if (home != null) {
            return home.getEntityType();
        }
        return null;
    }

    public EntityType getEntityByInstanceClass(String className) {
        throw new UnsupportedOperationException();
    }

    public void setGenerator(AmberGenerator generator) {
        this._generator = generator;
    }

    public AmberGenerator getGenerator() {
        if (this._generator != null) {
            return this._generator;
        }
        if (this._enhancer != null) {
            return this._enhancer;
        }
        return this._generator;
    }

    public void initLoaders() throws ConfigException, IOException {
    }

    public AmberConnection createAmberConnection(boolean isExtended) {
        return this._managerList.get(0).createAmberConnection(isExtended);
    }

    public void initEntityHomes() throws Exception {
        for (AmberPersistenceUnit manager : this._managerList) {
            manager.initEntityHomes();
        }
    }

    public void init() throws ConfigException, IOException {
        this.initLoaders();
    }

    public AmberEntityHome getHome(Class cl) {
        return this.getEntityHome(cl.getName());
    }

    public ResultSetCacheChunk getQueryChunk(QueryCacheKey key) {
        SoftReference<ResultSetCacheChunk> ref = this._queryCache.get(key);
        if (ref == null) {
            return null;
        }
        ResultSetCacheChunk chunk = ref.get();
        if (chunk != null && chunk.isValid()) {
            return chunk;
        }
        return null;
    }

    public void putQueryChunk(QueryCacheKey key, ResultSetCacheChunk chunk) {
        this._queryCache.put(key, new SoftReference<ResultSetCacheChunk>(chunk));
    }

    public EntityItem getEntityItem(String homeName, Object key) throws AmberException {
        AmberEntityHome home = this.getEntityHome(homeName);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityItem getEntity(EntityType rootType, Object key) {
        SoftReference<EntityItem> ref;
        EntityKey entityKey = this._entityKey;
        synchronized (entityKey) {
            this._entityKey.init(rootType.getInstanceClass(), key);
            ref = this._entityCache.get(this._entityKey);
        }
        if (ref != null) {
            return ref.get();
        }
        return null;
    }

    public EntityItem putEntity(EntityType rootType, Object key, EntityItem entity) {
        SoftReference<EntityItem> ref = new SoftReference<EntityItem>(entity);
        EntityKey entityKey = new EntityKey(rootType.getInstanceClass(), key);
        ref = this._entityCache.putIfNew(entityKey, ref);
        return ref.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityItem removeEntity(EntityType rootType, Object key) {
        SoftReference<EntityItem> ref;
        EntityKey entityKey = this._entityKey;
        synchronized (entityKey) {
            this._entityKey.init(rootType.getInstanceClass(), key);
            ref = this._entityCache.remove(this._entityKey);
        }
        if (ref != null) {
            return ref.get();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete(ArrayList<AmberCompletion> completions) {
        Iterator<Object> iter;
        int size = completions.size();
        if (size == 0) {
            return;
        }
        LruCache<Object, SoftReference<Object>> lruCache = this._entityCache;
        synchronized (lruCache) {
            iter = this._entityCache.iterator();
            while (iter.hasNext()) {
                LruCache.Entry<EntityKey, SoftReference<EntityItem>> entry = iter.next();
                EntityKey key = entry.getKey();
                SoftReference<EntityItem> valueRef = entry.getValue();
                EntityItem value = valueRef.get();
                if (value == null) continue;
                EntityType entityRoot = value.getEntityHome().getEntityType();
                Object entityKey = key.getKey();
                for (int i = 0; i < size; ++i) {
                    if (!completions.get(i).complete(entityRoot, entityKey, value)) continue;
                }
            }
        }
        lruCache = this._queryCache;
        synchronized (lruCache) {
            iter = this._queryCache.values();
            while (iter.hasNext()) {
                SoftReference ref = (SoftReference)iter.next();
                ResultSetCacheChunk chunk = (ResultSetCacheChunk)ref.get();
                if (chunk == null) continue;
                for (int i = 0; i < size; ++i) {
                    if (!completions.get(i).complete(chunk)) continue;
                }
            }
        }
    }

    public void destroy() {
        this._queryCache = null;
        this._entityCache = null;
        this._parentLoader = null;
    }

    public String toString() {
        return "EnvAmberManager[]";
    }
}

