/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.cfg;

import com.caucho.amber.cfg.AbstractRelationConfig;
import com.caucho.amber.cfg.BaseConfigIntrospector;
import com.caucho.amber.cfg.JoinColumnConfig;
import com.caucho.amber.cfg.JoinTableConfig;
import com.caucho.amber.cfg.MapKeyConfig;
import com.caucho.amber.field.ManyToManyField;
import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.table.AmberTable;
import com.caucho.amber.table.ForeignColumn;
import com.caucho.amber.table.LinkColumns;
import com.caucho.amber.type.EntityType;
import com.caucho.bytecode.JType;
import com.caucho.bytecode.JTypeWrapper;
import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;

class ManyToManyConfig
extends AbstractRelationConfig {
    private static final L10N L = new L10N(ManyToManyConfig.class);
    private BaseConfigIntrospector _introspector;
    private EntityType _sourceType;
    private AccessibleObject _field;
    private String _fieldName;
    private Class _fieldType;
    private String _mappedBy;
    private MapKeyConfig _mapKey;
    private String _orderBy;

    ManyToManyConfig(BaseConfigIntrospector introspector, EntityType sourceType, AccessibleObject field, String fieldName, Class fieldType) {
        this._introspector = introspector;
        this._sourceType = sourceType;
        this._field = field;
        this._fieldName = fieldName;
        this._fieldType = fieldType;
        this.setName(this._fieldName);
        this.introspect();
    }

    public String getMappedBy() {
        return this._mappedBy;
    }

    public void setMappedBy(String mappedBy) {
        this._mappedBy = mappedBy;
    }

    public MapKeyConfig getMapKey() {
        return this._mapKey;
    }

    public void setMapKey(MapKeyConfig mapKey) {
        this._mapKey = mapKey;
    }

    public String getOrderBy() {
        return this._orderBy;
    }

    public void setOrderBy(String orderBy) {
        this._orderBy = orderBy;
    }

    public boolean isOwningSide() {
        return "".equals(this._mappedBy);
    }

    private void introspect() {
        JoinTable joinTableAnn;
        this.introspectTypes();
        ManyToMany manyToMany = this._field.getAnnotation(ManyToMany.class);
        if (manyToMany != null) {
            this.introspectManyToMany(manyToMany);
        }
        if ((joinTableAnn = this._field.getAnnotation(JoinTable.class)) != null) {
            this.setJoinTable(new JoinTableConfig(joinTableAnn));
        }
    }

    private void introspectTypes() {
        ClassLoader loader;
        Type retType = this._field instanceof Field ? ((Field)this._field).getGenericType() : ((Method)this._field).getGenericReturnType();
        JType type = JTypeWrapper.create(retType, loader = this._sourceType.getPersistenceUnit().getTempClassLoader());
        JType[] typeArgs = type.getActualTypeArguments();
        if (typeArgs.length > 0) {
            this.setTargetEntity(typeArgs[0].getRawType().getJavaClass());
        }
    }

    private void introspectManyToMany(ManyToMany manyToMany) {
        Class targetClass = manyToMany.targetEntity();
        if (!Void.TYPE.equals(targetClass)) {
            this.setTargetEntity(targetClass);
        }
        this.setCascadeTypes(manyToMany.cascade());
        this.setFetch(manyToMany.fetch());
        this._mappedBy = manyToMany.mappedBy();
    }

    private void introspectJoinColumns(JoinColumn[] joinColumns) {
        for (JoinColumn joinColumn : joinColumns) {
        }
    }

    public EntityType getRelatedType() {
        return this._sourceType;
    }

    public void complete() {
        this.addManyToMany(this._sourceType, this._field, this._fieldName, this._fieldType);
    }

    void addManyToMany(EntityType sourceType, AccessibleObject field, String fieldName, Class fieldType) throws ConfigException {
        AmberPersistenceUnit persistenceUnit = this._sourceType.getPersistenceUnit();
        Class targetClass = this.getTargetEntity();
        if (targetClass == null || Void.TYPE.equals(targetClass)) {
            throw ManyToManyConfig.error(field, L.l("Can't determine targetEntity for {0}.  @ManyToMany properties must target @Entity beans.", this._fieldName));
        }
        EntityType targetType = persistenceUnit.getEntityType(targetClass);
        if (targetType == null) {
            throw ManyToManyConfig.error(field, L.l("targetEntity '{0}' is not an @Entity bean for {1}.  The targetEntity of a @ManyToMany collection must be an @Entity bean.", (Object)targetClass.getName(), this._fieldName));
        }
        if (!this.isOwningSide()) {
            this.addDependentSide(targetType);
        } else {
            this.addOwningSide(targetType);
        }
    }

    private void addOwningSide(EntityType targetType) {
        AmberPersistenceUnit persistenceUnit = this._sourceType.getPersistenceUnit();
        ManyToManyField manyToManyField = new ManyToManyField(this._sourceType, this._fieldName, this.getCascade());
        manyToManyField.setType(targetType);
        String sqlTable = this._sourceType.getTable().getName() + "_" + targetType.getTable().getName();
        JoinTableConfig joinTableConfig = this.getJoinTable();
        AmberTable mapTable = null;
        ArrayList<ForeignColumn> sourceColumns = null;
        ArrayList<ForeignColumn> targetColumns = null;
        HashMap<String, JoinColumnConfig> joinColumnsConfig = null;
        HashMap<String, JoinColumnConfig> inverseJoinColumnsConfig = null;
        if (joinTableConfig != null) {
            String joinTableName = joinTableConfig.getName();
            joinColumnsConfig = joinTableConfig.getJoinColumnMap();
            inverseJoinColumnsConfig = joinTableConfig.getInverseJoinColumnMap();
            if (joinColumnsConfig != null && joinColumnsConfig.size() > 0) {
                manyToManyField.setJoinColumns(true);
            }
            if (inverseJoinColumnsConfig != null && inverseJoinColumnsConfig.size() > 0) {
                manyToManyField.setInverseJoinColumns(true);
            }
            if (!joinTableName.equals("")) {
                sqlTable = joinTableName;
            }
        }
        mapTable = persistenceUnit.createTable(sqlTable);
        sourceColumns = this.calculateColumns(this._field, this._fieldName, mapTable, this._sourceType.getTable().getName() + "_", this._sourceType, joinColumnsConfig);
        targetColumns = this.calculateColumns(this._field, this._fieldName, mapTable, targetType.getTable().getName() + "_", targetType, inverseJoinColumnsConfig);
        manyToManyField.setAssociationTable(mapTable);
        manyToManyField.setTable(sqlTable);
        manyToManyField.setLazy(this.isFetchLazy());
        manyToManyField.setSourceLink(new LinkColumns(mapTable, this._sourceType.getTable(), sourceColumns));
        manyToManyField.setTargetLink(new LinkColumns(mapTable, targetType.getTable(), targetColumns));
        this._sourceType.addField(manyToManyField);
    }

    private void addMapKey() {
        MapKeyConfig mapKeyConfig = this._mapKey;
        String key = mapKeyConfig.getName();
        String getter = "get" + Character.toUpperCase(key.charAt(0)) + key.substring(1);
    }

    private void addDependentSide(EntityType targetType) {
        String columnName;
        ArrayList<ForeignColumn> columns;
        ManyToManyField sourceField = (ManyToManyField)targetType.getField(this.getMappedBy());
        if (sourceField == null) {
            throw ManyToManyConfig.error(this._field, L.l("Unable to find the associated field in '{0}' for a @ManyToMany relationship from '{1}'", (Object)targetType.getName(), this._fieldName));
        }
        ManyToManyField manyToManyField = new ManyToManyField(this._sourceType, this._fieldName, sourceField, this.getCascade());
        manyToManyField.setType(targetType);
        this._sourceType.addField(manyToManyField);
        if (!sourceField.hasJoinColumns()) {
            LinkColumns sourceLink = sourceField.getSourceLink();
            columns = sourceLink.getColumns();
            for (ForeignColumn column : columns) {
                columnName = column.getName();
                columnName = columnName.substring(columnName.indexOf(95));
                columnName = ManyToManyConfig.toSqlName(manyToManyField.getName()) + columnName;
                column.setName(columnName);
            }
        }
        if (!sourceField.hasInverseJoinColumns()) {
            LinkColumns targetLink = sourceField.getTargetLink();
            columns = targetLink.getColumns();
            for (ForeignColumn column : columns) {
                columnName = column.getName();
                columnName = columnName.substring(columnName.indexOf(95));
                columnName = ManyToManyConfig.toSqlName(sourceField.getName()) + columnName;
                column.setName(columnName);
            }
        }
    }
}

