/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.expr;

import com.caucho.amber.expr.AmberExpr;
import com.caucho.amber.expr.EmbeddedExpr;
import com.caucho.amber.expr.SchemaExpr;
import com.caucho.amber.field.AmberField;
import com.caucho.amber.query.FromItem;
import com.caucho.amber.query.QueryParseException;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.type.EmbeddableType;
import com.caucho.util.L10N;

public class EmbeddedSchemaExpr
extends SchemaExpr {
    private static final L10N L = new L10N(EmbeddedSchemaExpr.class);
    private EmbeddedExpr _expr;
    private String _name;

    public EmbeddedSchemaExpr(EmbeddedExpr expr, String name) {
        this._expr = expr;
        this._name = name;
    }

    public String getTailName() {
        return this._name;
    }

    public EmbeddedExpr getExpr() {
        return this._expr;
    }

    public SchemaExpr createField(QueryParser parser, String name) throws QueryParseException {
        EmbeddableType type = this._expr.getTargetType();
        AmberField field = type.getField(name);
        if (field == null) {
            throw parser.error(L.l("{0}: '{1}' is an unknown field.", (Object)type.getBeanClass().getName(), name));
        }
        AmberExpr fieldExpr = this._expr.createField(parser, name);
        if (fieldExpr instanceof EmbeddedExpr) {
            return new EmbeddedSchemaExpr((EmbeddedExpr)fieldExpr, name);
        }
        throw parser.error(L.l("{0}: '{1}' must be a collection or one-to-one relationship.", (Object)type.getBeanClass().getName(), name));
    }

    public FromItem addFromItem(QueryParser parser, String id) throws QueryParseException {
        this._expr = (EmbeddedExpr)this._expr.bindSelect(parser, id);
        FromItem fromItem = this._expr.bindSubPath(parser);
        return fromItem;
    }

    public String toString() {
        return "EmbeddedSchemaExpr[" + this._name + "]";
    }
}

