/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.field;

import com.caucho.amber.expr.AmberExpr;
import com.caucho.amber.expr.PathExpr;
import com.caucho.amber.field.AmberField;
import com.caucho.amber.field.IdField;
import com.caucho.amber.manager.AmberConnection;
import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.table.AmberColumn;
import com.caucho.amber.table.AmberTable;
import com.caucho.amber.type.BeanType;
import com.caucho.amber.type.EntityType;
import com.caucho.bytecode.JType;
import com.caucho.bytecode.JTypeWrapper;
import com.caucho.config.ConfigException;
import com.caucho.java.JavaWriter;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractField
implements AmberField {
    private static final L10N L = new L10N(AbstractField.class);
    private static final Logger log = Logger.getLogger(AbstractField.class.getName());
    final BeanType _sourceType;
    private String _name;
    private JType _type;
    private Method _getterMethod;
    private Method _setterMethod;
    private boolean _isLazy = true;
    private boolean _isOverride;
    private int _updateIndex;
    private int _loadGroupIndex = -1;

    AbstractField(BeanType sourceType) {
        this._sourceType = sourceType;
    }

    AbstractField(BeanType sourceType, String name) throws ConfigException {
        this(sourceType);
        this.setName(name);
        if (log.isLoggable(Level.FINER)) {
            log.finer(this._sourceType + " field " + this);
        }
    }

    public void setName(String name) throws ConfigException {
        this._name = name;
        ClassLoader loader = this.getSourceType().getPersistenceUnit().getTempClassLoader();
        if (!this.isFieldAccess()) {
            char ch = name.charAt(0);
            if (Character.isLowerCase(ch)) {
                name = Character.toUpperCase(ch) + name.substring(1);
            }
            String getter = "get" + name;
            String setter = "set" + name;
            this._getterMethod = BeanType.getGetter(this.getBeanClass(), getter);
            if (this._getterMethod == null) {
                getter = "is" + name;
                this._getterMethod = BeanType.getGetter(this.getBeanClass(), getter);
            }
            if (this._getterMethod == null) {
                Field field = BeanType.getField(this.getBeanClass(), this._name);
                if (field == null) {
                    throw new ConfigException(L.l("{0}: {1} has no matching field.", (Object)this.getBeanClass().getName(), this._name));
                }
                this._type = JTypeWrapper.create(field.getGenericType(), loader);
            } else {
                this._type = JTypeWrapper.create(this._getterMethod.getGenericReturnType(), loader);
                this._setterMethod = BeanType.getSetter(this.getBeanClass(), setter);
            }
        } else {
            Field field = BeanType.getField(this.getBeanClass(), name);
            if (field == null) {
                throw new ConfigException(L.l("{0}: {1} has no matching field.", (Object)this.getBeanClass().getName(), name));
            }
            this._type = JTypeWrapper.create(field.getGenericType(), loader);
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    protected void setJavaType(JType type) {
        this._type = type;
    }

    @Override
    public BeanType getSourceType() {
        return this._sourceType;
    }

    public AmberPersistenceUnit getPersistenceUnit() {
        return this.getSourceType().getPersistenceUnit();
    }

    public Class getBeanClass() {
        return this.getSourceType().getBeanClass();
    }

    public EntityType getEntitySourceType() {
        return (EntityType)this.getSourceType();
    }

    @Override
    public AmberTable getTable() {
        return this.getEntitySourceType().getTable();
    }

    @Override
    public AmberColumn getColumn() {
        return null;
    }

    public void setColumn(AmberColumn column) {
    }

    @Override
    public int getIndex() {
        return this._updateIndex;
    }

    @Override
    public void setIndex(int index) {
        this._updateIndex = index;
    }

    @Override
    public int getLoadGroupIndex() {
        return this._loadGroupIndex;
    }

    protected void setLoadGroupIndex(int index) {
        this._loadGroupIndex = index;
    }

    @Override
    public long getCreateLoadMask(int group) {
        int index = this.getLoadGroupIndex();
        if (64 * group <= index && index < 64 * (group + 1)) {
            return 1L << index % 64;
        }
        return 0L;
    }

    @Override
    public boolean isLazy() {
        return this._isLazy;
    }

    public void setLazy(boolean isLazy) {
        this._isLazy = isLazy;
    }

    public boolean isOverride() {
        return this._isOverride;
    }

    public void setOverride(boolean isOverride) {
        this._isOverride = isOverride;
    }

    public boolean isKey() {
        return false;
    }

    @Override
    public String getJavaTypeName() {
        return this.getJavaTypeName(this.getJavaClass());
    }

    private String getJavaTypeName(Class cl) {
        if (cl.isArray()) {
            return this.getJavaTypeName(cl.getComponentType()) + "[]";
        }
        return cl.getName();
    }

    @Override
    public JType getJavaType() {
        return this._type;
    }

    @Override
    public Class getJavaClass() {
        return this.getJavaType().getRawType().getJavaClass();
    }

    public boolean isFieldAccess() {
        return this.getSourceType().isFieldAccess();
    }

    @Override
    public boolean isAbstract() {
        return this._getterMethod != null && Modifier.isAbstract(this._getterMethod.getModifiers());
    }

    @Override
    public boolean isCascadable() {
        return false;
    }

    @Override
    public boolean isUpdateable() {
        return true;
    }

    @Override
    public AmberField override(BeanType table) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void init() throws ConfigException {
        if (this._loadGroupIndex < 0) {
            this._loadGroupIndex = this._isLazy ? this.getEntitySourceType().nextLoadGroupIndex() : this.getEntitySourceType().getDefaultLoadGroupIndex();
        }
    }

    @Override
    public void generatePostConstructor(JavaWriter out) throws IOException {
    }

    @Override
    public void generatePrologue(JavaWriter out, HashSet<Object> completedSet) throws IOException {
        if (this.isAbstract()) {
            out.println();
            out.print("public ");
            out.print(this.getJavaTypeName());
            out.print(" " + this.getFieldName() + ";");
        }
    }

    @Override
    public Method getGetterMethod() {
        return this._getterMethod;
    }

    @Override
    public Method getSetterMethod() {
        return this._setterMethod;
    }

    @Override
    public String getGetterName() {
        if (this.isFieldAccess()) {
            return "__caucho_get_" + this.getName();
        }
        return this._getterMethod.getName();
    }

    @Override
    public String getSetterName() {
        if (this.isFieldAccess()) {
            return "__caucho_set_" + this.getName();
        }
        if (this._setterMethod != null) {
            return this._setterMethod.getName();
        }
        return "set" + this.getGetterName().substring(3);
    }

    @Override
    public String generateSuperGetter(String objThis) {
        if (!this.getSourceType().isEmbeddable()) {
            return objThis + ".__caucho_super_get_" + this.getName() + "()";
        }
        if (this.isFieldAccess()) {
            return objThis + "." + this.getName();
        }
        return objThis + "." + this.getGetterMethod().getName() + "()";
    }

    @Override
    public String generateSuperSetter(String objThis, String value) {
        if (!this.getSourceType().isEmbeddable()) {
            return objThis + "." + "__caucho_super_set_" + this.getName() + "(" + value + ")";
        }
        if (this.isFieldAccess()) {
            return objThis + "." + this.getName() + " = " + value;
        }
        return objThis + "." + this.getSetterMethod().getName() + "(" + value + ")";
    }

    @Override
    public String generateGet(String objThis) {
        if (objThis == null) {
            return this.generateNull();
        }
        if (objThis.equals("super")) {
            return this.generateSuperGetter("this");
        }
        return objThis + "." + this.getGetterName() + "()";
    }

    @Override
    public String generateSet(String objThis, String value) {
        if (objThis.equals("super")) {
            return this.generateSuperSetter("this", value);
        }
        return objThis + "." + this.getSetterName() + "(" + value + ")";
    }

    @Override
    public void generateGet(JavaWriter out, String objThis) throws IOException {
        out.print(this.generateGet(objThis));
    }

    @Override
    public void generateSet(JavaWriter out, String obj, String value) throws IOException {
        out.println(this.generateSet(obj, value) + ";");
    }

    @Override
    public void generateSuperGetterMethod(JavaWriter out) throws IOException {
        out.println();
        out.println("public final " + this.getJavaTypeName() + " __caucho_super_get_" + this.getName() + "()");
        out.println("{");
        out.pushDepth();
        if (this.isAbstract() || this.getGetterMethod() == null) {
            out.println("return " + this.getFieldName() + ";");
        } else if (this instanceof IdField) {
            out.println("return " + this.getGetterName() + "();");
        } else {
            out.println("return super." + this.getGetterName() + "();");
        }
        out.popDepth();
        out.println("}");
    }

    @Override
    public void generateSuperSetterMethod(JavaWriter out) throws IOException {
        out.println();
        out.println("public final void __caucho_super_set_" + this.getName() + "(" + this.getJavaTypeName() + " v)");
        out.println("{");
        out.pushDepth();
        if (this.isAbstract() || this.getGetterMethod() == null) {
            out.println(this.getFieldName() + " = v;");
        } else if (this.getSetterMethod() != null) {
            if (this instanceof IdField) {
                out.println(this.getSetterMethod().getName() + "(v);");
            } else {
                out.println("super." + this.getSetterMethod().getName() + "(v);");
            }
        }
        out.popDepth();
        out.println("}");
    }

    @Override
    public void generateGetterMethod(JavaWriter out) throws IOException {
    }

    @Override
    public void generateSetterMethod(JavaWriter out) throws IOException {
    }

    @Override
    public void generateDetach(JavaWriter out) throws IOException {
    }

    @Override
    public String generateLoadSelect(AmberTable table, String id) {
        return null;
    }

    @Override
    public String generateSelect(String id) {
        return null;
    }

    @Override
    public String generateJavaSelect(String id) {
        return null;
    }

    @Override
    public String generateWhere(String id) {
        return null;
    }

    @Override
    public void generateUpdate(CharBuffer sql) {
    }

    @Override
    public void generateUpdate(JavaWriter out, String maskVar, String pstmt, String index) throws IOException {
        int group = this.getIndex() / 64;
        long mask = 1L << this.getIndex() % 64;
        out.println();
        out.println("if ((" + maskVar + "_" + group + " & " + mask + "L) != 0) {");
        out.pushDepth();
        this.generateStatementSet(out, pstmt, index);
        out.popDepth();
        out.println("}");
    }

    @Override
    public boolean hasLoadGroup(int index) {
        return index == this._loadGroupIndex;
    }

    @Override
    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        return index;
    }

    @Override
    public int generatePostLoadSelect(JavaWriter out, int index) throws IOException {
        return index;
    }

    @Override
    public void generateLoadFromObject(JavaWriter out, String obj) throws IOException {
        if (this.getGetterMethod() == null || this.getSetterMethod() == null) {
            return;
        }
        String getter = this.getGetterName();
        String loadVar = "__caucho_loadMask_" + this.getLoadGroupIndex() / 64;
        long loadMask = 1L << this.getLoadGroupIndex();
        out.println("if ((" + loadVar + " & " + loadMask + "L) != 0)");
        out.print("  ");
        out.println("  " + this.generateSuperSetter("this", this.generateGet(obj)) + ";");
    }

    @Override
    public int generateLoadNative(JavaWriter out, int index) throws IOException {
        return index;
    }

    @Override
    public void generateNativeColumnNames(ArrayList<String> names) {
    }

    @Override
    public void generateUpdateFromObject(JavaWriter out, String obj) throws IOException {
        out.println(this.generateSuperSetter("this", this.generateGet(obj)) + ";");
    }

    public String generateNull() {
        return "null";
    }

    protected String getFieldName() {
        return this.getName();
    }

    public final String generateInsert() {
        return null;
    }

    @Override
    public void generateInsertColumns(ArrayList<String> columns) {
    }

    @Override
    public String generateCreateTableSQL(AmberPersistenceUnit manager) {
        return null;
    }

    @Override
    public void generateStatementSet(JavaWriter out, String pstmt, String index) throws IOException {
        this.generateStatementSet(out, pstmt, index, "super");
    }

    @Override
    public void generateInsertSet(JavaWriter out, String pstmt, String index, String obj) throws IOException {
        this.generateStatementSet(out, pstmt, index, obj);
    }

    @Override
    public void generateUpdateSet(JavaWriter out, String pstmt, String index, String obj) throws IOException {
        this.generateStatementSet(out, pstmt, index, obj);
    }

    @Override
    public void generatePrePersist(JavaWriter out) throws IOException {
    }

    @Override
    public void generateCopyUpdateObject(JavaWriter out, String dst, String src, int updateIndex) throws IOException {
        if (this.getIndex() == updateIndex) {
            String value = this.generateGet(src);
            out.println(this.generateSet(dst, value) + ";");
        }
    }

    @Override
    public void generateCopyLoadObject(JavaWriter out, String dst, String src, int loadIndex) throws IOException {
        if (this.getLoadGroupIndex() != loadIndex) {
            return;
        }
        String value = this.generateGet(src);
        boolean isJPA = this.getEntitySourceType().getPersistenceUnit().isJPA();
        if (isJPA && !dst.equals("cacheEntity") && !dst.equals("super") && !dst.equals("item")) {
            out.println("if (isFullMerge)");
            out.println("  " + this.generateSet(dst, value) + ";");
            out.println("else");
            out.print("  ");
        }
        if (!dst.equals("super")) {
            out.println(this.generateSuperSetter(dst, value) + ";");
        } else {
            out.println(this.generateSuperSetter("this", value) + ";");
        }
    }

    @Override
    public void generateMergeFrom(JavaWriter out, String dst, String src) throws IOException {
        String value = this.generateGet(src);
        out.println(this.generateSet(dst, value) + ";");
    }

    @Override
    public void generateDumpRelationships(JavaWriter out, int updateIndex) throws IOException {
    }

    @Override
    public void generateStatementSet(JavaWriter out, String pstmt, String index, String obj) throws IOException {
    }

    @Override
    public String toObject(String value) {
        return value;
    }

    @Override
    public void link() {
    }

    @Override
    public void generatePreDelete(JavaWriter out) throws IOException {
    }

    @Override
    public void generatePostDelete(JavaWriter out) throws IOException {
    }

    @Override
    public void generateExpire(JavaWriter out) throws IOException {
    }

    @Override
    public void generateInvalidateForeign(JavaWriter out) throws IOException {
    }

    @Override
    public void childDelete(AmberConnection aConn, Serializable primaryKey) throws SQLException {
    }

    @Override
    public String generateCastFromObject(String value) {
        return value;
    }

    @Override
    public String generateEquals(String leftBase, String value) {
        return leftBase + ".equals(" + value + ")";
    }

    @Override
    public AmberExpr createExpr(QueryParser parser, PathExpr parent) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "," + this.getSourceType() + "]";
    }
}

