/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.field;

import com.caucho.amber.expr.AmberExpr;
import com.caucho.amber.expr.DependentEntityOneToOneExpr;
import com.caucho.amber.expr.PathExpr;
import com.caucho.amber.field.CascadableField;
import com.caucho.amber.field.Id;
import com.caucho.amber.field.IdField;
import com.caucho.amber.field.ManyToOneField;
import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.table.AmberColumn;
import com.caucho.amber.table.AmberTable;
import com.caucho.amber.table.ForeignColumn;
import com.caucho.amber.table.LinkColumns;
import com.caucho.amber.type.AmberType;
import com.caucho.amber.type.EntityType;
import com.caucho.config.ConfigException;
import com.caucho.java.JavaWriter;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Logger;
import javax.persistence.CascadeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependentEntityOneToOneField
extends CascadableField {
    private static final L10N L = new L10N(DependentEntityOneToOneField.class);
    private static final Logger log = Logger.getLogger(DependentEntityOneToOneField.class.getName());
    private ManyToOneField _targetField;
    private long _targetLoadIndex;
    private boolean _isCascadeDelete;

    public DependentEntityOneToOneField(EntityType relatedType, String name) throws ConfigException {
        super(relatedType, name, null);
    }

    public DependentEntityOneToOneField(EntityType relatedType, String name, CascadeType[] cascadeTypes) throws ConfigException {
        super(relatedType, name, cascadeTypes);
    }

    public void setTargetField(ManyToOneField targetField) {
        this._targetField = targetField;
    }

    public ManyToOneField getTargetField() {
        return this._targetField;
    }

    public long getTargetLoadIndex() {
        return this._targetLoadIndex;
    }

    @Override
    public EntityType getEntitySourceType() {
        return (EntityType)this.getSourceType();
    }

    public EntityType getEntityTargetType() {
        return (EntityType)this._targetField.getSourceType();
    }

    public AmberType getType() {
        return this.getEntityTargetType();
    }

    public String getForeignTypeName() {
        return this.getEntityTargetType().getForeignTypeName();
    }

    @Override
    public void setColumn(AmberColumn column) {
        throw new IllegalStateException();
    }

    public void setCascadeDelete(boolean isCascadeDelete) {
        this._isCascadeDelete = isCascadeDelete;
    }

    public boolean isCascadeDelete() {
        return this._isCascadeDelete;
    }

    @Override
    public void init() throws ConfigException {
        super.init();
        this._targetLoadIndex = this.getEntitySourceType().nextLoadGroupIndex();
    }

    @Override
    public AmberExpr createExpr(QueryParser parser, PathExpr parent) {
        return new DependentEntityOneToOneExpr(parent, this._targetField.getLinkColumns());
    }

    public ForeignColumn getColumn(IdField targetField) {
        return null;
    }

    @Override
    public void generatePrologue(JavaWriter out, HashSet<Object> completedSet) throws IOException {
        super.generatePrologue(out, completedSet);
        out.println();
        Id id = this.getEntityTargetType().getId();
        id.generatePrologue(out, completedSet, this.getName());
    }

    public void generateJoin(CharBuffer cb, String sourceTable, String targetTable) {
        LinkColumns linkColumns = this._targetField.getLinkColumns();
        cb.append(linkColumns.generateJoin(sourceTable, targetTable));
    }

    @Override
    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        if (this.isLazy()) {
            out.println(this.generateSuperSetter("this", "null") + ";");
            String loadVar = "__caucho_loadMask_" + this._targetLoadIndex / 64L;
            long loadMask = 1L << (int)this._targetLoadIndex;
            out.println(loadVar + " &= ~" + loadMask + "L;");
        }
        return index;
    }

    @Override
    public int generatePostLoadSelect(JavaWriter out, int index) throws IOException {
        if (!this.isLazy()) {
            out.println(this.getGetterName() + "();");
        }
        return ++index;
    }

    @Override
    public void generateGetterMethod(JavaWriter out) throws IOException {
        String loadVar = "__caucho_loadMask_" + this._targetLoadIndex / 64L;
        long loadMask = 1L << (int)(this._targetLoadIndex % 64L);
        String index = "_" + this._targetLoadIndex / 64L;
        index = index + "_" + (1L << (int)(this._targetLoadIndex % 64L));
        String javaType = this.getJavaTypeName();
        out.println();
        out.println("public " + javaType + " " + this.getGetterName() + "()");
        out.println("{");
        out.pushDepth();
        out.println("if (__caucho_session != null");
        out.println("    && ! __caucho_state.isDeleting()");
        out.println("    && (" + loadVar + " & " + loadMask + "L) == 0) {");
        out.pushDepth();
        out.println("__caucho_load_select_" + this.getLoadGroupIndex() + "(__caucho_session);");
        out.println(loadVar + " |= " + loadMask + "L;");
        this.generateLoadProperty(out, index, "__caucho_session");
        out.println("return v" + index + ";");
        out.popDepth();
        out.println("}");
        out.println("else {");
        out.println("  return " + this.generateSuperGetter("this") + ";");
        out.println("}");
        out.popDepth();
        out.println("}");
    }

    public void generateLoadProperty(JavaWriter out, String index, String session) throws IOException {
        String javaType = this.getJavaTypeName();
        out.println(javaType + " v" + index + " = null;");
        out.println("try {");
        out.pushDepth();
        out.print("String sql" + index + " = \"");
        out.print("SELECT o." + this.getName() + " FROM " + this.getEntitySourceType().getName() + " o" + " WHERE ");
        ArrayList<IdField> sourceKeys = this.getEntitySourceType().getId().getKeys();
        for (int i = 0; i < sourceKeys.size(); ++i) {
            if (i != 0) {
                out.print(" and ");
            }
            IdField key = sourceKeys.get(i);
            out.print("o." + key.getName() + "=?");
        }
        out.println("\";");
        out.println("com.caucho.amber.AmberQuery query" + index + " = " + session + ".prepareQuery(sql" + index + ");");
        out.println("int index" + index + " = 1;");
        this.getEntitySourceType().getId().generateSet(out, "query" + index, "index" + index, "super");
        boolean isJPA = this.getEntitySourceType().getPersistenceUnit().isJPA();
        if (isJPA) {
            out.println("v" + index + " = (" + javaType + ") query" + index + ".getSingleResult();");
        } else {
            out.println("com.caucho.amber.entity.Entity e = (com.caucho.amber.entity.Entity) query" + index + ".getSingleResult();");
            out.println("v" + index + " = (" + javaType + ") __caucho_session.loadProxy(e.__caucho_getEntityType(), e.__caucho_getPrimaryKey());");
        }
        out.popDepth();
        out.println("} catch (java.sql.SQLException e) {");
        out.println("  throw new RuntimeException(e);");
        out.println("}");
        out.println(this.generateSuperSetter("this", "v" + index) + ";");
    }

    @Override
    public void generateCopyUpdateObject(JavaWriter out, String dst, String src, int updateIndex) throws IOException {
    }

    @Override
    public void generateMergeFrom(JavaWriter out, String dst, String src) throws IOException {
        if (!(this.getEntityTargetType() instanceof EntityType)) {
            return;
        }
        String value = this.generateGet(src);
        out.println("if (" + value + " != null) {");
        out.pushDepth();
        value = !this.isCascade(CascadeType.MERGE) ? "(" + this.getJavaTypeName() + ") aConn.mergeDetachedEntity((com.caucho.amber.entity.Entity) " + value + ")" : "(" + this.getJavaTypeName() + ") aConn.recursiveMerge(" + value + ")";
        out.println(this.generateSet(dst, value) + ";");
        out.popDepth();
        out.println("}");
    }

    @Override
    public void generateSetterMethod(JavaWriter out) throws IOException {
        Id id = this.getEntityTargetType().getId();
        String keyType = this.getEntityTargetType().getId().getForeignTypeName();
        out.println();
        out.println("public void " + this.getSetterName() + "(" + this.getJavaTypeName() + " v)");
        out.println("{");
        out.pushDepth();
        out.println(this.generateSuperSetter("this", "v") + ";");
        out.println("if (__caucho_session != null) {");
        out.pushDepth();
        out.println("try {");
        out.pushDepth();
        out.println("if (__caucho_state.isPersist())");
        out.println("  __caucho_cascadePrePersist(__caucho_session);");
        out.popDepth();
        out.println("} catch (RuntimeException e) {");
        out.println("  throw e;");
        out.println("} catch (Exception e) {");
        out.println("  throw new com.caucho.amber.AmberRuntimeException(e);");
        out.println("}");
        String loadVar = "__caucho_loadMask_" + this._targetLoadIndex / 64L;
        long loadMask = 1L << (int)(this._targetLoadIndex % 64L);
        out.println(loadVar + " |= " + loadMask + "L;");
        out.popDepth();
        out.println("}");
        out.popDepth();
        out.println("}");
    }

    @Override
    public void generateStatementSet(JavaWriter out, String pstmt, String index) throws IOException {
    }

    @Override
    public void generateUpdateFromObject(JavaWriter out, String obj) throws IOException {
    }

    @Override
    public void generateInvalidateForeign(JavaWriter out) throws IOException {
        AmberTable table;
        AmberPersistenceUnit persistenceUnit = this.getSourceType().getPersistenceUnit();
        if (persistenceUnit.isJPA()) {
            String className = this.getJavaType().getName();
            EntityType entity = persistenceUnit.getEntityType(className);
            table = entity.getTable();
        } else {
            table = this.getEntityTargetType().getTable();
        }
        out.println("if (\"" + table.getName() + "\".equals(table)) {");
        out.pushDepth();
        String loadVar = "__caucho_loadMask_" + this._targetLoadIndex / 64L;
        out.println(loadVar + " = 0;");
        out.popDepth();
        out.println("}");
    }

    @Override
    public void generatePreCascade(JavaWriter out, String aConn, CascadeType cascadeType) throws IOException {
        if (cascadeType == CascadeType.PERSIST) {
            return;
        }
        this.generateInternalCascade(out, aConn, cascadeType);
    }

    @Override
    public void generatePostCascade(JavaWriter out, String aConn, CascadeType cascadeType) throws IOException {
        if (cascadeType != CascadeType.PERSIST) {
            return;
        }
        this.generateInternalCascade(out, aConn, cascadeType);
    }
}

