/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.field;

import com.caucho.amber.expr.AmberExpr;
import com.caucho.amber.expr.PathExpr;
import com.caucho.amber.field.AmberField;
import com.caucho.amber.field.EntityEmbeddedField;
import com.caucho.amber.field.PropertyField;
import com.caucho.amber.manager.AmberConnection;
import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.table.AmberColumn;
import com.caucho.amber.table.AmberTable;
import com.caucho.amber.type.BeanType;
import com.caucho.bytecode.JType;
import com.caucho.config.ConfigException;
import com.caucho.java.JavaWriter;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedSubField
implements AmberField {
    private static final L10N L = new L10N(EmbeddedSubField.class);
    protected static final Logger log = Logger.getLogger(EmbeddedSubField.class.getName());
    private EntityEmbeddedField _embeddedField;
    private AmberField _embeddableField;
    private AmberColumn _column;
    private boolean _isInsert;
    private boolean _isUpdate;
    private int _index;

    public EmbeddedSubField(EntityEmbeddedField embeddedField, AmberField embeddableField, int index) throws ConfigException {
        this._embeddedField = embeddedField;
        this._embeddableField = embeddableField;
        this._index = index;
        if (!(embeddableField instanceof PropertyField)) {
            throw new IllegalStateException(L.l("'{0}' is an unknown field type of @Embeddable bean.", embeddableField.getClass().getName()));
        }
        AmberColumn embeddableColumn = ((PropertyField)embeddableField).getColumn();
        if (embeddableColumn == null) {
            throw new IllegalStateException(embeddableField + " column is null");
        }
        this._column = new AmberColumn(this._embeddedField.getTable(), embeddableColumn.getName(), embeddableColumn.getType());
    }

    @Override
    public BeanType getSourceType() {
        return this._embeddedField.getSourceType();
    }

    @Override
    public boolean isLazy() {
        return this._embeddedField.isLazy();
    }

    @Override
    public String getName() {
        return this._embeddableField.getName();
    }

    @Override
    public AmberTable getTable() {
        return this.getColumn().getTable();
    }

    @Override
    public AmberColumn getColumn() {
        return this._column;
    }

    @Override
    public int getIndex() {
        return this._embeddedField.getIndex();
    }

    @Override
    public int getLoadGroupIndex() {
        return this._embeddedField.getLoadGroupIndex();
    }

    @Override
    public long getCreateLoadMask(int group) {
        return this._embeddedField.getCreateLoadMask(group);
    }

    @Override
    public JType getJavaType() {
        return this._embeddableField.getJavaType();
    }

    @Override
    public Class getJavaClass() {
        return this.getJavaType().getRawType().getJavaClass();
    }

    @Override
    public String getJavaTypeName() {
        return this._embeddableField.getJavaTypeName();
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public boolean isCascadable() {
        return false;
    }

    @Override
    public boolean isUpdateable() {
        return true;
    }

    @Override
    public void setIndex(int index) {
    }

    @Override
    public Method getGetterMethod() {
        return this._embeddedField.getGetterMethod();
    }

    @Override
    public String getGetterName() {
        return this._embeddedField.getGetterName();
    }

    @Override
    public Method getSetterMethod() {
        return this._embeddedField.getSetterMethod();
    }

    @Override
    public String getSetterName() {
        return this._embeddedField.getSetterName();
    }

    @Override
    public String generateSuperGetter(String objThis) {
        if (!this.getSourceType().isEmbeddable()) {
            return "__caucho_super_get_" + this.getName() + "()";
        }
        if (this.getSourceType().isFieldAccess()) {
            return "__caucho_super_get_" + this.getName() + "()";
        }
        return this.getGetterMethod().getName() + "()";
    }

    @Override
    public String generateSuperSetter(String objThis, String value) {
        if (this.getSourceType().isFieldAccess()) {
            return objThis + "." + this.getName() + " = " + value;
        }
        return objThis + "." + this.getSetterName() + "(" + value + ")";
    }

    @Override
    public void generateSet(JavaWriter out, String objThis, String value) throws IOException {
        this._embeddedField.generateSet(out, objThis, value);
    }

    @Override
    public void init() throws ConfigException {
    }

    @Override
    public void generatePrologue(JavaWriter out, HashSet<Object> completedSet) throws IOException {
    }

    @Override
    public void generatePostConstructor(JavaWriter out) throws IOException {
    }

    @Override
    public void generateUpdate(JavaWriter out, String mask, String pstmt, String index) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasLoadGroup(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int generateLoad(JavaWriter out, String rs, String indexVar, int loadGroupIndex) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int generatePostLoadSelect(JavaWriter out, int index) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int generateLoadNative(JavaWriter out, int index) throws IOException {
        return index;
    }

    @Override
    public void generateNativeColumnNames(ArrayList<String> names) {
    }

    @Override
    public void generateLoadFromObject(JavaWriter out, String obj) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void generateUpdateFromObject(JavaWriter out, String obj) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void generateGet(JavaWriter out, String value) throws IOException {
        out.print(this.generateGet(value));
    }

    @Override
    public String generateGet(String objThis) {
        String fieldType = this.getColumn().getType().getForeignType().getJavaTypeName();
        return "((" + fieldType + ") " + "((Embeddable) " + this._embeddedField.generateGet(objThis) + ").__caucho_get_field(" + this._index + "))";
    }

    @Override
    public String generateSet(String obj, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void generateGetterMethod(JavaWriter out) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void generateSetterMethod(JavaWriter out) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void generateSuperGetterMethod(JavaWriter out) throws IOException {
    }

    @Override
    public void generateSuperSetterMethod(JavaWriter out) throws IOException {
    }

    @Override
    public AmberField override(BeanType entityType) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public String generateCreateTableSQL(AmberPersistenceUnit manager) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void generateStatementSet(JavaWriter out, String pstmt, String index) throws IOException {
        this.getColumn().generateSet(out, pstmt, index, this.generateGet("this"));
    }

    @Override
    public void generateInsertSet(JavaWriter out, String pstmt, String index, String obj) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void generateUpdateSet(JavaWriter out, String pstmt, String index, String obj) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void generateCopyUpdateObject(JavaWriter out, String dst, String src, int updateIndex) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void generateCopyLoadObject(JavaWriter out, String dst, String src, int loadIndex) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void generateMergeFrom(JavaWriter out, String dst, String src) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void generateDumpRelationships(JavaWriter out, int updateIndex) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void generateStatementSet(JavaWriter out, String pstmt, String index, String obj) throws IOException {
        this.getColumn().generateSet(out, pstmt, index, this.generateGet(obj));
    }

    @Override
    public String toObject(String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void link() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void generatePreDelete(JavaWriter out) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void generatePostDelete(JavaWriter out) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void generateExpire(JavaWriter out) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void generateInvalidateForeign(JavaWriter out) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void childDelete(AmberConnection aConn, Serializable primaryKey) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String generateCastFromObject(String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String generateEquals(String leftBase, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String generateLoadSelect(AmberTable table, String id) {
        if (this.getColumn().getTable() == table) {
            return this.generateSelect(id);
        }
        return null;
    }

    @Override
    public String generateSelect(String id) {
        return this.getColumn().generateSelect(id);
    }

    @Override
    public void generateInsertColumns(ArrayList<String> columns) {
        if (this._isInsert) {
            columns.add(this.getColumn().getName());
        }
    }

    @Override
    public String generateJavaSelect(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String generateWhere(String id) {
        return this.getColumn().generateSelect(id);
    }

    @Override
    public void generateUpdate(CharBuffer sql) {
        if (this._isUpdate) {
            sql.append(this.getColumn().generateUpdateSet());
        }
    }

    @Override
    public void generatePrePersist(JavaWriter out) throws IOException {
    }

    @Override
    public void generateDetach(JavaWriter out) throws IOException {
    }

    @Override
    public AmberExpr createExpr(QueryParser parser, PathExpr parent) {
        throw new UnsupportedOperationException();
    }
}

