/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.gen;

import com.caucho.amber.field.AmberField;
import com.caucho.amber.gen.AmberGenerator;
import com.caucho.amber.gen.AmberMappedComponent;
import com.caucho.amber.gen.EmbeddableComponent;
import com.caucho.amber.gen.EntityGenerator;
import com.caucho.amber.gen.ListenerComponent;
import com.caucho.amber.manager.AmberContainer;
import com.caucho.amber.type.AbstractEnhancedType;
import com.caucho.amber.type.BeanType;
import com.caucho.amber.type.EmbeddableType;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.ListenerType;
import com.caucho.bytecode.Analyzer;
import com.caucho.bytecode.CodeVisitor;
import com.caucho.bytecode.ConstantPool;
import com.caucho.bytecode.FieldRefConstant;
import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JavaClass;
import com.caucho.bytecode.JavaMethod;
import com.caucho.bytecode.MethodRefConstant;
import com.caucho.config.ConfigException;
import com.caucho.java.JavaCompiler;
import com.caucho.java.WorkDir;
import com.caucho.java.gen.ClassComponent;
import com.caucho.java.gen.DependencyComponent;
import com.caucho.java.gen.GenClass;
import com.caucho.java.gen.JavaClassGenerator;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.SimpleLoader;
import com.caucho.loader.enhancer.ClassEnhancer;
import com.caucho.loader.enhancer.EnhancerPrepare;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AmberEnhancer
implements AmberGenerator,
ClassEnhancer {
    private static final L10N L = new L10N(AmberEnhancer.class);
    private static final Logger log = Logger.getLogger(AmberEnhancer.class.getName());
    private Path _configDirectory;
    private boolean _useHibernateFiles;
    private AmberContainer _amberContainer;
    private EnhancerPrepare _prepare;
    private Path _workDir;
    private Path _postWorkDir;
    private ArrayList<String> _pendingClassNames = new ArrayList();

    public AmberEnhancer(AmberContainer amberContainer) {
        this._amberContainer = amberContainer;
        this._workDir = WorkDir.getLocalWorkDir().lookup("pre-enhance");
        this._postWorkDir = WorkDir.getLocalWorkDir().lookup("post-enhance");
        this._prepare = new EnhancerPrepare();
        this._prepare.setClassLoader(Thread.currentThread().getContextClassLoader());
        this._prepare.setWorkPath(WorkDir.getLocalWorkDir());
        this._prepare.addEnhancer(this);
    }

    public void setConfigDirectory(Path dir) {
        this._configDirectory = dir;
    }

    public Path getWorkDir() {
        return this._workDir;
    }

    public Path getPostWorkDir() {
        return this._postWorkDir;
    }

    public void init() throws Exception {
    }

    protected boolean isModified(Class preloadedClass) {
        try {
            Method init = preloadedClass.getMethod("_caucho_init", Path.class);
            if (this._configDirectory != null) {
                init.invoke(null, this._configDirectory);
            } else {
                init.invoke(null, Vfs.lookup());
            }
            Method isModified = preloadedClass.getMethod("_caucho_is_modified", new Class[0]);
            Object value = isModified.invoke(null, new Object[0]);
            if (Boolean.FALSE.equals(value)) {
                this.loadEntityType(preloadedClass, preloadedClass.getClassLoader());
                return false;
            }
            return true;
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
            return true;
        }
    }

    public boolean shouldEnhance(String className) {
        AbstractEnhancedType type;
        int p = (className = className.replace('/', '.')).lastIndexOf(45);
        if (p > 0) {
            className = className.substring(0, p);
        }
        if ((p = className.lastIndexOf(36)) > 0) {
            className = className.substring(0, p);
        }
        if ((type = this._amberContainer.getEntity(className)) != null && type.isEnhanced()) {
            return true;
        }
        type = this._amberContainer.getMappedSuperclass(className);
        if (type != null && type.isEnhanced()) {
            return true;
        }
        type = this._amberContainer.getEmbeddable(className);
        if (type != null && type.isEnhanced()) {
            return true;
        }
        type = this._amberContainer.getListener(className);
        return type != null && type.isEnhanced();
    }

    private EntityType loadEntityType(Class cl, ClassLoader loader) {
        EntityType parentType = null;
        while (cl != null) {
            String className = cl.getName();
            EntityType type = this._amberContainer.getEntity(className);
            if (parentType == null) {
                parentType = type;
            }
            if (type != null && !type.startConfigure()) {
                return type;
            }
            type = this.loadEntityTypeImpl(cl, loader);
            if (type != null && !type.startConfigure()) {
                return type;
            }
            cl = cl.getSuperclass();
        }
        return parentType;
    }

    protected EntityType loadEntityTypeImpl(Class cl, ClassLoader rawLoader) {
        return null;
    }

    public void preEnhance(JavaClass baseClass) throws Exception {
        EntityType type = this._amberContainer.getEntity(baseClass.getName());
        if (type == null) {
            type = this._amberContainer.getMappedSuperclass(baseClass.getName());
        }
        if (type != null && type.getParentType() != null) {
            String parentClass = type.getParentType().getInstanceClassName();
            baseClass.setSuperClass(parentClass.replace('.', '/'));
        }
    }

    public void enhance(GenClass genClass, JClass baseClass, String extClassName) throws Exception {
        EmbeddableType embeddableType;
        String className = baseClass.getName();
        EntityType type = this._amberContainer.getEntity(className);
        if (type == null) {
            type = this._amberContainer.getMappedSuperclass(className);
        }
        if (type != null) {
            log.info("Amber enhancing class " + className);
            type.init();
            genClass.addInterfaceName(type.getComponentInterfaceName());
            genClass.addImport("java.util.logging.*");
            genClass.addImport("com.caucho.amber.manager.*");
            genClass.addImport("com.caucho.amber.entity.*");
            genClass.addImport("com.caucho.amber.type.*");
            AmberMappedComponent componentGenerator = (AmberMappedComponent)type.getComponentGenerator();
            componentGenerator.setRelatedType(type);
            componentGenerator.setBaseClassName(baseClass.getName());
            componentGenerator.setExtClassName(extClassName);
            genClass.addComponent(componentGenerator);
            DependencyComponent dependency = genClass.addDependencyComponent();
            dependency.addDependencyList(type.getDependencies());
            return;
        }
        ListenerType listenerType = this._amberContainer.getListener(className);
        if (listenerType != null) {
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, "Amber enhancing class " + className);
            }
            listenerType.init();
            genClass.addInterfaceName("com.caucho.amber.entity.Listener");
            ListenerComponent listener = new ListenerComponent();
            listener.setListenerType(listenerType);
            listener.setBaseClassName(baseClass.getName());
            listener.setExtClassName(extClassName);
            genClass.addComponent(listener);
        }
        if ((embeddableType = this._amberContainer.getEmbeddable(className)) != null) {
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, "Amber enhancing class " + className);
            }
            embeddableType.init();
            genClass.addInterfaceName("com.caucho.amber.entity.Embeddable");
            EmbeddableComponent embeddable = new EmbeddableComponent();
            embeddable.setEmbeddableType(embeddableType);
            embeddable.setBaseClassName(baseClass.getName());
            embeddable.setExtClassName(extClassName);
            genClass.addComponent(embeddable);
        }
    }

    public void generate(AbstractEnhancedType type) throws Exception {
        String className = type.getBeanClass().getName();
        if (!this.isModified(className)) {
            return;
        }
        JavaClassGenerator javaGen = new JavaClassGenerator();
        javaGen.setWorkDir(this.getWorkDir());
        String extClassName = type.getBeanClass().getName() + "__ResinExt";
        type.setInstanceClassName(extClassName);
        type.setEnhanced(true);
        this._pendingClassNames.add(type.getInstanceClassName());
        this.generateJava(javaGen, type);
    }

    public void generateJava(JavaClassGenerator javaGen, AbstractEnhancedType type) throws Exception {
        if (type.isGenerated()) {
            return;
        }
        type.setGenerated(true);
        this._prepare.renameClass(type.getBeanClass().getName(), type.getBeanClass().getName());
        GenClass javaClass = new GenClass(type.getInstanceClassName());
        javaClass.setSuperClassName(type.getBeanClass().getName());
        javaClass.addImport("java.util.logging.*");
        javaClass.addImport("com.caucho.amber.manager.*");
        javaClass.addImport("com.caucho.amber.entity.*");
        javaClass.addImport("com.caucho.amber.type.*");
        ClassComponent componentGenerator = type.getComponentGenerator();
        if (componentGenerator instanceof AmberMappedComponent) {
            AmberMappedComponent entityGenerator = (AmberMappedComponent)componentGenerator;
            javaClass.addInterfaceName(type.getComponentInterfaceName());
            type.setEnhanced(true);
            entityGenerator.setRelatedType((EntityType)type);
            entityGenerator.setBaseClassName(type.getBeanClass().getName());
            entityGenerator.setExtClassName(type.getInstanceClassName());
            javaClass.addComponent(componentGenerator);
        } else if (type instanceof ListenerType) {
            javaClass.addInterfaceName("com.caucho.amber.entity.Listener");
            type.setEnhanced(true);
            ListenerComponent listener = new ListenerComponent();
            listener.setListenerType((ListenerType)type);
            listener.setBaseClassName(type.getBeanClass().getName());
            listener.setExtClassName(type.getInstanceClassName());
            javaClass.addComponent(listener);
        } else if (componentGenerator instanceof EmbeddableComponent) {
            EmbeddableComponent embeddable = (EmbeddableComponent)componentGenerator;
            javaClass.addInterfaceName("com.caucho.amber.entity.Embeddable");
            type.setEnhanced(true);
            embeddable.setEmbeddableType((EmbeddableType)type);
            embeddable.setBaseClassName(type.getBeanClass().getName());
            embeddable.setExtClassName(type.getInstanceClassName());
            javaClass.addComponent(embeddable);
        }
        javaGen.generate(javaClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isModified(String className) {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            ClassLoader loader = this._amberContainer.getParentClassLoader();
            ClassLoader tempLoader = ((DynamicClassLoader)loader).getNewTempClassLoader();
            DynamicClassLoader workLoader = SimpleLoader.create(tempLoader, this.getPostWorkDir());
            workLoader.setServletHack(true);
            Class<?> cl = Class.forName(className.replace('/', '.'), false, workLoader);
            thread.setContextClassLoader(tempLoader);
            Method init = cl.getMethod("_caucho_init", Path.class);
            Method modified = cl.getMethod("_caucho_is_modified", new Class[0]);
            init.invoke(null, Vfs.lookup());
            boolean bl = (Boolean)modified.invoke(null, new Object[0]);
            return bl;
        }
        catch (ClassNotFoundException e) {
            log.log(Level.FINEST, e.toString(), e);
        }
        catch (NoSuchMethodException e) {
            log.log(Level.FINEST, e.toString(), e);
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
        return true;
    }

    public void compile() throws Exception {
        if (this._pendingClassNames.size() == 0) {
            return;
        }
        ArrayList<String> classNames = new ArrayList<String>(this._pendingClassNames);
        this._pendingClassNames.clear();
        String[] javaFiles = new String[classNames.size()];
        for (int i = 0; i < classNames.size(); ++i) {
            String javaName;
            String className = classNames.get(i);
            javaFiles[i] = javaName = className.replace('.', '/') + ".java";
        }
        EntityGenerator gen = new EntityGenerator();
        gen.setSearchPath(this._configDirectory);
        JavaCompiler compiler = gen.getCompiler();
        compiler.setClassDir(this.getWorkDir());
        compiler.compileBatch(javaFiles);
        for (int i = 0; i < classNames.size(); ++i) {
            String extClassName = classNames.get(i);
            int tail = extClassName.length() - "__ResinExt".length();
            String baseClassName = extClassName.substring(0, tail);
        }
    }

    public void postEnhance(JavaClass baseClass) throws Exception {
        String className = baseClass.getThisClass();
        ArrayList<FieldMap> fieldMaps = new ArrayList<FieldMap>();
        Class thisClass = this._amberContainer.loadTempClass(className.replace('/', '.'));
        if (thisClass == null) {
            return;
        }
        Class entityClass = thisClass;
        do {
            BeanType type;
            if ((type = this._amberContainer.getEntity(thisClass.getName())) == null) {
                type = this._amberContainer.getMappedSuperclass(thisClass.getName());
            }
            if (type == null) {
                type = this._amberContainer.getEmbeddable(thisClass.getName());
            }
            if (type == null || !type.isFieldAccess() || type instanceof EmbeddableType) continue;
            if (type instanceof EntityType) {
                BeanType entityType = type;
            }
            for (AmberField field : type.getFields()) {
                fieldMaps.add(new FieldMap(baseClass, field.getName()));
            }
        } while ((thisClass = thisClass.getSuperclass()) != null);
        if (fieldMaps.size() > 0) {
            FieldFixupAnalyzer analyzer = new FieldFixupAnalyzer(fieldMaps);
            for (JavaMethod javaMethod : baseClass.getMethodList()) {
                if (javaMethod.getName().startsWith("__caucho_get_") || javaMethod.getName().startsWith("__caucho_set_") || javaMethod.getName().startsWith("__caucho_super_")) continue;
                CodeVisitor visitor = new CodeVisitor(baseClass, javaMethod.getCode());
                visitor.analyze(analyzer, true);
            }
        }
    }

    public void configure(AbstractEnhancedType type) throws ConfigException, IOException {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._configDirectory + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FieldFixupAnalyzer
    extends Analyzer {
        private ArrayList<FieldMap> _fieldMap;

        FieldFixupAnalyzer(ArrayList<FieldMap> fieldMap) {
            this._fieldMap = fieldMap;
        }

        int getGetter(int fieldRef) {
            for (int i = this._fieldMap.size() - 1; i >= 0; --i) {
                FieldMap fieldMap = this._fieldMap.get(i);
                if (fieldMap.getFieldRef() != fieldRef) continue;
                return fieldMap.getGetterRef();
            }
            return -1;
        }

        @Override
        public void analyze(CodeVisitor visitor) {
            switch (visitor.getOpcode()) {
                case 180: {
                    int getter = this.getGetter(visitor.getShortArg());
                    if (getter <= 0) break;
                    visitor.setByteArg(0, 182);
                    visitor.setShortArg(1, getter);
                    break;
                }
                case 181: {
                    int setter = this.getSetter(visitor.getShortArg());
                    if (setter <= 0) break;
                    visitor.setByteArg(0, 182);
                    visitor.setShortArg(1, setter);
                }
            }
        }

        int getSetter(int fieldRef) {
            for (int i = this._fieldMap.size() - 1; i >= 0; --i) {
                FieldMap fieldMap = this._fieldMap.get(i);
                if (fieldMap.getFieldRef() != fieldRef) continue;
                return fieldMap.getSetterRef();
            }
            return -1;
        }
    }

    static class FieldMap {
        private int _fieldRef = -1;
        private int _getterRef;
        private int _setterRef;

        FieldMap(JavaClass baseClass, String fieldName) {
            ConstantPool pool = baseClass.getConstantPool();
            FieldRefConstant fieldRef = pool.getFieldRef(fieldName);
            if (fieldRef == null) {
                return;
            }
            this._fieldRef = fieldRef.getIndex();
            String getterName = "__caucho_get_" + fieldName;
            MethodRefConstant methodRef = pool.addMethodRef(baseClass.getThisClass(), getterName, "()" + fieldRef.getType());
            this._getterRef = methodRef.getIndex();
            String setterName = "__caucho_set_" + fieldName;
            methodRef = pool.addMethodRef(baseClass.getThisClass(), setterName, "(" + fieldRef.getType() + ")V");
            this._setterRef = methodRef.getIndex();
        }

        int getFieldRef() {
            return this._fieldRef;
        }

        int getGetterRef() {
            return this._getterRef;
        }

        int getSetterRef() {
            return this._setterRef;
        }
    }
}

