/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.manager;

import com.caucho.amber.AmberRuntimeException;
import com.caucho.amber.cfg.EntityMappingsConfig;
import com.caucho.amber.cfg.MappedSuperclassConfig;
import com.caucho.amber.gen.AmberEnhancer;
import com.caucho.amber.gen.AmberGenerator;
import com.caucho.amber.manager.AmberEntityManagerFactory;
import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.manager.EntityManagerExtendedProxy;
import com.caucho.amber.manager.EntityManagerProxy;
import com.caucho.amber.manager.RootContext;
import com.caucho.amber.type.EmbeddableType;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.ListenerType;
import com.caucho.amber.type.MappedSuperclassType;
import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.program.ConfigProgram;
import com.caucho.env.jpa.ConfigPersistenceUnit;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentListener;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.loader.enhancer.EnhancerManager;
import com.caucho.loader.enhancer.ScanClass;
import com.caucho.loader.enhancer.ScanClassAllow;
import com.caucho.loader.enhancer.ScanListener;
import com.caucho.util.CharBuffer;
import com.caucho.util.IoUtil;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.MappedSuperclass;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmberContainer
implements ScanListener,
EnvironmentListener {
    private static final L10N L = new L10N(AmberContainer.class);
    private static final Logger log = Logger.getLogger(AmberContainer.class.getName());
    private static final EnvironmentLocal<AmberContainer> _localContainer = new EnvironmentLocal();
    private EnvironmentClassLoader _parentLoader;
    private ClassLoader _tempLoader;
    private AmberContainer _parentAmberContainer;
    private AmberEnhancer _enhancer;
    private DataSource _dataSource;
    private DataSource _readDataSource;
    private DataSource _xaDataSource;
    private boolean _createDatabaseTables;
    private ArrayList<ConfigProgram> _unitDefaultList = new ArrayList();
    private HashMap<String, ArrayList<ConfigProgram>> _unitDefaultMap = new HashMap();
    private ArrayList<ConfigPersistenceUnit> _unitConfigList = new ArrayList();
    private HashMap<String, AmberPersistenceUnit> _unitMap = new HashMap();
    private HashMap<String, EntityManagerFactory> _factoryMap = new HashMap();
    private HashMap<String, EntityManager> _persistenceContextMap = new HashMap();
    private HashMap<String, EmbeddableType> _embeddableMap = new HashMap();
    private HashMap<String, EntityType> _entityMap = new HashMap();
    private HashMap<String, MappedSuperclassType> _mappedSuperclassMap = new HashMap();
    private HashMap<String, ListenerType> _defaultListenerMap = new HashMap();
    private HashMap<String, ArrayList<ListenerType>> _entityListenerMap = new HashMap();
    private Throwable _exception;
    private HashMap<String, Throwable> _embeddableExceptionMap = new HashMap();
    private HashMap<String, Throwable> _entityExceptionMap = new HashMap();
    private HashMap<String, Throwable> _listenerExceptionMap = new HashMap();
    private HashMap<Path, RootContext> _persistenceRootMap = new HashMap();
    private ArrayList<RootContext> _pendingRootList = new ArrayList();
    private ArrayList<AmberPersistenceUnit> _pendingUnitList = new ArrayList();
    private ArrayList<LazyEntityManagerFactory> _pendingFactoryList = new ArrayList();
    private HashSet<URL> _persistenceURLSet = new HashSet();
    private ArrayList<String> _pendingClasses = new ArrayList();

    private AmberContainer(ClassLoader loader) {
        this._parentAmberContainer = _localContainer.get(loader);
        this._parentLoader = Environment.getEnvironmentClassLoader(loader);
        _localContainer.set(this, this._parentLoader);
        this._tempLoader = this._parentLoader.getNewTempClassLoader();
        this._enhancer = new AmberEnhancer(this);
        EnhancerManager.create(this._parentLoader).addClassEnhancer(this._enhancer);
        if (this._parentAmberContainer != null) {
            this.copyContainerDefaults(this._parentAmberContainer);
        }
        this._parentLoader.addScanListener(this);
        Environment.addEnvironmentListener(this, this._parentLoader);
        try {
            if (this._parentLoader instanceof DynamicClassLoader) {
                this._parentLoader.make();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static AmberContainer create() {
        return AmberContainer.create(Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AmberContainer create(ClassLoader loader) {
        EnvironmentLocal<AmberContainer> environmentLocal = _localContainer;
        synchronized (environmentLocal) {
            AmberContainer container = _localContainer.getLevel(loader);
            if (container == null) {
                container = new AmberContainer(loader);
                _localContainer.set(container, loader);
            }
            return container;
        }
    }

    public static AmberContainer getCurrent() {
        return AmberContainer.getCurrent(Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AmberContainer getCurrent(ClassLoader loader) {
        EnvironmentLocal<AmberContainer> environmentLocal = _localContainer;
        synchronized (environmentLocal) {
            return _localContainer.get(loader);
        }
    }

    public void setDataSource(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this._dataSource;
    }

    public void setReadDataSource(DataSource dataSource) {
        this._readDataSource = dataSource;
    }

    public DataSource getReadDataSource() {
        return this._readDataSource;
    }

    public void setXADataSource(DataSource dataSource) {
        this._xaDataSource = dataSource;
    }

    public DataSource getXADataSource() {
        return this._xaDataSource;
    }

    public boolean getCreateDatabaseTables() {
        return this._createDatabaseTables;
    }

    public void setCreateDatabaseTables(boolean isCreate) {
        this._createDatabaseTables = isCreate;
    }

    public ClassLoader getParentClassLoader() {
        return this._parentLoader;
    }

    public ClassLoader getEnhancedLoader() {
        return this._parentLoader;
    }

    public AmberGenerator getGenerator() {
        return this._enhancer;
    }

    public static String getPersistenceUnitJndiPrefix() {
        return "java:comp/env/persistence/_amber_PersistenceUnit/";
    }

    public void addPersistenceUnitDefault(ConfigProgram program) {
        this._unitDefaultList.add(program);
    }

    public ArrayList<ConfigProgram> getPersistenceUnitDefaultList() {
        return this._unitDefaultList;
    }

    public void addPersistenceUnitProxy(String name, ArrayList<ConfigProgram> program) {
        ArrayList<ConfigProgram> oldProgram = this._unitDefaultMap.get(name);
        if (oldProgram == null) {
            oldProgram = new ArrayList();
        }
        oldProgram.addAll(program);
        this._unitDefaultMap.put(name, oldProgram);
    }

    public ArrayList<ConfigProgram> getProxyProgram(String name) {
        return this._unitDefaultMap.get(name);
    }

    public static String getPersistenceContextJndiPrefix() {
        return "java:comp/env/persistence/";
    }

    public ClassLoader getTempClassLoader() {
        return this._tempLoader;
    }

    public Class loadTempClass(String name) throws ClassNotFoundException {
        return Class.forName(name, false, this.getTempClassLoader());
    }

    private void copyContainerDefaults(AmberContainer parent) {
        this._dataSource = parent._dataSource;
        this._xaDataSource = parent._xaDataSource;
        this._readDataSource = parent._readDataSource;
        this._createDatabaseTables = parent._createDatabaseTables;
    }

    public void init() {
    }

    public EmbeddableType getEmbeddable(String className) {
        Throwable e = this._embeddableExceptionMap.get(className);
        if (e != null) {
            throw new AmberRuntimeException(e);
        }
        if (this._exception != null) {
            throw new AmberRuntimeException(this._exception);
        }
        return this._embeddableMap.get(className);
    }

    public EntityType getEntity(String className) {
        Throwable e = this._entityExceptionMap.get(className);
        if (e != null) {
            throw new AmberRuntimeException(e);
        }
        if (this._exception != null) {
            throw new AmberRuntimeException(this._exception);
        }
        return this._entityMap.get(className);
    }

    public MappedSuperclassType getMappedSuperclass(String className) {
        Throwable e = this._entityExceptionMap.get(className);
        if (e != null) {
            throw new AmberRuntimeException(e);
        }
        if (this._exception != null) {
            throw new AmberRuntimeException(this._exception);
        }
        MappedSuperclassType type = this._mappedSuperclassMap.get(className);
        return type;
    }

    public ListenerType getDefaultListener(String className) {
        return null;
    }

    public ListenerType getEntityListener(String className) {
        return null;
    }

    public ListenerType getListener(String className) {
        return null;
    }

    public ArrayList<ListenerType> getEntityListeners(String entityClassName) {
        return null;
    }

    public void addEntityException(String className, Throwable e) {
        this._entityExceptionMap.put(className, e);
    }

    public void addException(Throwable e) {
        if (this._exception == null) {
            this._exception = e;
            Environment.setConfigException(e);
        }
    }

    public Throwable getConfigException() {
        return this._exception;
    }

    public void addEmbeddable(String className, EmbeddableType type) {
        this._embeddableMap.put(className, type);
    }

    public void addEntity(String className, EntityType type) {
        this._entityMap.put(className, type);
    }

    public void addMappedSuperclass(String className, MappedSuperclassType type) {
        this._mappedSuperclassMap.put(className, type);
    }

    public void addDefaultListener(String className, ListenerType type) {
        this._defaultListenerMap.put(className, type);
    }

    public void addEntityListener(String entityClassName, ListenerType listenerType) {
        ArrayList<ListenerType> listenerList = this._entityListenerMap.get(entityClassName);
        if (listenerList == null) {
            listenerList = new ArrayList();
            this._entityListenerMap.put(entityClassName, listenerList);
        }
        listenerList.add(listenerType);
    }

    public void initEntityHomes() {
        throw new UnsupportedOperationException();
    }

    public EntityManagerFactory createEntityManagerFactory(PersistenceUnitInfo info) {
        Path path = Vfs.lookup(info.getPersistenceUnitRootUrl());
        this.addPersistenceUnit(path);
        String name = info.getPersistenceUnitName();
        this.configurePersistenceRoot(info);
        AmberPersistenceUnit pUnit = this.createPersistenceUnit(name);
        return this.getEntityManagerFactory(name);
    }

    public AmberPersistenceUnit createPersistenceUnit(String name) {
        AmberPersistenceUnit unit = this._unitMap.get(name);
        if (unit == null) {
            unit = new AmberPersistenceUnit(this, name);
            this._unitMap.put(unit.getName(), unit);
        }
        return unit;
    }

    public void start() {
        this.startPersistenceUnits();
    }

    public AmberPersistenceUnit getPersistenceUnit(String name) {
        if (this._exception != null) {
            throw new AmberRuntimeException(this._exception);
        }
        return this._unitMap.get(name);
    }

    public EntityManagerFactory getEntityManagerFactory(String name) {
        if (this._exception != null) {
            throw new AmberRuntimeException(this._exception);
        }
        EntityManagerFactory factory = this._factoryMap.get(name);
        if (factory != null) {
            return factory;
        }
        factory = this._factoryMap.get(name);
        if (factory != null) {
            return factory;
        }
        AmberPersistenceUnit amberUnit = this._unitMap.get(name);
        if (amberUnit != null) {
            factory = new AmberEntityManagerFactory(amberUnit);
            this._factoryMap.put(name, factory);
            return factory;
        }
        if ("".equals(name) && this._factoryMap.size() == 1) {
            return this._factoryMap.values().iterator().next();
        }
        if ("".equals(name) && this._unitMap.size() == 1) {
            amberUnit = this._unitMap.values().iterator().next();
            factory = new AmberEntityManagerFactory(amberUnit);
            this._factoryMap.put(name, factory);
            return factory;
        }
        if (this._parentAmberContainer != null) {
            return this._parentAmberContainer.getEntityManagerFactory(name);
        }
        return null;
    }

    public EntityManager getPersistenceContext(String name) {
        EntityManager context;
        if (this._exception != null) {
            throw new AmberRuntimeException(this._exception);
        }
        if ("".equals(name) && this._unitConfigList.size() > 0) {
            name = this._unitConfigList.get(0).getName();
        }
        if ((context = this._persistenceContextMap.get(name)) != null) {
            return context;
        }
        if ("".equals(name) && this._unitConfigList.size() > 0) {
            name = this._unitConfigList.get(0).getName();
        }
        if ((context = this._persistenceContextMap.get(name)) != null) {
            return context;
        }
        AmberPersistenceUnit amberUnit = this._unitMap.get(name);
        if (amberUnit != null) {
            context = new EntityManagerProxy(amberUnit);
            this._persistenceContextMap.put(name, context);
            return context;
        }
        return null;
    }

    public EntityManager getExtendedPersistenceContext(String name) {
        AmberPersistenceUnit amberUnit;
        if (this._exception != null) {
            throw new AmberRuntimeException(this._exception);
        }
        if ("".equals(name) && this._unitConfigList.size() > 0) {
            name = this._unitConfigList.get(0).getName();
        }
        if ("".equals(name) && this._unitConfigList.size() > 0) {
            name = this._unitConfigList.get(0).getName();
        }
        if ((amberUnit = this._unitMap.get(name)) != null) {
            return new EntityManagerExtendedProxy(amberUnit);
        }
        return null;
    }

    public void addPersistenceUnit(Path root) {
        if (this._persistenceRootMap.get(root) != null) {
            return;
        }
        RootContext context = new RootContext(root);
        this._persistenceRootMap.put(root, context);
        this._pendingRootList.add(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class loadProvider(URL url) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream is = null;
        try {
            String line;
            is = url.openStream();
            ReadStream in = Vfs.openRead(is);
            while ((line = in.readLine()) != null) {
                if ("".equals(line = line.trim()) || line.startsWith("#")) continue;
                Class<?> clazz = Class.forName(line, false, loader);
                return clazz;
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        finally {
            IoUtil.close(is);
        }
        return null;
    }

    private void configurePersistenceRoot(PersistenceUnitInfo info) {
        URL rootUrl = info.getPersistenceUnitRootUrl();
        String pUnitName = info.getPersistenceUnitName();
        Path root = Vfs.lookup(rootUrl);
        try {
            Path ormXml = root.lookup("META-INF/orm.xml");
            EntityMappingsConfig entityMappings = this.configureMappingFile(root, ormXml);
            try {
                if (log.isLoggable(Level.CONFIG)) {
                    log.config("Amber PersistenceUnit[" + pUnitName + "] configuring " + rootUrl);
                }
                ArrayList classes = new ArrayList();
                if (!info.excludeUnlistedClasses()) {
                    // empty if block
                }
                ArrayList<EntityMappingsConfig> entityMappingsList = new ArrayList<EntityMappingsConfig>();
                if (entityMappings != null) {
                    entityMappingsList.add(entityMappings);
                }
                AmberPersistenceUnit unit = this.init(info);
                this._pendingUnitList.add(unit);
                this._unitMap.put(unit.getName(), unit);
            }
            catch (Exception e) {
                this.addException(e);
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    private AmberPersistenceUnit init(PersistenceUnitInfo info) throws Exception {
        String name = info.getPersistenceUnitName();
        AmberPersistenceUnit unit = new AmberPersistenceUnit(this, name);
        unit.setJPA(true);
        if (info.getJtaDataSource() != null) {
            unit.setJtaDataSource(info.getJtaDataSource());
        }
        if (info.getNonJtaDataSource() != null) {
            unit.setNonJtaDataSource(info.getNonJtaDataSource());
        }
        unit.init();
        ClassLoader tempLoader = info.getNewTempClassLoader();
        for (String className : info.getManagedClassNames()) {
            Class<?> type = Class.forName(className, false, tempLoader);
            unit.addEntityClass(className, type);
        }
        unit.generate();
        return unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPersistenceUnits() {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._parentLoader);
            ArrayList<AmberPersistenceUnit> unitList = new ArrayList<AmberPersistenceUnit>(this._pendingUnitList);
            this._pendingUnitList.clear();
            ArrayList<LazyEntityManagerFactory> lazyEmfList = new ArrayList<LazyEntityManagerFactory>(this._pendingFactoryList);
            this._pendingFactoryList.clear();
            for (LazyEntityManagerFactory lazyEmf : lazyEmfList) {
                lazyEmf.init();
            }
            for (AmberPersistenceUnit unit : unitList) {
                unit.initEntityHomes();
            }
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    private EntityMappingsConfig configureMappingFile(Path root, Path xmlFile) throws Exception {
        EntityMappingsConfig entityMappings = null;
        if (xmlFile.exists()) {
            ReadStream is = xmlFile.openRead();
            entityMappings = new EntityMappingsConfig();
            entityMappings.setRoot(root);
            new Config().configure((Object)entityMappings, (InputStream)is, "com/caucho/amber/cfg/mapping-30.rnc");
        }
        return entityMappings;
    }

    private void lookupClass(String className, HashMap<String, Class> classMap, EntityMappingsConfig entityMappings) throws Exception {
        Class type = this.loadTempClass(className);
        if (type != null) {
            boolean isEntity = type.getAnnotation(Entity.class) != null;
            boolean isEmbeddable = type.getAnnotation(Embeddable.class) != null;
            boolean isMappedSuperclass = type.getAnnotation(MappedSuperclass.class) != null;
            MappedSuperclassConfig mappedSuperclassOrEntityConfig = null;
            if (entityMappings != null && (mappedSuperclassOrEntityConfig = entityMappings.getEntityConfig(className)) == null) {
                mappedSuperclassOrEntityConfig = entityMappings.getMappedSuperclass(className);
            }
            if (isEntity || isEmbeddable || isMappedSuperclass || mappedSuperclassOrEntityConfig != null) {
                classMap.put(className, type);
            }
        }
    }

    @Override
    public int getScanPriority() {
        return 0;
    }

    @Override
    public boolean isRootScannable(Path root, String packageRoot) {
        if (!root.lookup("META-INF/persistence.xml").canRead()) {
            return false;
        }
        RootContext context = this._persistenceRootMap.get(root);
        if (context == null) {
            context = new RootContext(root);
            this._pendingRootList.add(context);
            this._persistenceRootMap.put(root, context);
        }
        if (context.isScanComplete()) {
            return false;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " scanning " + root);
        }
        context.setScanComplete(true);
        return true;
    }

    @Override
    public ScanClass scanClass(Path root, String packageRoot, String className, int modifiers) {
        if (Modifier.isInterface(modifiers)) {
            return null;
        }
        if (Modifier.isAbstract(modifiers)) {
            return null;
        }
        if (Modifier.isFinal(modifiers)) {
            return null;
        }
        if (!Modifier.isPublic(modifiers)) {
            return null;
        }
        return ScanClassAllow.ALLOW;
    }

    @Override
    public boolean isScanMatchAnnotation(CharBuffer annotationName) {
        if (annotationName.matches("javax.persistence.Entity")) {
            return true;
        }
        if (annotationName.matches("javax.persistence.Embeddable")) {
            return true;
        }
        return annotationName.matches("javax.persistence.MappedSuperclass");
    }

    @Override
    public void classMatchEvent(EnvironmentClassLoader loader, Path root, String className) {
        RootContext context = this._persistenceRootMap.get(root);
        if (context == null) {
            context = new RootContext(root);
            this._persistenceRootMap.put(root, context);
            this._pendingRootList.add(context);
        }
        context.addClassName(className);
    }

    @Override
    public void environmentConfigure(EnvironmentClassLoader loader) {
    }

    @Override
    public void environmentBind(EnvironmentClassLoader loader) {
    }

    @Override
    public void environmentStart(EnvironmentClassLoader loader) {
        this.start();
    }

    @Override
    public void environmentStop(EnvironmentClassLoader loader) {
    }

    public String toString() {
        return "AmberContainer[" + this._parentLoader.getId() + "]";
    }

    class LazyEntityManagerFactory {
        private final ConfigPersistenceUnit _unit;
        private final PersistenceProvider _provider;
        private final Map _props;

        LazyEntityManagerFactory(ConfigPersistenceUnit unit, PersistenceProvider provider, Map props) {
            this._unit = unit;
            this._provider = provider;
            this._props = props;
        }

        void init() {
        }
    }
}

