/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.type.AmberType;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public class CharacterType
extends AmberType {
    private static final L10N L = new L10N(CharacterType.class);
    private static final CharacterType CHAR_TYPE = new CharacterType();

    private CharacterType() {
    }

    public static CharacterType create() {
        return CHAR_TYPE;
    }

    public String getName() {
        return "java.lang.Character";
    }

    public String generateCreateColumnSQL(AmberPersistenceUnit manager, int length, int precision, int scale) {
        return manager.getCreateColumnSQL(1, 0, precision, scale);
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print("com.caucho.amber.type.CharacterType.toChar(" + rs + ".getString(" + indexVar + " + " + index + "))");
        return index + 1;
    }

    public int generateLoadNative(JavaWriter out, int index) throws IOException {
        out.print("com.caucho.amber.type.CharacterType.toChar(rs.getString(columnNames[" + index + "]))");
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println("if (" + value + " == null)");
        out.println("  " + pstmt + ".setNull(" + index + "++, java.sql.Types.CHAR);");
        out.println("else");
        out.println("  " + pstmt + ".setString(" + index + "++, String.valueOf(" + value + "));");
    }

    public void generateSetNull(JavaWriter out, String pstmt, String index) throws IOException {
        out.println(pstmt + ".setNull(" + index + "++, java.sql.Types.CHAR);");
    }

    public static Character toChar(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        return new Character(value.charAt(0));
    }

    public Object getObject(ResultSet rs, int index) throws SQLException {
        String value = rs.getString(index);
        return value == null || value.length() == 0 ? null : new Character(value.charAt(0));
    }
}

