/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ant;

import com.caucho.env.repository.CommitBuilder;
import com.caucho.server.admin.WebAppDeployClient;
import java.util.HashMap;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResinDeployClientTask
extends Task {
    private String _server;
    private int _port = -1;
    private String _user;
    private String _message;
    private String _password;
    private String _stage = "production";
    private String _virtualHost = "default";
    private String _contextRoot;
    private String _version;

    public void setServer(String server) {
        this._server = server;
    }

    public String getServer() {
        return this._server;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public int getPort() {
        return this._port;
    }

    public void setUser(String user) {
        this._user = user;
    }

    public String getUser() {
        return this._user;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public String getPassword() {
        return this._password;
    }

    public void setCommitMessage(String message) {
        this._message = message;
    }

    public String getCommitMessage() {
        return this._message;
    }

    public void setStage(String stage) {
        this._stage = stage;
    }

    public String getStage() {
        return this._stage;
    }

    public void setVirtualHost(String virtualHost) {
        this._virtualHost = virtualHost;
    }

    public String getVirtualHost() {
        return this._virtualHost;
    }

    public void setContextRoot(String contextRoot) {
        this._contextRoot = contextRoot;
    }

    public String getContextRoot() {
        return this._contextRoot;
    }

    public void setVersion(String version) {
        this._version = version;
    }

    public String getVersion() {
        return this._version;
    }

    protected CommitBuilder buildWarTag() {
        CommitBuilder builder = new CommitBuilder();
        builder.type("webapp");
        builder.stage(this._stage);
        builder.tagKey(this._virtualHost + this._contextRoot);
        return builder;
    }

    protected CommitBuilder buildVersionedWarTag() {
        return this.buildWarTag();
    }

    protected void validate() throws BuildException {
        if (this._server == null) {
            throw new BuildException("server is required by " + this.getTaskName());
        }
        if (this._port == -1) {
            throw new BuildException("port is required by " + this.getTaskName());
        }
        if (this._user == null) {
            throw new BuildException("user is required by " + this.getTaskName());
        }
    }

    protected abstract void doTask(WebAppDeployClient var1) throws BuildException;

    protected HashMap<String, String> getCommitAttributes() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("user", this._user);
        attributes.put("message", this._message);
        attributes.put("version", this._version);
        attributes.put("user.name", System.getProperties().getProperty("user.name"));
        attributes.put("client", "ant (" + ((Object)((Object)this)).getClass().getSimpleName() + ")");
        return attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        this.validate();
        ClassLoader loader = WebAppDeployClient.class.getClassLoader();
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        Logger clientLogger = Logger.getLogger(WebAppDeployClient.class.getName());
        AntLogHandler antLogHandler = new AntLogHandler();
        boolean useParentHandlers = clientLogger.getUseParentHandlers();
        Level oldLevel = clientLogger.getLevel();
        try {
            clientLogger.setLevel(Level.ALL);
            clientLogger.setUseParentHandlers(false);
            clientLogger.addHandler(antLogHandler);
            thread.setContextClassLoader(loader);
            this.doTask(new WebAppDeployClient(this._server, this._port, this._user, this._password));
        }
        finally {
            thread.setContextClassLoader(oldLoader);
            clientLogger.removeHandler(antLogHandler);
            clientLogger.setUseParentHandlers(useParentHandlers);
            clientLogger.setLevel(oldLevel);
        }
    }

    private class AntLogHandler
    extends Handler {
        private AntLogHandler() {
        }

        public void close() throws SecurityException {
        }

        public void flush() {
        }

        public void publish(LogRecord record) {
            if (Level.ALL.equals(record.getLevel()) || Level.INFO.equals(record.getLevel()) || Level.CONFIG.equals(record.getLevel())) {
                ResinDeployClientTask.this.log(record.getMessage());
            } else if (Level.FINE.equals(record.getLevel())) {
                ResinDeployClientTask.this.log(record.getMessage(), 3);
            } else if (Level.FINER.equals(record.getLevel()) || Level.FINEST.equals(record.getLevel())) {
                ResinDeployClientTask.this.log(record.getMessage(), 4);
            } else if (Level.SEVERE.equals(record.getLevel())) {
                ResinDeployClientTask.this.log(record.getMessage(), 0);
            } else if (Level.WARNING.equals(record.getLevel())) {
                ResinDeployClientTask.this.log(record.getMessage(), 1);
            }
        }
    }
}

