/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ant;

import com.caucho.ant.ResinDeployClientTask;
import com.caucho.env.repository.CommitBuilder;
import com.caucho.server.admin.WebAppDeployClient;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.util.HashMap;
import org.apache.tools.ant.BuildException;

public class ResinUploadWar
extends ResinDeployClientTask {
    private String _warFile;
    private String _archive;
    private boolean _writeHead = true;

    public void setWarFile(String warFile) throws BuildException {
        if (!warFile.endsWith(".war")) {
            throw new BuildException("war-file must have .war extension");
        }
        this._warFile = warFile;
        if (this.getContextRoot() == null) {
            int lastSlash = this._warFile.lastIndexOf("/");
            if (lastSlash < 0) {
                lastSlash = 0;
            }
            int end = this._warFile.length() - ".war".length();
            String name = this._warFile.substring(lastSlash, end);
            this.setContextRoot(name);
        }
    }

    public void setArchive(String tag) {
        this._archive = tag;
    }

    public void setWriteHead(boolean writeHead) {
        this._writeHead = writeHead;
    }

    protected void validate() throws BuildException {
        super.validate();
        if (this._warFile == null) {
            throw new BuildException("war-file is required by " + this.getTaskName());
        }
    }

    protected void doTask(WebAppDeployClient client) throws BuildException {
        try {
            Path path = Vfs.lookup(this._warFile);
            String archiveTag = this._archive;
            if ("true".equals(archiveTag)) {
                archiveTag = WebAppDeployClient.createArchiveTag(this.getVirtualHost(), this.getContextRoot(), this.getVersion());
            } else if ("false".equals(archiveTag)) {
                archiveTag = null;
            }
            CommitBuilder tag = this.buildVersionedWarTag();
            HashMap<String, String> attributes = this.getCommitAttributes();
            client.commitArchive(tag, path);
            this.log("Deployed " + path + " to tag " + tag);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }
}

