/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bam;

import com.caucho.bam.ActorClient;
import com.caucho.bam.ActorClientFactory;
import com.caucho.bam.ActorError;
import com.caucho.bam.ActorStream;
import com.caucho.bam.QueryCallback;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalActorClient
implements ActorClient {
    private static final Logger log = Logger.getLogger(LocalActorClient.class.getName());
    private static final WeakHashMap<ClassLoader, SoftReference<ActorClientFactory>> _factoryMap = new WeakHashMap();
    private ActorClient _client;

    public LocalActorClient() {
        this(null, null);
    }

    public LocalActorClient(String uid) {
        this(uid, null);
    }

    public LocalActorClient(String uid, String password) {
        this._client = this.getFactory().createClient(uid, this.getClass().getSimpleName());
    }

    public String getJid() {
        return this._client.getJid();
    }

    public void setClientStream(ActorStream stream) {
        this._client.setClientStream(stream);
    }

    public ActorStream getClientStream() {
        return this._client.getClientStream();
    }

    public ActorStream getActorStream() {
        return this._client.getActorStream();
    }

    public ActorStream getLinkStream() {
        return this._client.getLinkStream();
    }

    public void setLinkStream(ActorStream linkStream) {
        this._client.setLinkStream(linkStream);
    }

    public void message(String to, Serializable payload) {
        this._client.message(to, payload);
    }

    public Serializable queryGet(String to, Serializable payload) {
        return this._client.queryGet(to, payload);
    }

    public Serializable queryGet(String to, Serializable payload, long timeout) {
        return this._client.queryGet(to, payload, timeout);
    }

    public void queryGet(String to, Serializable payload, QueryCallback callback) {
        this._client.queryGet(to, payload, callback);
    }

    public Serializable querySet(String to, Serializable payload) {
        return this._client.querySet(to, payload);
    }

    public Serializable querySet(String to, Serializable payload, long timeout) {
        return this._client.querySet(to, payload, timeout);
    }

    public void querySet(String to, Serializable payload, QueryCallback callback) {
        this._client.querySet(to, payload, callback);
    }

    public boolean isClosed() {
        return this._client.isClosed();
    }

    public void close() {
        this._client.close();
    }

    public final boolean onQueryResult(long id, String to, String from, Serializable payload) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public final boolean onQueryError(long id, String to, String from, Serializable payload, ActorError error) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActorClientFactory getFactory() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        ActorClientFactory factory = null;
        WeakHashMap<ClassLoader, SoftReference<ActorClientFactory>> weakHashMap = _factoryMap;
        synchronized (weakHashMap) {
            SoftReference<ActorClientFactory> factoryRef = _factoryMap.get(loader);
            if (factoryRef != null && (factory = factoryRef.get()) != null) {
                return factory;
            }
        }
        try {
            String name = this.readFactoryClassName();
            if (name != null) {
                Class<?> cl = Class.forName(name, false, loader);
                factory = (ActorClientFactory)cl.newInstance();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (factory == null) {
            throw new IllegalStateException("Can't find a valid ActorClient");
        }
        weakHashMap = _factoryMap;
        synchronized (weakHashMap) {
            _factoryMap.put(loader, new SoftReference<ActorClientFactory>(factory));
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readFactoryClassName() {
        InputStream is = null;
        try {
            int ch;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            is = loader.getResourceAsStream("META-INF/services/com.caucho.bam.ClientActorFactory");
            if (is == null) {
                String string = null;
                return string;
            }
            StringBuilder sb = new StringBuilder();
            while ((ch = is.read()) >= 0) {
                if (ch == 13 || ch == 10) {
                    String line = sb.toString();
                    int p = line.indexOf(35);
                    if (p > 0) {
                        line = line.substring(0, p);
                    }
                    if ((line = line.trim()).length() > 0) {
                        String string = line;
                        return string;
                    }
                    sb = new StringBuilder();
                    continue;
                }
                sb.append((char)ch);
            }
            return null;
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._client.getJid() + "]";
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }
}

