/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bam;

import com.caucho.bam.ActorError;
import com.caucho.bam.ActorException;
import com.caucho.bam.QueryCallback;
import com.caucho.bam.QueryFuture;
import com.caucho.bam.TimeoutException;
import com.caucho.util.Alarm;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;

public class QueryManager {
    private final AtomicLong _qId = new AtomicLong();
    private final QueryMap _queryMap = new QueryMap();

    public QueryManager() {
    }

    public QueryManager(long seed) {
        this._qId.set(seed);
    }

    public final long generateQueryId() {
        return this._qId.incrementAndGet();
    }

    public void addQueryCallback(long id, QueryCallback callback) {
        this._queryMap.add(id, callback);
    }

    public QueryFuture addQueryFuture(long id, String to, String from, Serializable payload, long timeout) {
        QueryFutureImpl future = new QueryFutureImpl(id, to, from, payload, timeout);
        this._queryMap.add(id, future);
        return future;
    }

    public final boolean onQueryResult(long id, String to, String from, Serializable payload) {
        QueryItem item = this._queryMap.remove(id);
        if (item != null) {
            item.onQueryResult(to, from, payload);
            return true;
        }
        return false;
    }

    public final boolean onQueryError(long id, String to, String from, Serializable payload, ActorError error) {
        QueryItem item = this._queryMap.remove(id);
        if (item != null) {
            item.onQueryError(to, from, payload, error);
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }

    static final class QueryFutureImpl
    implements QueryCallback,
    QueryFuture {
        private final long _id;
        private final String _to;
        private final String _from;
        private final Serializable _payload;
        private final long _timeout;
        private volatile Serializable _result;
        private volatile ActorError _error;
        private final AtomicBoolean _isResult = new AtomicBoolean();
        private volatile Thread _thread;

        QueryFutureImpl(long id, String to, String from, Serializable payload, long timeout) {
            this._id = id;
            this._to = to;
            this._from = from;
            this._payload = payload;
            this._timeout = timeout;
        }

        public Serializable getResult() {
            return this._result;
        }

        public Serializable get() throws TimeoutException, ActorException {
            if (!this.waitFor(this._timeout)) {
                throw new TimeoutException(this + " query timeout " + this._payload + " {to:" + this._to + "}");
            }
            if (this.getError() != null) {
                throw this.getError().createException();
            }
            return this.getResult();
        }

        public ActorError getError() {
            return this._error;
        }

        boolean waitFor(long timeout) {
            this._thread = Thread.currentThread();
            long now = Alarm.getCurrentTimeActual();
            long expires = now + timeout;
            while (!this._isResult.get() && Alarm.getCurrentTimeActual() < expires) {
                try {
                    Thread.interrupted();
                    LockSupport.parkUntil(expires);
                }
                catch (Exception e) {}
            }
            this._thread = null;
            return this._isResult.get();
        }

        public void onQueryResult(String fromJid, String toJid, Serializable payload) {
            this._result = payload;
            this._isResult.set(true);
            Thread thread = this._thread;
            if (thread != null) {
                LockSupport.unpark(thread);
            }
        }

        public void onQueryError(String fromJid, String toJid, Serializable payload, ActorError error) {
            this._error = error;
            this._isResult.set(true);
            Thread thread = this._thread;
            if (thread != null) {
                LockSupport.unpark(thread);
            }
        }
    }

    static final class QueryItem {
        private final long _id;
        private final QueryCallback _callback;
        private QueryItem _next;

        QueryItem(long id, QueryCallback callback, QueryItem next) {
            this._id = id;
            this._callback = callback;
            this._next = next;
        }

        final long getId() {
            return this._id;
        }

        final QueryItem getNext() {
            return this._next;
        }

        final void setNext(QueryItem next) {
            this._next = next;
        }

        void onQueryResult(String to, String from, Serializable value) {
            if (this._callback != null) {
                this._callback.onQueryResult(to, from, value);
            }
        }

        void onQueryError(String to, String from, Serializable value, ActorError error) {
            if (this._callback != null) {
                this._callback.onQueryError(to, from, value, error);
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._id + "," + this._callback + "]";
        }
    }

    static final class QueryMap {
        private final QueryItem[] _entries = new QueryItem[128];
        private final int _mask = this._entries.length - 1;

        QueryMap() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(long id, QueryCallback callback) {
            int hash = (int)(id & (long)this._mask);
            QueryItem[] queryItemArray = this._entries;
            synchronized (this._entries) {
                this._entries[hash] = new QueryItem(id, callback, this._entries[hash]);
                // ** MonitorExit[var5_4] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        QueryItem remove(long id) {
            int hash = (int)(id & (long)this._mask);
            QueryItem[] queryItemArray = this._entries;
            synchronized (this._entries) {
                QueryItem prev = null;
                for (QueryItem ptr = this._entries[hash]; ptr != null; ptr = ptr.getNext()) {
                    if (id == ptr.getId()) {
                        if (prev != null) {
                            prev.setNext(ptr.getNext());
                        } else {
                            this._entries[hash] = ptr.getNext();
                        }
                        // ** MonitorExit[var4_3] (shouldn't be in output)
                        return ptr;
                    }
                    prev = ptr;
                }
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return null;
            }
        }
    }
}

