/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bam;

import com.caucho.bam.AbstractActorStreamFilter;
import com.caucho.bam.ActorError;
import com.caucho.bam.ActorProxy;
import com.caucho.bam.ActorStream;
import com.caucho.bam.Broker;
import com.caucho.bam.QueryCallback;
import com.caucho.bam.QueryFuture;
import com.caucho.bam.QueryManager;
import com.caucho.bam.SimpleActorStream;
import java.io.Serializable;

public class SimpleActorProxy
implements ActorProxy {
    private String _jid;
    private String _toJid;
    private ActorStream _actorStream;
    private ActorStream _linkStream;
    private ActorStream _clientStream;
    private final QueryManager _queryManager = new QueryManager();
    private long _timeout = 10000L;

    protected SimpleActorProxy(String toJid) {
        this._toJid = toJid;
        this._actorStream = new QueryFilterStream();
    }

    public SimpleActorProxy(Broker broker, String toJid, String uid, String resource) {
        this(toJid);
        this._linkStream = broker.getBrokerStream();
        this._jid = broker.createClient(this._actorStream, uid, resource);
    }

    public String getJid() {
        return this._jid;
    }

    public String getTo() {
        return this._toJid;
    }

    public void setClientStream(ActorStream clientStream) {
        this._clientStream = clientStream;
    }

    public ActorStream getClientStream() {
        return this._clientStream;
    }

    public void setActorStream(ActorStream actorStream) {
        this._actorStream = actorStream;
    }

    public ActorStream getActorStream() {
        return this._actorStream;
    }

    public ActorStream getLinkStream() {
        return this._linkStream;
    }

    public void setLinkStream(ActorStream linkStream) {
        this._linkStream = linkStream;
    }

    public void message(Serializable payload) {
        ActorStream linkStream = this.getLinkStream();
        if (linkStream == null) {
            throw new IllegalStateException(this + " can't send a message because the link is closed.");
        }
        linkStream.message(this.getTo(), this.getJid(), payload);
    }

    public Serializable queryGet(Serializable payload) {
        ActorStream linkStream = this.getLinkStream();
        if (linkStream == null) {
            throw new IllegalStateException(this + " can't send a query because the link is closed.");
        }
        long id = this._queryManager.generateQueryId();
        QueryFuture future = this._queryManager.addQueryFuture(id, this.getTo(), this.getJid(), payload, this._timeout);
        linkStream.queryGet(id, this.getTo(), this.getJid(), payload);
        return future.get();
    }

    public Serializable queryGet(Serializable payload, long timeout) {
        ActorStream linkStream = this.getLinkStream();
        if (linkStream == null) {
            throw new IllegalStateException(this + " can't send a query because the link is closed.");
        }
        long id = this._queryManager.generateQueryId();
        QueryFuture future = this._queryManager.addQueryFuture(id, this.getTo(), this.getJid(), payload, timeout);
        linkStream.queryGet(id, this.getTo(), this.getJid(), payload);
        return future.get();
    }

    public void queryGet(Serializable payload, QueryCallback callback) {
        ActorStream linkStream = this.getLinkStream();
        if (linkStream == null) {
            throw new IllegalStateException(this + " can't send a query because the link is closed.");
        }
        long id = this._queryManager.generateQueryId();
        this._queryManager.addQueryCallback(id, callback);
        linkStream.queryGet(id, this.getTo(), this.getJid(), payload);
    }

    public Serializable querySet(Serializable payload) {
        ActorStream linkStream = this.getLinkStream();
        if (linkStream == null) {
            throw new IllegalStateException(this + " can't send a query because the link is closed.");
        }
        long id = this._queryManager.generateQueryId();
        QueryFuture future = this._queryManager.addQueryFuture(id, this.getTo(), this.getJid(), payload, this._timeout);
        linkStream.querySet(id, this.getTo(), this.getJid(), payload);
        return future.get();
    }

    public Serializable querySet(Serializable payload, long timeout) {
        ActorStream linkStream = this.getLinkStream();
        if (linkStream == null) {
            throw new IllegalStateException(this + " can't send a query because the link is closed.");
        }
        long id = this._queryManager.generateQueryId();
        QueryFuture future = this._queryManager.addQueryFuture(id, this.getTo(), this.getJid(), payload, this._timeout);
        linkStream.querySet(id, this.getTo(), this.getJid(), payload);
        return future.get();
    }

    public void querySet(Serializable payload, QueryCallback callback) {
        ActorStream linkStream = this.getLinkStream();
        if (linkStream == null) {
            throw new IllegalStateException(this + " can't send a query because the link is closed.");
        }
        long id = this._queryManager.generateQueryId();
        this._queryManager.addQueryCallback(id, callback);
        linkStream.querySet(id, this.getTo(), this.getJid(), payload);
    }

    public boolean isClosed() {
        return false;
    }

    public void close() {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getJid() + ",to=" + this.getTo() + "]";
    }

    final class QueryFilterStream
    extends AbstractActorStreamFilter {
        QueryFilterStream() {
        }

        protected ActorStream getNext() {
            ActorStream clientStream = SimpleActorProxy.this.getClientStream();
            if (clientStream == null) {
                clientStream = new SimpleActorStream();
            }
            return clientStream;
        }

        public void queryResult(long id, String to, String from, Serializable payload) {
            if (SimpleActorProxy.this._queryManager.onQueryResult(id, to, from, payload)) {
                return;
            }
            super.queryResult(id, to, from, payload);
        }

        public void queryError(long id, String to, String from, Serializable payload, ActorError error) {
            if (SimpleActorProxy.this._queryManager.onQueryError(id, to, from, payload, error)) {
                return;
            }
            super.queryError(id, to, from, payload, error);
        }
    }
}

