/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bam;

import com.caucho.bam.ActorError;
import com.caucho.bam.ActorStream;
import com.caucho.bam.Skeleton;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SimpleActorStream
implements ActorStream {
    private static final Logger log = Logger.getLogger(SimpleActorStream.class.getName());
    private final Skeleton _skeleton = Skeleton.getSkeleton(this.getClass());
    private String _jid;
    private ActorStream _linkStream;

    public String getJid() {
        return this._jid;
    }

    public void setJid(String jid) {
        this._jid = jid;
    }

    public ActorStream getLinkStream() {
        return this._linkStream;
    }

    public void setLinkStream(ActorStream linkStream) {
        this._linkStream = linkStream;
    }

    public void message(String to, String from, Serializable payload) {
        this._skeleton.message(this, to, from, payload);
    }

    public void messageError(String to, String from, Serializable payload, ActorError error) {
        this._skeleton.messageError(this, to, from, payload, error);
    }

    public void queryGet(long id, String to, String from, Serializable payload) {
        this._skeleton.queryGet(this, this.getLinkStream(), id, to, from, payload);
    }

    public void querySet(long id, String to, String from, Serializable payload) {
        this._skeleton.querySet(this, this.getLinkStream(), id, to, from, payload);
    }

    public void queryResult(long id, String to, String from, Serializable payload) {
        this._skeleton.queryResult(this, id, to, from, payload);
    }

    public void queryError(long id, String to, String from, Serializable payload, ActorError error) {
        this._skeleton.queryError(this, id, to, from, payload, error);
    }

    protected Skeleton getSkeleton() {
        return this._skeleton;
    }

    protected void messageFallback(String to, String from, Serializable payload) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " message ignored " + payload + " {from: " + from + " to: " + to + "}");
        }
    }

    protected void messageErrorFallback(String to, String from, Serializable payload, ActorError error) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " messageError ignored " + error + " " + payload + " {from: " + from + " to: " + to + "}");
        }
    }

    protected void queryGetFallback(long id, String to, String from, Serializable payload) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " queryGet not implemented for " + payload + " {id: " + id + ", from: " + from + " to: " + to + "}");
        }
        String msg = this + ": queryGet is not implemented for this payload:\n" + "  " + payload + " {id:" + id + ", from:" + from + ", to:" + to + "}";
        ActorError error = new ActorError("cancel", "feature-not-implemented", msg);
        this.getLinkStream().queryError(id, from, to, payload, error);
    }

    protected void querySetFallback(long id, String to, String from, Serializable payload) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " querySet not implemented for " + payload + " {id: " + id + ", from: " + from + " to: " + to + "}");
        }
        String msg = this + ": querySet is not implemented for this payload:\n" + "  " + payload + " {id:" + id + ", from:" + from + ", to:" + to + "}";
        ActorError error = new ActorError("cancel", "feature-not-implemented", msg);
        this.getLinkStream().queryError(id, from, to, payload, error);
    }

    protected void queryResultFallback(long id, String to, String from, Serializable payload) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " queryResult not implemented for " + payload + " {id: " + id + ", from: " + from + " to: " + to + "}");
        }
    }

    protected void queryErrorFallback(long id, String to, String from, Serializable payload, ActorError error) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " queryError ignored " + error + " " + payload + " {id: " + id + ", from: " + from + " to: " + to + "}");
        }
    }

    public boolean isClosed() {
        return false;
    }

    public void close() {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getJid() + "]";
    }
}

