/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bam;

import com.caucho.bam.ActorError;
import com.caucho.bam.ActorException;
import com.caucho.bam.ActorStream;
import com.caucho.bam.Message;
import com.caucho.bam.MessageError;
import com.caucho.bam.QueryError;
import com.caucho.bam.QueryGet;
import com.caucho.bam.QueryResult;
import com.caucho.bam.QuerySet;
import com.caucho.bam.SimpleActorStream;
import com.caucho.bam.SkeletonInvocationException;
import com.caucho.util.L10N;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Skeleton<S extends SimpleActorStream> {
    private static final L10N L = new L10N(Skeleton.class);
    private static final Logger log = Logger.getLogger(Skeleton.class.getName());
    private static final WeakHashMap<Class<?>, SoftReference<Skeleton>> _skeletonRefMap = new WeakHashMap();
    private Class<?> _cl;
    private final HashMap<Class<?>, Method> _messageHandlers = new HashMap();
    private final HashMap<Class<?>, Method> _messageErrorHandlers = new HashMap();
    private final HashMap<Class<?>, Method> _queryGetHandlers = new HashMap();
    private final HashMap<Class<?>, Method> _querySetHandlers = new HashMap();
    private final HashMap<Class<?>, Method> _queryResultHandlers = new HashMap();
    private final HashMap<Class<?>, Method> _queryErrorHandlers = new HashMap();

    private Skeleton(Class<S> cl) {
        this._cl = cl;
        log.finest(L.l("{0} introspecting class {1}", (Object)this, cl.getName()));
        this.introspect(cl);
    }

    public void message(S actor, String to, String from, Serializable payload) {
        Method handler = payload != null ? this._messageHandlers.get(payload.getClass()) : null;
        if (handler != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest(actor + " message " + payload + " {from:" + from + ", to:" + to + "}");
            }
            try {
                handler.invoke(actor, to, from, payload);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                throw SkeletonInvocationException.createRuntimeException(cause);
            }
            catch (Exception e) {
                throw SkeletonInvocationException.createRuntimeException(e);
            }
        } else {
            ((SimpleActorStream)actor).messageFallback(to, from, payload);
        }
    }

    public void messageError(S actor, String to, String from, Serializable payload, ActorError error) {
        Method handler = payload != null ? this._messageErrorHandlers.get(payload.getClass()) : null;
        if (handler != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest(actor + " messageError " + error + " " + payload + " {from:" + from + ", to:" + to + "}");
            }
            try {
                handler.invoke(actor, to, from, payload, error);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                throw SkeletonInvocationException.createRuntimeException(cause);
            }
            catch (Exception e) {
                throw SkeletonInvocationException.createRuntimeException(e);
            }
        } else {
            ((SimpleActorStream)actor).messageErrorFallback(to, from, payload, error);
        }
    }

    public void queryGet(S actor, ActorStream linkStream, long id, String to, String from, Serializable payload) {
        Method handler = payload != null ? this._queryGetHandlers.get(payload.getClass()) : null;
        if (handler != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest(actor + " queryGet " + payload + " {id: " + id + ", from:" + from + ", to:" + to + "}");
            }
            try {
                handler.invoke(actor, id, to, from, payload);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                throw SkeletonInvocationException.createRuntimeException(cause);
            }
            catch (Exception e) {
                throw SkeletonInvocationException.createRuntimeException(e);
            }
        } else {
            ((SimpleActorStream)actor).queryGetFallback(id, to, from, payload);
        }
    }

    public void querySet(S actor, ActorStream linkStream, long id, String to, String from, Serializable payload) {
        Method handler = payload != null ? this._querySetHandlers.get(payload.getClass()) : null;
        if (handler != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest(actor + " querySet " + payload + " {id: " + id + ", from:" + from + ", to:" + to + "}");
            }
            try {
                handler.invoke(actor, id, to, from, payload);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                throw SkeletonInvocationException.createRuntimeException(cause);
            }
            catch (Exception e) {
                throw SkeletonInvocationException.createRuntimeException(e);
            }
        } else {
            ((SimpleActorStream)actor).querySetFallback(id, to, from, payload);
        }
    }

    public void queryResult(S actor, long id, String to, String from, Serializable payload) {
        Method handler = payload != null ? this._queryResultHandlers.get(payload.getClass()) : null;
        if (handler != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest(actor + " queryResult " + payload + " {id: " + id + ", from:" + from + ", to:" + to + "}");
            }
            try {
                handler.invoke(actor, id, to, from, payload);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                throw SkeletonInvocationException.createRuntimeException(cause);
            }
            catch (Exception e) {
                throw SkeletonInvocationException.createRuntimeException(e);
            }
        } else {
            ((SimpleActorStream)actor).queryResultFallback(id, to, from, payload);
        }
    }

    public void queryError(S actor, long id, String to, String from, Serializable payload, ActorError error) {
        Method handler = payload != null ? this._queryErrorHandlers.get(payload.getClass()) : null;
        if (handler != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest(actor + " queryError " + error + " " + payload + " {id: " + id + ", from:" + from + ", to:" + to + "}");
            }
            try {
                handler.invoke(actor, id, to, from, payload, error);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                throw SkeletonInvocationException.createRuntimeException(cause);
            }
            catch (Exception e) {
                throw SkeletonInvocationException.createRuntimeException(e);
            }
        } else {
            ((SimpleActorStream)actor).queryErrorFallback(id, to, from, payload, error);
        }
    }

    protected void introspect(Class<?> cl) {
        if (cl == null) {
            return;
        }
        this.introspect(cl.getSuperclass());
        Method[] methods = cl.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            Class<?> payloadType = this.getPayloadType(Message.class, method);
            if (payloadType != null) {
                log.finest(L.l("{0} @Message {1} method={2}", this, payloadType.getName(), method));
                method.setAccessible(true);
                this._messageHandlers.put(payloadType, method);
                continue;
            }
            payloadType = this.getPayloadType(MessageError.class, method);
            if (payloadType != null) {
                log.finest(L.l("{0} @MessageError {1} method={2}", this, payloadType.getName(), method));
                method.setAccessible(true);
                this._messageErrorHandlers.put(payloadType, method);
                continue;
            }
            payloadType = this.getQueryPayloadType(QueryGet.class, method);
            if (payloadType != null) {
                log.finest(L.l("{0} @QueryGet {1} method={2}", this, payloadType.getName(), method));
                method.setAccessible(true);
                this._queryGetHandlers.put(payloadType, method);
                continue;
            }
            payloadType = this.getQueryPayloadType(QuerySet.class, method);
            if (payloadType != null) {
                log.finest(L.l("{0} @QuerySet {1} method={2}", this, payloadType.getName(), method));
                method.setAccessible(true);
                this._querySetHandlers.put(payloadType, method);
                continue;
            }
            payloadType = this.getQueryPayloadType(QueryResult.class, method);
            if (payloadType != null) {
                log.finest(L.l("{0} @QueryResult {1} method={2}", this, payloadType.getName(), method));
                method.setAccessible(true);
                this._queryResultHandlers.put(payloadType, method);
                continue;
            }
            payloadType = this.getQueryErrorPayloadType(QueryError.class, method);
            if (payloadType == null) continue;
            log.finest(L.l("{0} @QueryError {1} method={2}", this, payloadType.getName(), method));
            method.setAccessible(true);
            this._queryErrorHandlers.put(payloadType, method);
        }
    }

    private Class<?> getPayloadType(Class<? extends Annotation> annotationType, Method method) {
        Class<?>[] paramTypes = method.getParameterTypes();
        if (paramTypes.length < 3) {
            return null;
        }
        if (method.isAnnotationPresent(annotationType)) {
            return paramTypes[2];
        }
        return null;
    }

    private Class<?> getQueryPayloadType(Class<? extends Annotation> annotationType, Method method) {
        if (!method.isAnnotationPresent(annotationType)) {
            return null;
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        if (!(paramTypes.length == 4 && Long.TYPE.equals(paramTypes[0]) && String.class.equals(paramTypes[1]) && String.class.equals(paramTypes[2]) && Serializable.class.isAssignableFrom(paramTypes[3]))) {
            throw new ActorException(method + " is an invalid " + " @" + annotationType.getSimpleName() + " because queries require (long, String, String, MyPayload)");
        }
        return paramTypes[3];
    }

    private Class<?> getQueryErrorPayloadType(Class<? extends Annotation> annotationType, Method method) {
        if (!method.isAnnotationPresent(annotationType)) {
            return null;
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        if (!(paramTypes.length == 5 && Long.TYPE.equals(paramTypes[0]) && String.class.equals(paramTypes[1]) && String.class.equals(paramTypes[2]) && Serializable.class.isAssignableFrom(paramTypes[3]) && ActorError.class.isAssignableFrom(paramTypes[4]))) {
            throw new ActorException(method + " is an invalid " + " @" + annotationType.getSimpleName() + " because queries require (long, String, String, MyPayload, ActorError)");
        }
        return paramTypes[3];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Skeleton<? extends SimpleActorStream> getSkeleton(Class<? extends SimpleActorStream> cl) {
        WeakHashMap<Class<?>, SoftReference<Skeleton>> weakHashMap = _skeletonRefMap;
        synchronized (weakHashMap) {
            SoftReference<Skeleton> skeletonRef = _skeletonRefMap.get(cl);
            Skeleton<? extends SimpleActorStream> skeleton = null;
            if (skeletonRef != null) {
                skeleton = skeletonRef.get();
            }
            if (skeleton == null) {
                skeleton = new Skeleton<SimpleActorStream>(cl);
                _skeletonRefMap.put(cl, new SoftReference<Skeleton<? extends SimpleActorStream>>(skeleton));
            }
            return skeleton;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._cl.getName() + "]";
    }
}

