/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bayeux;

import com.caucho.bayeux.BayeuxClient;
import com.caucho.bayeux.BayeuxConnectionType;
import com.caucho.bayeux.ChannelTree;
import com.caucho.bayeux.JsonArray;
import com.caucho.bayeux.JsonDecoder;
import com.caucho.bayeux.JsonDecodingException;
import com.caucho.bayeux.JsonMap;
import com.caucho.bayeux.JsonObject;
import com.caucho.bayeux.JsonString;
import com.caucho.servlet.comet.CometController;
import com.caucho.servlet.comet.GenericCometServlet;
import com.caucho.util.L10N;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BayeuxServlet
extends GenericCometServlet {
    private static final Logger log = Logger.getLogger(BayeuxServlet.class.getName());
    private static final L10N L = new L10N(BayeuxServlet.class);
    private static final ChannelTree _root = new ChannelTree();
    private static final ConcurrentHashMap<String, BayeuxClient> _clients = new ConcurrentHashMap();

    public boolean service(ServletRequest req, ServletResponse resp, CometController controller) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        if (!"POST".equals(request.getMethod())) {
            response.sendError(405);
            return false;
        }
        try {
            JsonObject object;
            String message = request.getParameter("message");
            if (log.isLoggable(Level.FINEST)) {
                log.finest("message = " + message);
            }
            if (!((object = JsonDecoder.decode(message)) instanceof JsonArray)) {
                response.sendError(400);
                return false;
            }
            JsonArray array = (JsonArray)object;
            for (int i = 0; i < array.size(); ++i) {
                JsonMap map;
                JsonObject channelObject;
                if (!(array.get(i) instanceof JsonMap) || !((channelObject = (map = (JsonMap)array.get(i)).get("channel")) instanceof JsonString)) continue;
                String channel = channelObject.toString();
                if ("/meta/handshake".equals(channel)) {
                    this.handleHandshake(map, request, response, controller);
                    return false;
                }
                if ("/meta/connect".equals(channel)) {
                    return this.handleConnect(map, request, response, controller);
                }
                if (!"/meta/subscribe".equals(channel)) continue;
                return this.handleSubscribe(map, request, response, controller);
            }
            response.sendError(400, "Unknown channel");
            return false;
        }
        catch (JsonDecodingException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public boolean resume(ServletRequest request, ServletResponse response, CometController controller) throws IOException, ServletException {
        return false;
    }

    private void handleHandshake(JsonMap map, HttpServletRequest request, HttpServletResponse response, CometController controller) throws IOException, ServletException {
        PrintWriter out = response.getWriter();
        JsonObject version = map.get("version");
        JsonObject supportedConnectionTypes = map.get("supportedConnectionTypes");
        JsonObject minimumVersion = map.get("minimumVersion");
        JsonObject ext = map.get("ext");
        JsonObject id = map.get("id");
        if (version == null) {
            this.sendHandshakeResponse(out, null, id, false, "missing version");
            return;
        }
        if (supportedConnectionTypes == null) {
            this.sendHandshakeResponse(out, null, id, false, "missing supportedConnectionTypes");
            return;
        }
        UUID uuid = UUID.randomUUID();
        this.sendHandshakeResponse(out, uuid.toString(), id, true, null);
    }

    private void sendHandshakeResponse(PrintWriter out, String clientId, JsonObject id, boolean success, String error) throws IOException, ServletException {
        out.println("[");
        out.println("\t{");
        out.println("\t\t\"channel\": \"/meta/handshake\",");
        out.println("\t\t\"version\": \"1.0beta\",");
        out.println("\t\t\"supportedConnectionTypes\": [\"long-polling\", \"callback-polling\", \"iframe\"],");
        if (clientId != null) {
            out.println("\t\t\"clientId\": \"" + clientId + "\",");
        }
        out.println("\t\t\"successful\": \"" + success + "\",");
        if (id != null && id instanceof JsonString) {
            out.println("\t\t\"id\": \"" + id + "\",");
        }
        if (error != null) {
            out.println("\t\t\"error\": \"" + error + "\",");
        }
        out.println("\t}");
        out.println("]");
    }

    private boolean handleConnect(JsonMap map, HttpServletRequest request, HttpServletResponse response, CometController controller) throws IOException, ServletException {
        PrintWriter out = response.getWriter();
        JsonObject clientId = map.get("clientId");
        JsonObject connectionType = map.get("connectionType");
        JsonObject ext = map.get("ext");
        JsonObject id = map.get("id");
        BayeuxClient client = _clients.get(clientId);
        for (BayeuxConnectionType type : BayeuxConnectionType.values()) {
            if (!type.toString().equals(connectionType)) continue;
            client = new BayeuxClient(controller, clientId.toString(), type);
            _clients.put(clientId.toString(), client);
            this.sendConnectResponse(out, clientId, id, true, null);
            return true;
        }
        this.sendConnectResponse(out, clientId, id, false, "bad connection type");
        return false;
    }

    private void sendConnectResponse(PrintWriter out, JsonObject clientId, JsonObject id, boolean success, String error) throws IOException, ServletException {
        out.println("[");
        out.println("\t{");
        out.println("\t\t\"channel\": \"/meta/connect\",");
        if (clientId != null) {
            out.println("\t\t\"clientId\": \"" + clientId + "\",");
        }
        out.println("\t\t\"successful\": \"" + success + "\",");
        if (id != null) {
            out.println("\t\t\"id\": \"" + id + "\",");
        }
        if (error != null) {
            out.println("\t\t\"error\": \"" + error + "\",");
        }
        out.println("\t}");
        out.println("]");
    }

    private boolean handleSubscribe(JsonMap map, HttpServletRequest request, HttpServletResponse response, CometController controller) throws IOException, ServletException {
        PrintWriter out = response.getWriter();
        JsonObject clientId = map.get("clientId");
        JsonObject subscription = map.get("subscription");
        JsonObject id = map.get("id");
        JsonObject ext = map.get("ext");
        BayeuxClient client = _clients.get(clientId);
        if (client == null) {
            this.sendSubcribeResponse(out, clientId, subscription, id, false, "Unknown client");
            return false;
        }
        _root.subscribe(subscription.toString(), client);
        this.sendSubcribeResponse(out, clientId, subscription, id, true, null);
        return false;
    }

    private void sendSubcribeResponse(PrintWriter out, JsonObject clientId, JsonObject subscription, JsonObject id, boolean success, String error) throws IOException, ServletException {
        out.println("[");
        out.println("\t{");
        out.println("\t\t\"channel\": \"/meta/subscribe\",");
        if (clientId != null) {
            out.println("\t\t\"clientId\": \"" + clientId + "\",");
        }
        if (subscription != null) {
            out.println("\t\t\"subscription\": \"" + subscription + "\",");
        }
        out.println("\t\t\"successful\": \"" + success + "\",");
        if (id != null) {
            out.println("\t\t\"id\": \"" + id + "\",");
        }
        if (error != null) {
            out.println("\t\t\"error\": \"" + error + "\",");
        }
        out.println("\t}");
        out.println("]");
    }
}

